/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common;

import com.google.common.collect.ImmutableMap;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import io.izzel.arclight.api.EnumHelper;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.mod.util.log.ArclightI18nLogger;
import io.izzel.arclight.common.mod.util.log.ArclightLazyLogManager;
import io.izzel.arclight.common.util.EnumTypeFactory;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.i18n.ArclightLocale;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.server.ServerMain;

public abstract class ArclightMain {
    private static final int MIN_DEPRECATED_VERSION = 60;
    private static final int MIN_DEPRECATED_JAVA_VERSION = 16;

    public void run(String[] args) throws Throwable {
        System.setProperty("java.util.logging.manager", ArclightLazyLogManager.class.getCanonicalName());
        System.setProperty("log4j.jul.LoggerAdapter", "io.izzel.arclight.common.mod.util.log.ArclightLoggerAdapter");
        ArclightLocale.info("i18n.using-language", ArclightConfig.spec().getLocale().getCurrent(), ArclightConfig.spec().getLocale().getFallback());
        this.afterSetup();
        try {
            int javaVersion = (int)Float.parseFloat(System.getProperty("java.class.version"));
            if (javaVersion < 60) {
                ArclightLocale.error("java.deprecated", System.getProperty("java.version"), 16);
                Thread.sleep(3000L);
            }
            Unsafe.ensureClassInitialized(EnumHelper.class);
        }
        catch (Throwable t) {
            System.err.println("Your Java is not compatible with Arclight.");
            t.printStackTrace();
            return;
        }
        try {
            this.printLogo();
            this.beforeStart();
            this.dirtyHacks();
            ServerMain.main((String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Fail to launch Arclight.");
        }
    }

    private void dirtyHacks() throws Exception {
        TypeAdapters.ENUM_FACTORY.create(null, TypeToken.get(ArclightMain.class));
        Field field = TypeAdapters.class.getDeclaredField("ENUM_FACTORY");
        Object base = Unsafe.staticFieldBase(field);
        long offset = Unsafe.staticFieldOffset(field);
        Unsafe.putObjectVolatile(base, offset, new EnumTypeFactory());
    }

    private void printLogo() throws Exception {
        URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + uri), ImmutableMap.of("create", "true"));
        try (InputStream stream = Files.newInputStream(fs.getPath("/META-INF/MANIFEST.MF", new String[0]), new OpenOption[0]);){
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String buildTime = attributes.getValue("Implementation-Timestamp");
            ArclightI18nLogger.getLogger("Arclight").info("logo", (Object)version, (Object)buildTime);
        }
    }

    protected void afterSetup() throws Throwable {
    }

    protected void beforeStart() throws Throwable {
    }
}

