/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.asm;

import com.google.common.io.ByteStreams;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import io.izzel.arclight.api.ArclightVersion;
import io.izzel.arclight.common.asm.ArclightImplementer;
import io.izzel.arclight.common.asm.Implementer;
import io.izzel.arclight.i18n.LocalizedException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InventoryImplementer
implements Implementer {
    private static final Marker MARKER = MarkerManager.getMarker((String)"INVENTORY");
    private static final String INV_TYPE = "net/minecraft/inventory/IInventory";
    private static final String BRIDGE_TYPE = "io/izzel/arclight/common/bridge/inventory/IInventoryBridge";
    private final Map<String, Integer> map = new ConcurrentHashMap<String, Integer>();

    public InventoryImplementer() {
        this.map.put(INV_TYPE, 1);
        this.map.put("java/lang/Object", 0);
    }

    @Override
    public boolean processClass(ClassNode node, ILaunchPluginService.ITransformerLoader transformerLoader) {
        try {
            if (Modifier.isInterface(node.access) || node.interfaces.contains(BRIDGE_TYPE)) {
                return false;
            }
            if (this.isInventoryClass(node, transformerLoader)) {
                return this.tryImplement(node);
            }
            return false;
        }
        catch (Throwable t) {
            if (t instanceof LocalizedException) {
                ArclightImplementer.LOGGER.error(MARKER, ((LocalizedException)((Object)t)).node(), ((LocalizedException)((Object)t)).args());
            } else {
                ArclightImplementer.LOGGER.error((Object)t);
            }
            return false;
        }
    }

    private boolean isInventoryClass(ClassNode node, ILaunchPluginService.ITransformerLoader transformerLoader) throws Throwable {
        Integer ret = this.map.get(node.name);
        if (ret != null) {
            return ret > 1;
        }
        Integer i = this.map.get(node.superName);
        if (i != null && i > 1) {
            this.map.put(node.name, i + 1);
            return true;
        }
        if (node.interfaces.contains(INV_TYPE)) {
            this.map.put(node.name, 2);
            return true;
        }
        boolean b = this.isInventoryClass(this.findClass(node.superName, transformerLoader), transformerLoader);
        if (b) {
            this.map.put(node.name, this.map.get(node.superName) + 1);
        } else {
            this.map.put(node.name, 0);
        }
        return b;
    }

    private ClassNode findClass(String typeName, ILaunchPluginService.ITransformerLoader transformerLoader) throws Exception {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(typeName + ".class");
            if (stream == null) {
                throw LocalizedException.checked("implementer.not-found", typeName);
            }
            byte[] array = ByteStreams.toByteArray(stream);
            ClassNode node = new ClassNode();
            new ClassReader(array).accept((ClassVisitor)node, 1);
            return node;
        }
        catch (Throwable e) {
            try {
                byte[] bytes = transformerLoader.buildTransformedClassNodeFor(Type.getObjectType((String)typeName).getClassName());
                ClassNode node = new ClassNode();
                new ClassReader(bytes).accept((ClassVisitor)node, 1);
                return node;
            }
            catch (Throwable t) {
                throw LocalizedException.checked("implementer.not-found", typeName);
            }
        }
    }

    private boolean tryImplement(ClassNode node) {
        MethodNode methodNode;
        HashSet<String> methods = new HashSet<String>();
        MethodNode stackLimitMethod = null;
        for (MethodNode method : node.methods) {
            String desc = method.name + method.desc;
            methods.add(desc);
            if (!desc.equals("func_70297_j_()I")) continue;
            stackLimitMethod = method;
        }
        if (methods.contains("getViewers()Ljava/util/List;")) {
            ArclightImplementer.LOGGER.debug(MARKER, "Found implemented class {}", (Object)node.name);
            node.interfaces.add(BRIDGE_TYPE);
            return false;
        }
        ArclightImplementer.LOGGER.debug(MARKER, "Implementing inventory for class {} in {}", (Object)node.name, (Object)this.map.get(node.name));
        FieldNode transaction = new FieldNode(2, "$transaction", Type.getType(List.class).getDescriptor(), null, null);
        FieldNode maxStack = new FieldNode(2, "$maxStack", Type.getType(Integer.class).getDescriptor(), null, null);
        node.fields.add(transaction);
        node.fields.add(maxStack);
        node.interfaces.add(BRIDGE_TYPE);
        MethodNode methodNode2 = new MethodNode(4097, "onOpen", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getObjectType((String)("org/bukkit/craftbukkit/" + ArclightVersion.current().packageName() + "/entity/CraftHumanEntity"))}), null, null);
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, node.name, transaction.name, transaction.desc));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(List.class), "add", "(Ljava/lang/Object;)Z", true));
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add((AbstractInsnNode)new InsnNode(177));
        methodNode2.instructions = insnList;
        node.methods.add(methodNode2);
        methodNode2 = new MethodNode(4097, "onClose", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getObjectType((String)("org/bukkit/craftbukkit/" + ArclightVersion.current().packageName() + "/entity/CraftHumanEntity"))}), null, null);
        insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, node.name, transaction.name, transaction.desc));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(List.class), "remove", "(Ljava/lang/Object;)Z", true));
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add((AbstractInsnNode)new InsnNode(177));
        methodNode2.instructions = insnList;
        node.methods.add(methodNode2);
        methodNode2 = new MethodNode(4097, "getViewers", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[0]), null, null);
        insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new FieldInsnNode(180, node.name, transaction.name, transaction.desc));
        insnList.add((AbstractInsnNode)new InsnNode(176));
        methodNode2.instructions = insnList;
        node.methods.add(methodNode2);
        InsnList list = new InsnList();
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, node.name, maxStack.name, maxStack.desc));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
        list.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Integer.class), "intValue", "()I", false));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)labelNode);
        list.add((AbstractInsnNode)new InsnNode(87));
        if (stackLimitMethod != null && !Modifier.isAbstract(stackLimitMethod.access)) {
            stackLimitMethod.instructions.insert(list);
        } else {
            methodNode = stackLimitMethod == null ? new MethodNode(0, "func_70297_j_", "()I", null, null) : stackLimitMethod;
            methodNode.access = 4097;
            int level = this.map.get(node.name);
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (level > 2) {
                list.add((AbstractInsnNode)new MethodInsnNode(183, node.superName, methodNode.name, methodNode.desc, false));
            } else {
                list.add((AbstractInsnNode)new MethodInsnNode(183, INV_TYPE, methodNode.name, methodNode.desc, true));
            }
            list.add((AbstractInsnNode)new InsnNode(172));
            methodNode.instructions.insert(list);
            node.methods.add(methodNode);
        }
        methodNode = new MethodNode(4097, "setMaxStackSize", "(I)V", null, null);
        InsnList insnList2 = new InsnList();
        insnList2.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList2.add((AbstractInsnNode)new VarInsnNode(21, 1));
        insnList2.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE})));
        insnList2.add((AbstractInsnNode)new FieldInsnNode(181, node.name, maxStack.name, maxStack.desc));
        insnList2.add((AbstractInsnNode)new InsnNode(177));
        methodNode.instructions = insnList2;
        node.methods.add(methodNode);
        for (MethodNode methodNode3 : node.methods) {
            if (!methodNode3.name.equals("<init>")) continue;
            AbstractInsnNode initNode = methodNode3.instructions.getFirst();
            while (initNode.getOpcode() != 183 || !((MethodInsnNode)initNode).name.equals("<init>")) {
                initNode = initNode.getNext();
            }
            InsnList insnList3 = new InsnList();
            insnList3.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList3.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(ArrayList.class)));
            insnList3.add((AbstractInsnNode)new InsnNode(89));
            insnList3.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(ArrayList.class), "<init>", "()V", false));
            insnList3.add((AbstractInsnNode)new FieldInsnNode(181, node.name, transaction.name, transaction.desc));
            methodNode3.instructions.insert(initNode, insnList3);
        }
        return true;
    }
}

