/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.izzel.arclight.common.bridge.bukkit.ItemMetaBridge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftMetaItem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CraftMetaItem.class}, remap=false)
public class CraftMetaItemMixin
implements ItemMetaBridge {
    @Shadow(remap=false)
    @Final
    private Map<String, INBT> unhandledTags;
    private static final Set<String> EXTEND_TAGS = ImmutableSet.of("map_is_scaling", "map", "CustomPotionEffects", "Potion", "CustomPotionColor", "SkullOwner", new String[]{"SkullProfile", "EntityTag", "BlockEntityTag", "title", "author", "pages", "resolved", "generation", "Fireworks", "StoredEnchantments", "Explosion", "Recipes", "BucketVariantTag", "Charged", "ChargedProjectiles", "Effects", "LodestoneDimension", "LodestonePos", "LodestoneTracked"});
    private CompoundNBT forgeCaps;

    @ModifyVariable(method={"<init>(Lnet/minecraft/nbt/CompoundNBT;)V"}, at=@At(value="INVOKE", target="Lorg/bukkit/UnsafeValues;getDataVersion()I"))
    private CompoundNBT arclight$provideTag(CompoundNBT tag) {
        return tag == null ? new CompoundNBT() : tag;
    }

    @Override
    public CompoundNBT bridge$getForgeCaps() {
        return this.forgeCaps;
    }

    @Override
    public void bridge$setForgeCaps(CompoundNBT nbt) {
        this.forgeCaps = nbt;
    }

    @Override
    public void bridge$offerUnhandledTags(CompoundNBT nbt) {
        if (this.getClass().equals(CraftMetaItem.class)) {
            for (String s2 : nbt.func_150296_c()) {
                if (!EXTEND_TAGS.contains(s2)) continue;
                this.unhandledTags.put(s2, nbt.func_74781_a(s2));
            }
        }
    }

    @Override
    public Map<String, INBT> bridge$getUnhandledTags() {
        return this.unhandledTags;
    }

    @Override
    public void bridge$setUnhandledTags(Map<String, INBT> tags) {
        this.unhandledTags.putAll(tags);
    }

    @Inject(method={"serialize(Lcom/google/common/collect/ImmutableMap$Builder;)Lcom/google/common/collect/ImmutableMap$Builder;"}, at={@At(value="RETURN")})
    private void arclight$serializeForgeCaps(ImmutableMap.Builder<String, Object> builder, CallbackInfoReturnable<ImmutableMap.Builder<String, Object>> cir) throws IOException {
        if (this.forgeCaps != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((CompoundNBT)this.forgeCaps, (OutputStream)buf);
            builder.put("forgeCaps", Base64.encodeBase64String((byte[])buf.toByteArray()));
        }
    }

    @Inject(method={"clone"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="RETURN")})
    private void arclight$cloneTags(CallbackInfoReturnable<CraftMetaItem> cir, CraftMetaItem clone) {
        if (this.unhandledTags != null) {
            ((ItemMetaBridge)((Object)clone)).bridge$getUnhandledTags().putAll(this.unhandledTags);
        }
        if (this.forgeCaps != null) {
            ((ItemMetaBridge)((Object)clone)).bridge$setForgeCaps(this.forgeCaps.func_74737_b());
        }
    }

    @ModifyVariable(method={"applyHash"}, index=1, at=@At(value="RETURN"))
    private int arclight$applyForgeCapsHash(int hash) {
        return 61 * hash + (this.forgeCaps != null ? this.forgeCaps.hashCode() : 0);
    }

    @Inject(method={"isEmpty"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forgeCapsEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (this.forgeCaps != null && !this.forgeCaps.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"equalsCommon"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forgeCapsEquals(CraftMetaItem that, CallbackInfoReturnable<Boolean> cir) {
        boolean ret;
        CompoundNBT forgeCaps = ((ItemMetaBridge)((Object)that)).bridge$getForgeCaps();
        if (this.forgeCaps == null) {
            ret = forgeCaps != null && forgeCaps.func_186856_d() != 0;
        } else {
            boolean bl = forgeCaps == null ? this.forgeCaps.func_186856_d() != 0 : (ret = !this.forgeCaps.equals((Object)forgeCaps));
        }
        if (ret) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"<init>(Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void arclight$extractForgeCaps(Map<String, Object> map, CallbackInfo ci) {
        if (map.containsKey("forgeCaps")) {
            Object forgeCaps = map.get("forgeCaps");
            try {
                ByteArrayInputStream buf = new ByteArrayInputStream(Base64.decodeBase64((String)forgeCaps.toString()));
                this.forgeCaps = CompressedStreamTools.func_74796_a((InputStream)buf);
            }
            catch (IOException e) {
                LogManager.getLogger(this.getClass()).error("Reading forge caps", (Throwable)e);
            }
        }
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void arclight$copyForgeCaps(CraftMetaItem meta, CallbackInfo ci) {
        CompoundNBT forgeCaps;
        if (meta != null && (forgeCaps = ((ItemMetaBridge)((Object)meta)).bridge$getForgeCaps()) != null) {
            this.forgeCaps = forgeCaps.func_74737_b();
        }
    }
}

