/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.item.crafting.IRecipeBridge;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.bukkit.craftbukkit.v1_16_R3.inventory.RecipeIterator;
import org.bukkit.inventory.Recipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RecipeIterator.class}, remap=false)
public class RecipeIteratorMixin {
    @Shadow
    private Iterator<IRecipe<?>> current;
    @Shadow
    @Final
    private Iterator<Map.Entry<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>>> recipes;

    @Overwrite
    public boolean hasNext() {
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        if (this.recipes.hasNext()) {
            this.current = this.recipes.next().getValue().values().iterator();
            return this.hasNext();
        }
        return false;
    }

    @Overwrite
    public Recipe next() {
        if (this.current == null || !this.current.hasNext()) {
            this.current = this.recipes.next().getValue().values().iterator();
            return this.next();
        }
        IRecipe<?> recipe = this.current.next();
        try {
            return ((IRecipeBridge)recipe).bridge$toBukkitRecipe();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error converting recipe " + recipe.func_199560_c(), e);
        }
    }
}

