/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity;

import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.entity.MobEntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.entity.LivingEntityMixin;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.mixin.Eject;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.Level;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEntity.class})
@Implements(value={@Interface(iface=MobEntityBridge.Hack.class, prefix="hack$")})
public abstract class MobEntityMixin
extends LivingEntityMixin
implements MobEntityBridge {
    @Shadow
    public boolean field_82179_bU;
    @Shadow
    private LivingEntity field_70696_bz;
    @Shadow
    @Final
    public float[] field_82174_bp;
    @Shadow
    @Final
    public float[] field_184655_bs;
    public boolean aware;
    protected transient boolean arclight$targetSuccess = false;
    private transient EntityTargetEvent.TargetReason arclight$reason;
    private transient boolean arclight$fireEvent;
    private transient ItemEntity arclight$item;
    private transient EntityTransformEvent.TransformReason arclight$transform;

    @Shadow
    public abstract boolean func_213397_c(double var1);

    @Shadow
    @Nullable
    public abstract LivingEntity func_70638_az();

    @Shadow
    protected abstract ResourceLocation shadow$func_184647_J();

    @Shadow
    public static EquipmentSlotType func_184640_d(ItemStack stack) {
        return null;
    }

    @Override
    @Shadow
    public abstract ItemStack func_184582_a(EquipmentSlotType var1);

    @Shadow
    public abstract boolean func_175448_a(ItemStack var1);

    @Shadow
    protected abstract float func_205712_c(EquipmentSlotType var1);

    @Override
    @Shadow
    public abstract void func_184201_a(EquipmentSlotType var1, ItemStack var2);

    @Shadow
    @Nullable
    public abstract Entity func_110166_bE();

    @Shadow
    public abstract boolean func_104002_bU();

    @Shadow
    protected void func_70619_bc() {
    }

    @Shadow
    public abstract boolean func_175446_cd();

    @Shadow
    protected abstract boolean func_208003_a(ItemStack var1, ItemStack var2);

    @Shadow
    protected abstract void func_233657_b_(EquipmentSlotType var1, ItemStack var2);

    @Shadow
    @Nullable
    public abstract <T extends MobEntity> T func_233656_b_(EntityType<T> var1, boolean var2);

    @Override
    public void bridge$setAware(boolean aware) {
        this.aware = aware;
    }

    @Inject(method={"setCanPickUpLoot"}, at={@At(value="HEAD")})
    public void arclight$setPickupLoot(boolean canPickup, CallbackInfo ci) {
        this.canPickUpLoot = canPickup;
    }

    @Overwrite
    public boolean func_98052_bS() {
        return this.canPickUpLoot;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(EntityType<? extends MobEntity> type, World worldIn, CallbackInfo ci) {
        this.aware = true;
    }

    @Overwrite
    public void func_70624_b(@Nullable LivingEntity livingEntity) {
        boolean fireEvent = this.arclight$fireEvent;
        this.arclight$fireEvent = false;
        EntityTargetEvent.TargetReason reason = this.arclight$reason == null ? EntityTargetEvent.TargetReason.UNKNOWN : this.arclight$reason;
        this.arclight$reason = null;
        if (this.func_70638_az() == livingEntity) {
            this.arclight$targetSuccess = false;
            return;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.func_70638_az() != null && livingEntity == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.func_70638_az().func_70089_S() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                ArclightMod.LOGGER.log(Level.WARN, "Unknown target reason setting {} target to {}", (Object)this, livingEntity);
            }
            CraftLivingEntity ctarget = null;
            if (livingEntity != null) {
                ctarget = ((LivingEntityBridge)livingEntity).bridge$getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), ctarget, reason);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                this.arclight$targetSuccess = false;
                return;
            }
            livingEntity = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.field_70696_bz = livingEntity;
        ForgeHooks.onLivingSetAttackTarget((LivingEntity)((MobEntity)this), (LivingEntity)this.field_70696_bz);
        this.arclight$targetSuccess = true;
    }

    public boolean setGoalTarget(LivingEntity livingEntity, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        this.bridge$pushGoalTargetReason(reason, fireEvent);
        this.func_70624_b(livingEntity);
        return this.arclight$targetSuccess;
    }

    @Override
    public boolean bridge$lastGoalTargetResult() {
        return this.arclight$targetSuccess;
    }

    @Override
    public boolean bridge$setGoalTarget(LivingEntity livingEntity, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        return this.setGoalTarget(livingEntity, reason, fireEvent);
    }

    @Override
    public void bridge$pushGoalTargetReason(EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        this.arclight$reason = fireEvent ? reason : null;
        this.arclight$fireEvent = fireEvent;
    }

    @Inject(method={"writeAdditional"}, at={@At(value="HEAD")})
    private void arclight$setAware(CompoundNBT compound, CallbackInfo ci) {
        compound.func_74757_a("Bukkit.Aware", this.aware);
    }

    @Inject(method={"readAdditional"}, at={@At(value="HEAD")})
    private void arclight$readAware(CompoundNBT compound, CallbackInfo ci) {
        if (compound.func_74764_b("Bukkit.Aware")) {
            this.aware = compound.func_74767_n("Bukkit.Aware");
        }
    }

    @Redirect(method={"readAdditional"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;setCanPickUpLoot(Z)V"))
    public void arclight$setIfTrue(MobEntity mobEntity, boolean canPickup) {
        if (canPickup) {
            mobEntity.func_98053_h(true);
        }
    }

    @Inject(method={"updateEntityActionState"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$unaware(CallbackInfo ci) {
        if (!this.aware) {
            ++this.field_70708_bq;
            ci.cancel();
        }
    }

    @Inject(method={"updateEquipmentIfNeeded"}, at={@At(value="HEAD")})
    private void arclight$captureItemEntity(ItemEntity itemEntity, CallbackInfo ci) {
        this.arclight$item = itemEntity;
    }

    @Override
    public void bridge$captureItemDrop(ItemEntity itemEntity) {
        this.arclight$item = itemEntity;
    }

    @Overwrite
    public boolean func_233665_g_(ItemStack p_233665_1_) {
        boolean canPickup;
        ItemEntity itemEntity = this.arclight$item;
        this.arclight$item = null;
        EquipmentSlotType equipmentslottype = MobEntityMixin.func_184640_d(p_233665_1_);
        ItemStack itemstack = this.func_184582_a(equipmentslottype);
        boolean flag = this.func_208003_a(p_233665_1_, itemstack);
        boolean bl = canPickup = flag && this.func_175448_a(p_233665_1_);
        if (itemEntity != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent((Entity)((MobEntity)this), itemEntity, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.func_205712_c(equipmentslottype);
            if (!itemstack.func_190926_b() && (double)Math.max(this.field_70146_Z.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.func_199701_a_(itemstack);
                this.forceDrops = false;
            }
            this.func_233657_b_(equipmentslottype, p_233665_1_);
            this.func_184606_a_(p_233665_1_);
            return true;
        }
        return false;
    }

    @Inject(method={"processInitialInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;clearLeashed(ZZ)V")})
    private void arclight$unleash(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (CraftEventFactory.callPlayerUnleashEntityEvent((MobEntity)this, player).isCancelled()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SMountEntityPacket((Entity)((MobEntity)this), this.func_110166_bE()));
            cir.setReturnValue((Object)ActionResultType.PASS);
        }
    }

    @Inject(method={"processInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;setLeashHolder(Lnet/minecraft/entity/Entity;Z)V")})
    private void arclight$leash(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (CraftEventFactory.callPlayerLeashEntityEvent((MobEntity)this, (Entity)player, player).isCancelled()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SMountEntityPacket((Entity)((MobEntity)this), this.func_110166_bE()));
            cir.setReturnValue((Object)ActionResultType.PASS);
        }
    }

    @Inject(method={"updateLeashedState"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;clearLeashed(ZZ)V")})
    public void arclight$unleash2(CallbackInfo ci) {
        Bukkit.getPluginManager().callEvent(new EntityUnleashEvent(this.getBukkitEntity(), this.func_70089_S() ? EntityUnleashEvent.UnleashReason.HOLDER_GONE : EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH));
    }

    @Inject(method={"clearLeashed"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/MobEntity;entityDropItem(Lnet/minecraft/util/IItemProvider;)Lnet/minecraft/entity/item/ItemEntity;")})
    public void arclight$leashDropPost(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        this.forceDrops = false;
    }

    @Inject(method={"clearLeashed"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;entityDropItem(Lnet/minecraft/util/IItemProvider;)Lnet/minecraft/entity/item/ItemEntity;")})
    public void arclight$leashDropPre(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        this.forceDrops = true;
    }

    @Inject(method={"startRiding"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;clearLeashed(ZZ)V")})
    private void arclight$unleashRide(Entity entityIn, boolean force, CallbackInfoReturnable<Boolean> cir) {
        Bukkit.getPluginManager().callEvent(new EntityUnleashEvent(this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
    }

    @Inject(method={"setDead"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;clearLeashed(ZZ)V")})
    private void arclight$unleashDead(CallbackInfo ci) {
        Bukkit.getPluginManager().callEvent(new EntityUnleashEvent(this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
    }

    @Eject(method={"func_233656_b_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z"))
    private boolean arclight$copySpawn(World world, Entity entityIn, CallbackInfoReturnable<MobEntity> cir) {
        EntityTransformEvent.TransformReason transformReason = this.arclight$transform == null ? EntityTransformEvent.TransformReason.UNKNOWN : this.arclight$transform;
        this.arclight$transform = null;
        if (CraftEventFactory.callEntityTransformEvent((LivingEntity)((MobEntity)this), (LivingEntity)entityIn, transformReason).isCancelled()) {
            cir.setReturnValue(null);
            return false;
        }
        return world.func_217376_c(entityIn);
    }

    @Inject(method={"func_233656_b_"}, at={@At(value="RETURN")})
    private <T extends MobEntity> void arclight$cleanReason(EntityType<T> p_233656_1_, boolean p_233656_2_, CallbackInfoReturnable<T> cir) {
        ((WorldBridge)this.field_70170_p).bridge$pushAddEntityReason(null);
        this.arclight$transform = null;
    }

    public <T extends MobEntity> T a(EntityType<T> entityType, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        ((WorldBridge)this.field_70170_p).bridge$pushAddEntityReason(spawnReason);
        this.bridge$pushTransformReason(transformReason);
        return this.func_233656_b_(entityType, flag);
    }

    @Override
    public void bridge$pushTransformReason(EntityTransformEvent.TransformReason transformReason) {
        this.arclight$transform = transformReason;
    }

    @Redirect(method={"attackEntityAsMob"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setFire(I)V"))
    public void arclight$attackCombust(Entity entity, int seconds) {
        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent(this.getBukkitEntity(), ((EntityBridge)entity).bridge$getBukkitEntity(), seconds);
        Bukkit.getPluginManager().callEvent(combustEvent);
        if (!combustEvent.isCancelled()) {
            ((EntityBridge)entity).bridge$setOnFire(combustEvent.getDuration(), false);
        }
    }

    public ResourceLocation hack$getLootTable() {
        return this.shadow$func_184647_J();
    }

    @Override
    public ResourceLocation bridge$getLootTable() {
        return this.hack$getLootTable();
    }

    @Override
    public boolean bridge$isPersistenceRequired() {
        return this.field_82179_bU;
    }

    @Override
    public void bridge$setPersistenceRequired(boolean value) {
        this.field_82179_bU = value;
    }
}

