/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.item;

import io.izzel.arclight.common.bridge.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.PlayerInventoryBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.network.datasync.EntityDataManagerBridge;
import io.izzel.arclight.common.mixin.core.entity.EntityMixin;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends EntityMixin {
    @Shadow
    @Final
    private static DataParameter<ItemStack> field_184533_c;
    @Shadow
    public int field_145804_b;
    @Shadow
    private UUID field_145802_g;

    @Shadow
    public abstract ItemStack func_92059_d();

    @Inject(method={"func_213858_a"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$itemMerge(ItemEntity from, ItemStack stack1, ItemEntity to, ItemStack stack2, CallbackInfo ci) {
        if (CraftEventFactory.callItemMergeEvent(to, from).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;markVelocityChanged()V")})
    private void arclight$damageNonLiving(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)((ItemEntity)this), source, amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void burn(float amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    @Overwrite
    public void func_70100_b_(PlayerEntity entity) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_145804_b > 0) {
                return;
            }
            ItemStack itemstack = this.func_92059_d();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)((ItemEntity)this), (PlayerEntity)entity);
            if (hook < 0) {
                return;
            }
            int canHold = ((PlayerInventoryBridge)entity.field_71071_by).bridge$canHold(itemstack);
            int remaining = itemstack.func_190916_E() - canHold;
            if (this.field_145804_b <= 0 && canHold > 0) {
                itemstack.func_190920_e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent(((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity(), (Item)((Object)this.getBukkitEntity()), remaining);
                playerEvent.setCancelled(!((PlayerEntityBridge)entity).bridge$canPickUpLoot());
                Bukkit.getPluginManager().callEvent(playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.func_190920_e(canHold + remaining);
                    return;
                }
                EntityPickupItemEvent entityEvent = new EntityPickupItemEvent(((LivingEntityBridge)entity).bridge$getBukkitEntity(), (Item)((Object)this.getBukkitEntity()), remaining);
                entityEvent.setCancelled(!((PlayerEntityBridge)entity).bridge$canPickUpLoot());
                Bukkit.getPluginManager().callEvent(entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.func_190920_e(canHold + remaining);
                    return;
                }
                ItemStack current = this.func_92059_d();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.func_190920_e(canHold + remaining);
                }
                this.field_145804_b = 0;
            } else if (this.field_145804_b == 0 && hook != 1) {
                this.field_145804_b = -1;
            }
            ItemStack copy = itemstack.func_77946_l();
            if (this.field_145804_b == 0 && (this.field_145802_g == null || this.field_145802_g.equals(entity.func_110124_au())) && (hook == 1 || entity.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - itemstack.func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)entity, (ItemEntity)((ItemEntity)this), (ItemStack)copy);
                entity.func_71001_a((Entity)((ItemEntity)this), i);
                if (itemstack.func_190926_b()) {
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                entity.func_71064_a(Stats.field_199089_f.func_199076_b((Object)itemstack.func_77973_b()), i);
            }
        }
    }

    @Inject(method={"setItem"}, at={@At(value="RETURN")})
    private void arclight$markDirty(ItemStack stack, CallbackInfo ci) {
        ((EntityDataManagerBridge)this.func_184212_Q()).bridge$markDirty(field_184533_c);
    }

    @Redirect(method={"func_226531_a_"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;setItem(Lnet/minecraft/item/ItemStack;)V"))
    private static void arclight$setNonEmpty(ItemEntity itemEntity, ItemStack stack) {
        if (!stack.func_190926_b()) {
            itemEntity.func_92058_a(stack);
        }
    }
}

