/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.util.DamageSourceBridge;
import io.izzel.arclight.common.bridge.util.FoodStatsBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mixin.core.entity.LivingEntityMixin;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin
implements PlayerEntityBridge {
    @Shadow
    @Final
    public PlayerAbilities field_71075_bZ;
    @Shadow
    private long field_223730_e;
    @Shadow
    public int field_71068_ca;
    @Shadow
    @Final
    public PlayerInventory field_71071_by;
    @Shadow
    public Container field_71070_bA;
    @Shadow
    @Final
    public PlayerContainer field_71069_bz;
    @Shadow
    public float field_71106_cc;
    @Shadow
    public int field_71067_cb;
    @Shadow
    protected FoodStats field_71100_bB;
    @Shadow
    protected EnderChestInventory field_71078_a;
    @Shadow
    public int field_71076_b;
    public boolean fauxSleeping;
    public int oldLevel;
    protected transient boolean arclight$forceSleep;

    @Override
    @Shadow
    public abstract String func_195047_I_();

    @Shadow
    public abstract float func_184825_o(float var1);

    @Shadow
    public abstract void func_184821_cY();

    @Shadow
    public abstract SoundCategory func_184176_by();

    @Shadow
    public abstract float func_70689_ay();

    @Shadow
    public abstract void func_184810_cG();

    @Shadow
    public abstract void func_71009_b(Entity var1);

    @Shadow
    public abstract void func_71047_c(Entity var1);

    @Shadow
    public abstract void func_195067_a(ResourceLocation var1, int var2);

    @Shadow
    public abstract void func_71020_j(float var1);

    @Shadow
    public abstract void func_192031_i(CompoundNBT var1);

    @Shadow
    public abstract void func_192029_h(CompoundNBT var1);

    @Shadow
    public abstract CompoundNBT func_192025_dl();

    @Shadow
    public abstract CompoundNBT func_192023_dk();

    @Shadow
    public abstract void func_71029_a(Stat<?> var1);

    @Shadow
    public abstract void func_195066_a(ResourceLocation var1);

    @Shadow
    public abstract ITextComponent func_145748_c_();

    @Shadow
    public abstract HandSide func_184591_cq();

    @Shadow
    protected boolean func_70610_aX() {
        return false;
    }

    @Shadow
    public abstract Scoreboard func_96123_co();

    @Shadow
    public abstract Either<PlayerEntity.SleepResult, Unit> func_213819_a(BlockPos var1);

    @Shadow
    public abstract GameProfile func_146103_bH();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(World p_i241920_1_, BlockPos p_i241920_2_, float p_i241920_3_, GameProfile p_i241920_4_, CallbackInfo ci) {
        this.oldLevel = -1;
        ((FoodStatsBridge)this.field_71100_bB).bridge$setEntityHuman((PlayerEntity)this);
        ((IInventoryBridge)this.field_71078_a).setOwner(this.getBukkitEntity());
    }

    @Override
    public boolean bridge$isFauxSleeping() {
        return this.fauxSleeping;
    }

    @Inject(method={"updateTurtleHelmet"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addPotionEffect(Lnet/minecraft/potion/EffectInstance;)Z")})
    private void arclight$turtleHelmet(CallbackInfo ci) {
        this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    @Inject(method={"livingTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;heal(F)V")})
    private void arclight$healByRegen(CallbackInfo ci) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.REGEN);
    }

    @Inject(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/item/ItemEntity;"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="RETURN", ordinal=1)})
    private void arclight$playerDropItem(net.minecraft.item.ItemStack droppedItem, boolean dropAround, boolean traceItem, CallbackInfoReturnable<ItemEntity> cir, double d0, ItemEntity itemEntity) {
        Player player = (Player)((Object)this.getBukkitEntity());
        Item drop = (Item)((Object)((EntityBridge)itemEntity).bridge$getBukkitEntity());
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (traceItem && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (traceItem && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(drop.getItemStack());
            }
            cir.setReturnValue(null);
        }
    }

    @Override
    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean damaged;
        if (!ForgeHooks.onPlayerAttack((LivingEntity)((PlayerEntity)this), (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_71075_bZ.field_75102_a && !source.func_76357_e()) {
            this.forceExplosionKnockback = true;
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76350_n()) {
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                return false;
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.func_70097_a(source, amount)) {
            this.func_192030_dh();
        }
        return damaged;
    }

    @Overwrite
    public boolean func_96122_a(PlayerEntity entityhuman) {
        Team team;
        if (entityhuman instanceof ServerPlayerEntity) {
            ServerPlayerEntity thatPlayer = (ServerPlayerEntity)entityhuman;
            team = ((ServerPlayerEntityBridge)thatPlayer).bridge$getBukkitEntity().getScoreboard().getPlayerTeam(((ServerPlayerEntityBridge)thatPlayer).bridge$getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = Bukkit.getOfflinePlayer(entityhuman.func_195047_I_());
            team = Bukkit.getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof ServerPlayerEntity) {
            return !team.hasPlayer(((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity());
        }
        return !team.hasPlayer(Bukkit.getOfflinePlayer(this.func_195047_I_()));
    }

    @Inject(method={"damageEntity"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$damageEntityCustom(DamageSource damageSrc, float damageAmount, CallbackInfo ci) {
        this.damageEntity0(damageSrc, damageAmount);
        ci.cancel();
    }

    @Overwrite
    public void func_71059_n(Entity entity) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)((PlayerEntity)this), (Entity)entity)) {
            return;
        }
        if (entity.func_70075_an() && !entity.func_85031_j((Entity)((PlayerEntity)this))) {
            float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
            float f2 = entity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((net.minecraft.item.ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entity).func_70668_bt()) : EnchantmentHelper.func_152377_a((net.minecraft.item.ItemStack)this.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f3 = this.func_184825_o(0.5f);
            f2 *= f3;
            this.func_184821_cY();
            if ((f *= 0.2f + f3 * f3 * 0.8f) > 0.0f || f2 > 0.0f) {
                net.minecraft.item.ItemStack itemstack;
                boolean flag = f3 > 0.9f;
                boolean flag2 = false;
                float i = (float)this.func_233637_b_(Attributes.field_233824_g_);
                i += (float)EnchantmentHelper.func_77501_a((LivingEntity)((PlayerEntity)this));
                if (this.func_70051_ag() && flag) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                    i += 1.0f;
                    flag2 = true;
                }
                boolean flag3 = flag && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(Effects.field_76440_q) && !this.func_184218_aH() && entity instanceof LivingEntity;
                flag3 = flag3 && !this.func_70051_ag();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)((PlayerEntity)this), (Entity)entity, (boolean)flag3, (float)(flag3 ? 1.5f : 1.0f));
                boolean bl = flag3 = hitResult != null;
                if (flag3) {
                    f *= hitResult.getDamageModifier();
                }
                f += f2;
                boolean flag4 = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (flag && !flag3 && !flag2 && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof SwordItem) {
                    flag4 = true;
                }
                float f4 = 0.0f;
                boolean flag5 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)((PlayerEntity)this));
                if (entity instanceof LivingEntity) {
                    f4 = ((LivingEntity)entity).func_110143_aJ();
                    if (j > 0 && !entity.func_70027_ad()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent(this.getBukkitEntity(), ((EntityBridge)entity).bridge$getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent(combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag5 = true;
                            ((EntityBridge)entity).bridge$setOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vector3d vec3d = entity.func_213322_ci();
                boolean flag6 = entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), f);
                if (flag6) {
                    if (i > 0.0f) {
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).func_233627_a_(i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * i * 0.5f));
                        }
                        this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        this.func_70031_b(false);
                    }
                    if (flag4) {
                        float f5 = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)((PlayerEntity)this)) * f;
                        List list = this.field_70170_p.func_217357_a(LivingEntity.class, entity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0));
                        for (LivingEntity entityliving : list) {
                            if (entityliving == this || entityliving == entity || this.func_184191_r((Entity)entityliving) || entityliving instanceof ArmorStandEntity && ((ArmorStandEntity)entityliving).func_181026_s() || !(this.func_70068_e((Entity)entityliving) < 9.0) || !entityliving.func_70097_a(((DamageSourceBridge)DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this))).bridge$sweep(), f5)) continue;
                            entityliving.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        }
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (entity instanceof ServerPlayerEntity && entity.field_70133_I) {
                        boolean cancelled = false;
                        CraftPlayer player = ((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent((Player)player, velocity.clone());
                        Bukkit.getPluginManager().callEvent(event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals(event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                            entity.field_70133_I = false;
                            entity.func_213317_d(vec3d);
                        }
                    }
                    if (flag3) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(entity);
                    }
                    if (!flag3 && !flag4) {
                        if (flag) {
                            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f2 > 0.0f) {
                        this.func_71047_c(entity);
                    }
                    this.func_130011_c(entity);
                    if (entity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)entity), (Entity)((PlayerEntity)this));
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)((PlayerEntity)this), (Entity)entity);
                    net.minecraft.item.ItemStack itemstack2 = this.func_184614_ca();
                    Entity object = entity;
                    if (entity instanceof EnderDragonPartEntity) {
                        object = ((EnderDragonPartEntity)entity).field_213852_b;
                    }
                    if (!this.field_70170_p.field_72995_K && !itemstack2.func_190926_b() && object instanceof LivingEntity) {
                        net.minecraft.item.ItemStack copy = itemstack2.func_77946_l();
                        itemstack2.func_77961_a((LivingEntity)object, (PlayerEntity)this);
                        if (itemstack2.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)this), (net.minecraft.item.ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            this.func_184611_a(Hand.MAIN_HAND, net.minecraft.item.ItemStack.field_190927_a);
                        }
                    }
                    if (entity instanceof LivingEntity) {
                        float f6 = f4 - ((LivingEntity)entity).func_110143_aJ();
                        this.func_195067_a(Stats.field_188111_y, Math.round(f6 * 10.0f));
                        if (j > 0) {
                            EntityCombustByEntityEvent combustEvent2 = new EntityCombustByEntityEvent(this.getBukkitEntity(), ((EntityBridge)entity).bridge$getBukkitEntity(), j * 4);
                            Bukkit.getPluginManager().callEvent(combustEvent2);
                            if (!combustEvent2.isCancelled()) {
                                ((EntityBridge)entity).bridge$setOnFire(combustEvent2.getDuration(), false);
                            }
                        }
                        if (this.field_70170_p instanceof ServerWorld && f6 > 2.0f) {
                            int k = (int)((double)f6 * 0.5);
                            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() * 0.5f), entity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.func_71020_j(0.1f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (flag5) {
                        entity.func_70066_B();
                    }
                    if (this instanceof ServerPlayerEntityBridge) {
                        ((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    public Either<PlayerEntity.SleepResult, Unit> sleep(BlockPos at, boolean force) {
        this.arclight$forceSleep = force;
        return this.func_213819_a(at);
    }

    @Override
    public Either<PlayerEntity.SleepResult, Unit> bridge$trySleep(BlockPos at, boolean force) {
        return this.sleep(at, force);
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;sleepTimer:I")})
    private void arclight$wakeup(boolean flag, boolean flag1, CallbackInfo ci) {
        BlockPos blockPos = this.func_213374_dv().orElse(null);
        if (this.bridge$getBukkitEntity() instanceof Player) {
            Player player = (Player)((Object)this.bridge$getBukkitEntity());
            Block bed = blockPos != null ? CraftBlock.at((IWorld)this.field_70170_p, blockPos) : ((WorldBridge)this.field_70170_p).bridge$getWorld().getBlockAt(player.getLocation());
            PlayerBedLeaveEvent event = new PlayerBedLeaveEvent(player, bed, true);
            Bukkit.getPluginManager().callEvent(event);
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setFlag(IZ)V"))
    private void arclight$toggleGlide(PlayerEntity playerEntity, int flag, boolean set) {
        if (playerEntity.func_70083_f(flag) != set && !CraftEventFactory.callToggleGlideEvent((LivingEntity)((PlayerEntity)this), set).isCancelled()) {
            playerEntity.func_70052_a(flag, set);
        }
    }

    @Inject(method={"startFallFlying"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$startGlidingEvent(CallbackInfo ci) {
        if (CraftEventFactory.callToggleGlideEvent((LivingEntity)((PlayerEntity)this), true).isCancelled()) {
            this.func_70052_a(7, true);
            this.func_70052_a(7, false);
            ci.cancel();
        }
    }

    @Inject(method={"stopFallFlying"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$stopGlidingEvent(CallbackInfo ci) {
        if (CraftEventFactory.callToggleGlideEvent((LivingEntity)((PlayerEntity)this), false).isCancelled()) {
            ci.cancel();
        }
    }

    @Overwrite
    protected void func_192030_dh() {
        if (this.field_223730_e + 20L < this.field_70170_p.func_82737_E()) {
            if (this.spawnEntityFromShoulder(this.func_192023_dk())) {
                this.func_192029_h(new CompoundNBT());
            }
            if (this.spawnEntityFromShoulder(this.func_192025_dl())) {
                this.func_192031_i(new CompoundNBT());
            }
        }
    }

    private boolean spawnEntityFromShoulder(CompoundNBT nbttagcompound) {
        return this.field_70170_p.field_72995_K || nbttagcompound.isEmpty() || EntityType.func_220330_a((CompoundNBT)nbttagcompound, (World)this.field_70170_p).map(entity -> {
            if (entity instanceof TameableEntity) {
                ((TameableEntity)entity).func_184754_b(this.field_96093_i);
            }
            entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.7f, this.func_226281_cx_());
            return ((ServerWorldBridge)this.field_70170_p).bridge$addEntitySerialized((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }).orElse(true) != false;
    }

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)this.internal$getBukkitEntity();
    }

    @Override
    public CraftHumanEntity bridge$getBukkitEntity() {
        return (CraftHumanEntity)this.internal$getBukkitEntity();
    }

    @Override
    public void setSlot(EquipmentSlotType slotIn, net.minecraft.item.ItemStack stack, boolean silent) {
        if (slotIn == EquipmentSlotType.MAINHAND) {
            this.bridge$playEquipSound(stack, silent);
            this.field_71071_by.field_70462_a.set(this.field_71071_by.field_70461_c, (Object)stack);
        } else if (slotIn == EquipmentSlotType.OFFHAND) {
            this.bridge$playEquipSound(stack, silent);
            this.field_71071_by.field_184439_c.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            this.bridge$playEquipSound(stack, silent);
            this.field_71071_by.field_70460_b.set(slotIn.func_188454_b(), (Object)stack);
        }
    }
}

