/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.izzel.arclight.common.bridge.command.ICommandSourceBridge;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.server.BukkitRegistry;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.BukkitOptionParser;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.LongTickDetector;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.common.world.StructureSpawnManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.scoreboard.CraftScoreboardManager;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.PluginLoadOrder;
import org.spigotmc.WatchdogThread;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends RecursiveEventLoop<TickDelayedTask>
implements MinecraftServerBridge,
ICommandSourceBridge {
    @Shadow
    private int field_71315_w;
    @Shadow
    protected long field_211151_aa;
    @Shadow
    @Final
    private ServerStatusResponse field_147147_p;
    @Shadow
    @Nullable
    private String field_71286_C;
    @Shadow
    private volatile boolean field_71317_u;
    @Shadow
    private long field_71299_R;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    private boolean field_71295_T;
    @Shadow
    private boolean field_213214_ac;
    @Shadow
    private long field_213213_ab;
    @Shadow
    private volatile boolean field_71296_Q;
    @Shadow
    private boolean field_71316_v;
    @Shadow
    private IProfiler field_71304_b;
    @Shadow
    @Final
    public Map<RegistryKey<World>, ServerWorld> field_71305_c;
    @Shadow
    protected IServerConfiguration field_240768_i_;
    public DatapackCodec datapackconfiguration;
    private boolean forceTicks;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public RemoteConsoleCommandSender remoteConsole;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public Commands vanillaCommandDispatcher;
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    private static final int TPS = 20;
    private static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    private static int currentTick;
    public final double[] recentTps = new double[3];

    @Shadow
    protected abstract boolean func_71197_b() throws IOException;

    @Shadow
    protected abstract void func_184107_a(ServerStatusResponse var1);

    @Shadow
    protected abstract void func_71217_p(BooleanSupplier var1);

    @Shadow
    protected abstract boolean func_212379_aT();

    @Shadow
    protected abstract void func_213202_o();

    @Shadow
    protected abstract void func_71228_a(CrashReport var1);

    @Shadow
    public abstract CrashReport func_71230_b(CrashReport var1);

    @Shadow
    public abstract File func_71238_n();

    @Shadow
    protected abstract void func_71260_j();

    @Shadow
    protected abstract void func_71240_o();

    @Shadow
    public abstract Commands func_195571_aL();

    @Shadow
    protected abstract void func_240773_a_(@org.jetbrains.annotations.Nullable LongTickDetector var1);

    @Shadow
    protected abstract void func_240795_b_(@org.jetbrains.annotations.Nullable LongTickDetector var1);

    @Shadow
    protected abstract void func_240794_aZ_();

    @Shadow
    public abstract ServerWorld func_241755_D_();

    @Shadow
    protected abstract void func_240778_a_(IServerConfiguration var1);

    @Shadow
    private static void func_240786_a_(ServerWorld p_240786_0_, IServerWorldInfo p_240786_1_, boolean hasBonusChest, boolean p_240786_3_, boolean p_240786_4_) {
    }

    @Shadow(remap=false)
    @Deprecated
    public abstract void markWorldsDirty();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    @Override
    public boolean bridge$hasStopped() {
        return this.hasStopped();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$loadOptions(Thread serverThread, DynamicRegistries.Impl dynamicRegistries, SaveFormat.LevelSave anvilConverterForAnvilFile, IServerConfiguration serverConfig, ResourcePackList dataPacks, Proxy serverProxy, DataFixer dataFixer, DataPackRegistries dataRegistries, MinecraftSessionService sessionService, GameProfileRepository profileRepo, PlayerProfileCache profileCache, IChunkStatusListenerFactory chunkStatusListenerFactory, CallbackInfo ci) {
        String[] arguments = ManagementFactory.getRuntimeMXBean().getInputArguments().toArray(new String[0]);
        BukkitOptionParser parser = new BukkitOptionParser();
        try {
            this.options = parser.parse(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.datapackconfiguration = ArclightCaptures.getDatapackConfig();
        this.vanillaCommandDispatcher = dataRegistries.func_240968_f_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    protected void func_240802_v_() {
        try {
            if (this.func_71197_b()) {
                ServerLifecycleHooks.handleServerStarted((MinecraftServer)((MinecraftServer)this));
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a((ITextComponent)new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                Arrays.fill(this.recentTps, 20.0);
                long tickSection = Util.func_211177_b();
                long tickCount = 1L;
                while (this.field_71317_u) {
                    long curTime = Util.func_211177_b();
                    long i = curTime - this.field_211151_aa;
                    if (i > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        long j = i / 50L;
                        if (this.server.getWarnOnOverload()) {
                            field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                        }
                        this.field_211151_aa += j * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    if (tickCount++ % 100L == 0L) {
                        double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                        this.recentTps[0] = MinecraftServerMixin.calcTps(this.recentTps[0], 0.92, currentTps);
                        this.recentTps[1] = MinecraftServerMixin.calcTps(this.recentTps[1], 0.9835, currentTps);
                        this.recentTps[2] = MinecraftServerMixin.calcTps(this.recentTps[2], 0.9945, currentTps);
                        tickSection = curTime;
                    }
                    currentTick = (int)(System.currentTimeMillis() / 50L);
                    this.field_211151_aa += 50L;
                    LongTickDetector longtickdetector = LongTickDetector.func_233524_a_((String)"Server");
                    this.func_240773_a_(longtickdetector);
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.func_240795_b_(longtickdetector);
                    this.field_71296_Q = true;
                }
                ServerLifecycleHooks.handleServerStopping((MinecraftServer)((MinecraftServer)this));
                ServerLifecycleHooks.expectServerStopped();
            } else {
                ServerLifecycleHooks.expectServerStopped();
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable1) {
            File file1;
            CrashReport crashreport;
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            if (throwable1.getCause() != null) {
                field_147145_h.error("\tCause of unexpected exception was", throwable1.getCause());
            }
            if ((crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1))).func_147149_a(file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt"))) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(crashreport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                WatchdogThread.doStop();
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)((MinecraftServer)this));
                this.func_71240_o();
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"stopServer"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setStopped(CallbackInfo ci) {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                ci.cancel();
                return;
            }
            this.hasStopped = true;
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="INVOKE", remap=false, ordinal=0, shift=At.Shift.AFTER, target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;)V")})
    public void arclight$unloadPlugins(CallbackInfo ci) {
        if (this.server != null) {
            this.server.disablePlugins();
        }
    }

    @Inject(method={"func_240787_a_"}, at={@At(value="RETURN")})
    public void arclight$enablePlugins(IChunkStatusListener p_240787_1_, CallbackInfo ci) {
        BukkitRegistry.unlockRegistries();
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        BukkitRegistry.lockRegistries();
        this.server.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
    }

    private void executeModerately() {
        this.func_213160_bf();
        this.bridge$drainQueuedTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    @Override
    public void bridge$drainQueuedTasks() {
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
    }

    @Inject(method={"isAheadOfTime"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forceAheadOfTime(CallbackInfoReturnable<Boolean> cir) {
        if (this.forceTicks) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"func_240787_a_"}, at={@At(value="NEW", ordinal=0, target="net/minecraft/world/server/ServerWorld")})
    private void arclight$registerEnv(IChunkStatusListener p_240787_1_, CallbackInfo ci) {
        BukkitRegistry.registerEnvironments();
    }

    @Redirect(method={"func_240787_a_"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object arclight$worldInit(Map<Object, Object> map, Object key, Object value) {
        Object ret = map.put(key, value);
        ServerWorld serverWorld = (ServerWorld)value;
        if (((CraftServer)Bukkit.getServer()).scoreboardManager == null) {
            ((CraftServer)Bukkit.getServer()).scoreboardManager = new CraftScoreboardManager((MinecraftServer)this, (Scoreboard)serverWorld.func_96441_U());
        }
        if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
            ((WorldBridge)serverWorld).bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        Bukkit.getPluginManager().callEvent(new WorldInitEvent(((WorldBridge)serverWorld).bridge$getWorld()));
        return ret;
    }

    @Overwrite
    public void func_213186_a(IChunkStatusListener listener) {
        StructureSpawnManager.gatherEntitySpawns();
        ServerWorld serverworld = this.func_241755_D_();
        this.forceTicks = true;
        field_147145_h.info("Preparing start region for dimension {}", (Object)serverworld.func_234923_W_().func_240901_a_());
        BlockPos blockpos = serverworld.func_241135_u_();
        listener.func_219509_a(new ChunkPos(blockpos));
        ServerChunkProvider serverchunkprovider = serverworld.func_72863_F();
        serverchunkprovider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        serverchunkprovider.func_217228_a(TicketType.field_219488_a, new ChunkPos(blockpos), 11, (Object)Unit.INSTANCE);
        while (serverchunkprovider.func_217229_b() < 441) {
            this.executeModerately();
        }
        this.executeModerately();
        for (ServerWorld serverWorld : this.field_71305_c.values()) {
            ForcedChunksSaveData forcedchunkssavedata;
            if (((WorldBridge)serverWorld).bridge$getWorld().getKeepSpawnInMemory() && (forcedchunkssavedata = (ForcedChunksSaveData)serverWorld.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks")) != null) {
                LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
                while (longiterator.hasNext()) {
                    long i = longiterator.nextLong();
                    ChunkPos chunkpos = new ChunkPos(i);
                    serverWorld.func_72863_F().func_217206_a(chunkpos, true);
                }
                ForgeChunkManager.reinstatePersistentChunks((ServerWorld)serverWorld, (ForcedChunksSaveData)forcedchunkssavedata);
            }
            Bukkit.getPluginManager().callEvent(new WorldLoadEvent(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        this.executeModerately();
        listener.func_219510_b();
        serverchunkprovider.func_212863_j_().func_215598_a(5);
        this.func_240794_aZ_();
        this.forceTicks = false;
    }

    public void initWorld(ServerWorld serverWorld, IServerWorldInfo worldInfo, IServerConfiguration saveData, DimensionGeneratorSettings generatorSettings) {
        boolean flag = generatorSettings.func_236227_h_();
        if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
            ((WorldBridge)serverWorld).bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        WorldBorder worldborder = serverWorld.func_175723_af();
        worldborder.func_235926_a_(worldInfo.func_230398_q_());
        if (!worldInfo.func_76070_v()) {
            try {
                MinecraftServerMixin.func_240786_a_(serverWorld, worldInfo, generatorSettings.func_236223_d_(), flag, true);
                worldInfo.func_76091_d(true);
                if (flag) {
                    this.func_240778_a_(this.field_240768_i_);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception initializing level");
                try {
                    serverWorld.func_72914_a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            worldInfo.func_76091_d(true);
        }
    }

    public void loadSpawn(IChunkStatusListener listener, ServerWorld serverWorld) {
        this.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)serverWorld));
        if (!((WorldBridge)serverWorld).bridge$getWorld().getKeepSpawnInMemory()) {
            return;
        }
        this.forceTicks = true;
        field_147145_h.info("Preparing start region for dimension {}", (Object)serverWorld.func_234923_W_().func_240901_a_());
        BlockPos blockpos = serverWorld.func_241135_u_();
        listener.func_219509_a(new ChunkPos(blockpos));
        ServerChunkProvider serverchunkprovider = serverWorld.func_72863_F();
        serverchunkprovider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        serverchunkprovider.func_217228_a(TicketType.field_219488_a, new ChunkPos(blockpos), 11, (Object)Unit.INSTANCE);
        while (serverchunkprovider.func_217229_b() < 441) {
            this.executeModerately();
        }
        this.executeModerately();
        ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)serverWorld.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        if (forcedchunkssavedata != null) {
            LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(i);
                serverWorld.func_72863_F().func_217206_a(chunkpos, true);
            }
            ForgeChunkManager.reinstatePersistentChunks((ServerWorld)serverWorld, (ForcedChunksSaveData)forcedchunkssavedata);
        }
        this.executeModerately();
        listener.func_219510_b();
        serverchunkprovider.func_212863_j_().func_215598_a(5);
        this.func_240794_aZ_();
        this.forceTicks = false;
    }

    @Inject(method={"updateTimeLightAndEntities"}, at={@At(value="HEAD")})
    public void arclight$runScheduler(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ArclightConstants.currentTick = (int)(System.currentTimeMillis() / 50L);
        this.server.getScheduler().mainThreadHeartbeat(this.field_71315_w);
        this.bridge$drainQueuedTasks();
    }

    @Inject(method={"save"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_241755_D_()Lnet/minecraft/world/server/ServerWorld;")})
    private void arclight$skipSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir, boolean flag) {
        cir.setReturnValue((Object)flag);
    }

    @Overwrite
    public String getServerModName() {
        return BrandingControl.getServerBranding() + " arclight";
    }

    @Override
    public void bridge$setAutosavePeriod(int autosavePeriod) {
        this.autosavePeriod = autosavePeriod;
    }

    @Override
    public void bridge$setConsole(ConsoleCommandSender console) {
        this.console = console;
    }

    @Override
    public void bridge$setServer(CraftServer server) {
        this.server = server;
    }

    @Override
    public RemoteConsoleCommandSender bridge$getRemoteConsole() {
        return this.remoteConsole;
    }

    @Override
    public void bridge$setRemoteConsole(RemoteConsoleCommandSender sender) {
        this.remoteConsole = sender;
    }

    @Override
    public void bridge$queuedProcess(Runnable runnable) {
        this.processQueue.add(runnable);
    }

    public CommandSender getBukkitSender(CommandSource wrapper) {
        return this.console;
    }

    @Override
    public CommandSender bridge$getBukkitSender(CommandSource wrapper) {
        return this.getBukkitSender(wrapper);
    }

    @Override
    public Commands bridge$getVanillaCommands() {
        return this.vanillaCommandDispatcher;
    }

    public boolean isDebugging() {
        return false;
    }

    private static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    static {
        currentTick = (int)(System.currentTimeMillis() / 50L);
    }
}

