/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.izzel.arclight.api.ArclightVersion;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.InternalEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.network.login.ServerLoginNetHandlerBridge;
import io.izzel.arclight.common.bridge.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.server.management.PlayerListBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Eject;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.PlayerData;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    public PlayerData field_72412_k;
    @Shadow
    @Final
    private BanList field_72401_g;
    @Shadow
    @Final
    private static SimpleDateFormat field_72403_e;
    @Shadow
    @Final
    private IPBanList field_72413_h;
    @Shadow
    @Final
    public List<ServerPlayerEntity> field_72404_b;
    @Shadow
    @Final
    protected int field_72405_c;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    @Final
    private Map<UUID, ServerPlayerEntity> field_177454_f;
    private CraftServer cserver;
    private transient Location arclight$loc;
    private transient Boolean arclight$suffo;

    @Override
    @Accessor(value="players")
    @Mutable
    public abstract void bridge$setPlayers(List<ServerPlayerEntity> var1);

    @Override
    @Accessor(value="players")
    public abstract List<ServerPlayerEntity> bridge$getPlayers();

    @Shadow
    public abstract boolean func_152607_e(GameProfile var1);

    @Shadow
    public abstract boolean func_183023_f(GameProfile var1);

    @Shadow
    protected abstract void func_72391_b(ServerPlayerEntity var1);

    @Shadow
    public abstract BanList func_152608_h();

    @Shadow
    public abstract IPBanList func_72363_f();

    @Shadow(remap=false)
    public abstract boolean removePlayer(ServerPlayerEntity var1);

    @Shadow
    public abstract void func_72354_b(ServerPlayerEntity var1, ServerWorld var2);

    @Shadow
    public abstract void func_187243_f(ServerPlayerEntity var1);

    @Shadow(remap=false)
    public abstract boolean addPlayer(ServerPlayerEntity var1);

    @Shadow
    public abstract void func_72385_f(ServerPlayerEntity var1);

    @Shadow
    public abstract void func_232641_a_(ITextComponent var1, ChatType var2, UUID var3);

    @Shadow
    @Nullable
    public abstract ServerPlayerEntity func_177451_a(UUID var1);

    @Shadow
    protected abstract void func_72381_a(ServerPlayerEntity var1, @org.jetbrains.annotations.Nullable ServerPlayerEntity var2, ServerWorld var3);

    @Override
    public CraftServer bridge$getCraftServer() {
        return this.cserver;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$loadServer(MinecraftServer minecraftServer, DynamicRegistries.Impl p_i231425_2_, PlayerData p_i231425_3_, int p_i231425_4_, CallbackInfo ci) {
        this.cserver = ArclightServer.createOrLoad((DedicatedServer)minecraftServer, (PlayerList)this);
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(Lnet/minecraft/util/RegistryKey;)Lnet/minecraft/world/server/ServerWorld;"))
    private ServerWorld arclight$spawnLocationEvent(MinecraftServer minecraftServer, RegistryKey<World> dimension, NetworkManager netManager, ServerPlayerEntity playerIn) {
        CraftPlayer player = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity();
        PlayerSpawnLocationEvent event = new PlayerSpawnLocationEvent(player, player.getLocation());
        this.cserver.getPluginManager().callEvent(event);
        Location loc = event.getSpawnLocation();
        ServerWorld world = ((CraftWorld)loc.getWorld()).getHandle();
        playerIn.func_70029_a((World)world);
        playerIn.func_70080_a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        return world;
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/management/PlayerList;viewDistance:I"))
    private int arclight$spigotViewDistance(PlayerList playerList, NetworkManager netManager, ServerPlayerEntity playerIn) {
        return ((WorldBridge)playerIn.func_71121_q()).bridge$spigotConfig().viewDistance;
    }

    @Eject(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;func_232641_a_(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    private void arclight$playerJoin(PlayerList playerList, ITextComponent component, ChatType chatType, UUID uuid, CallbackInfo ci, NetworkManager netManager, ServerPlayerEntity playerIn) {
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent(this.cserver.getPlayer(playerIn), CraftChatMessage.fromComponent(component));
        this.field_72404_b.add(playerIn);
        this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        this.cserver.getPluginManager().callEvent(playerJoinEvent);
        if (!playerIn.field_71135_a.field_147371_a.func_150724_d()) {
            ci.cancel();
            return;
        }
        this.field_72404_b.remove(playerIn);
        String joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (ITextComponent line : CraftChatMessage.fromString(joinMessage)) {
                this.field_72400_f.func_184103_al().func_148540_a((IPacket)new SChatPacket(line, ChatType.SYSTEM, Util.field_240973_b_));
            }
        }
    }

    @Inject(method={"func_212504_a"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfSet(ServerWorld world, CallbackInfo ci) {
        if (this.field_72412_k != null) {
            ci.cancel();
        }
    }

    @Inject(method={"writePlayerData"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfNotPersist(ServerPlayerEntity playerIn, CallbackInfo ci) {
        if (!((ServerPlayerEntityBridge)playerIn).bridge$isPersist()) {
            ci.cancel();
        }
    }

    @Inject(method={"playerLoggedOut"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;writePlayerData(Lnet/minecraft/entity/player/ServerPlayerEntity;)V")})
    private void arclight$playerQuitPre(ServerPlayerEntity playerIn, CallbackInfo ci) {
        if (playerIn.field_71069_bz != playerIn.field_71070_bA) {
            ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().closeInventory();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent(this.cserver.getPlayer(playerIn), "\u00a7e" + playerIn.func_195047_I_() + " left the game");
        this.cserver.getPluginManager().callEvent(playerQuitEvent);
        ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        playerIn.func_71127_g();
        ArclightCaptures.captureQuitMessage(playerQuitEvent.getQuitMessage());
        this.cserver.getScoreboardManager().removePlayer(((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity());
    }

    @Override
    public ServerPlayerEntity bridge$canPlayerLogin(SocketAddress socketAddress, GameProfile gameProfile, ServerLoginNetHandler handler) {
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)gameProfile);
        ArrayList<ServerPlayerEntity> list = Lists.newArrayList();
        for (ServerPlayerEntity entityplayer : this.field_72404_b) {
            if (!entityplayer.func_110124_au().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (ServerPlayerEntity entityplayer : list) {
            this.func_72391_b(entityplayer);
            entityplayer.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.duplicate_login"));
        }
        ServerPlayerEntity entity = new ServerPlayerEntity(this.field_72400_f, this.field_72400_f.func_71218_a(World.field_234918_g_), gameProfile, new PlayerInteractionManager(this.field_72400_f.func_71218_a(World.field_234918_g_)));
        CraftPlayer player = ((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity();
        String hostname = handler == null ? "" : ((ServerLoginNetHandlerBridge)handler).bridge$getHostname();
        InetAddress realAddress = handler == null ? ((InetSocketAddress)socketAddress).getAddress() : ((InetSocketAddress)((NetworkManagerBridge)handler.field_147333_a).bridge$getRawAddress()).getAddress();
        PlayerLoginEvent event = new PlayerLoginEvent(player, hostname, ((InetSocketAddress)socketAddress).getAddress(), realAddress);
        if (this.func_152608_h().func_152702_a(gameProfile) && !((ProfileBanEntry)this.func_152608_h().func_152683_b((Object)gameProfile)).func_73682_e()) {
            ProfileBanEntry gameprofilebanentry = (ProfileBanEntry)this.field_72401_g.func_152683_b((Object)gameProfile);
            TranslationTextComponent chatmessage = new TranslationTextComponent("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.func_73686_f()});
            if (gameprofilebanentry.func_73680_d() != null) {
                chatmessage.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned.expiration", new Object[]{field_72403_e.format(gameprofilebanentry.func_73680_d())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((ITextComponent)chatmessage));
        } else if (!this.func_152607_e(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.func_72363_f().func_152708_a(socketAddress) && !this.func_72363_f().func_152709_b(socketAddress).func_73682_e()) {
            IPBanEntry ipbanentry = this.field_72413_h.func_152709_b(socketAddress);
            TranslationTextComponent chatmessage = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.func_73686_f()});
            if (ipbanentry.func_73680_d() != null) {
                chatmessage.func_230529_a_((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", new Object[]{field_72403_e.format(ipbanentry.func_73680_d())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((ITextComponent)chatmessage));
        } else if (this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent(event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            if (handler != null) {
                handler.func_194026_b(CraftChatMessage.fromStringOrNull(event.getKickMessage()));
            }
            return null;
        }
        return entity;
    }

    public ServerPlayerEntity moveToWorld(ServerPlayerEntity playerIn, ServerWorld worldIn, boolean flag, Location location, boolean avoidSuffocation) {
        playerIn.func_184210_p();
        this.removePlayer(playerIn);
        playerIn.func_71121_q().removePlayer(playerIn, true);
        playerIn.revive();
        BlockPos pos = playerIn.func_241140_K_();
        float f = playerIn.func_242109_L();
        boolean flag2 = playerIn.func_241142_M_();
        org.bukkit.World fromWorld = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().getWorld();
        playerIn.field_71136_j = false;
        boolean flag3 = false;
        if (location == null) {
            boolean isBedSpawn = false;
            ServerWorld spawnWorld = this.field_72400_f.func_71218_a(playerIn.func_241141_L_());
            if (spawnWorld != null) {
                Optional optional = pos != null ? PlayerEntity.func_242374_a((ServerWorld)spawnWorld, (BlockPos)pos, (float)f, (boolean)flag2, (boolean)flag) : Optional.empty();
                if (optional.isPresent()) {
                    float f2;
                    BlockState iblockdata = spawnWorld.func_180495_p(pos);
                    boolean flag4 = iblockdata.func_203425_a(Blocks.field_235400_nj_);
                    Vector3d vec3d = (Vector3d)optional.get();
                    if (!iblockdata.func_235714_a_((ITag)BlockTags.field_219747_F) && !flag4) {
                        f2 = f;
                    } else {
                        Vector3d vec3d2 = Vector3d.func_237492_c_((Vector3i)pos).func_178788_d(vec3d).func_72432_b();
                        f2 = (float)MathHelper.func_76138_g((double)(MathHelper.func_181159_b((double)vec3d2.field_72449_c, (double)vec3d2.field_72450_a) * 57.2957763671875 - 90.0));
                    }
                    playerIn.func_242111_a(spawnWorld.func_234923_W_(), pos, f2, flag2, false);
                    flag3 = !flag && flag4;
                    isBedSpawn = true;
                    location = new Location(((WorldBridge)spawnWorld).bridge$getWorld(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                } else if (pos != null) {
                    playerIn.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241764_a_, 0.0f));
                }
            }
            if (location == null) {
                spawnWorld = this.field_72400_f.func_71218_a(World.field_234918_g_);
                pos = ((ServerPlayerEntityBridge)playerIn).bridge$getSpawnPoint(spawnWorld);
                location = new Location(((WorldBridge)spawnWorld).bridge$getWorld(), (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.1f, (float)pos.func_177952_p() + 0.5f);
            }
            Player respawnPlayer = this.cserver.getPlayer(playerIn);
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(respawnPlayer, location, isBedSpawn && !flag3, flag3);
            this.cserver.getPluginManager().callEvent(respawnEvent);
            if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
                return playerIn;
            }
            location = respawnEvent.getRespawnLocation();
            if (!flag) {
                ((ServerPlayerEntityBridge)playerIn).bridge$reset();
            }
        } else {
            location.setWorld(((WorldBridge)worldIn).bridge$getWorld());
        }
        ServerWorld serverWorld = ((CraftWorld)location.getWorld()).getHandle();
        playerIn.func_70080_a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        playerIn.field_71135_a.func_184342_d();
        while (avoidSuffocation && !serverWorld.func_226669_j_((Entity)playerIn) && playerIn.func_226278_cu_() < 256.0) {
            playerIn.func_70107_b(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 1.0, playerIn.func_226281_cx_());
        }
        IWorldInfo worlddata = serverWorld.func_72912_H();
        playerIn.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(serverWorld.func_230315_m_(), serverWorld.func_234923_W_(), BiomeManager.func_235200_a_((long)serverWorld.func_72905_C()), playerIn.field_71134_c.func_73081_b(), playerIn.field_71134_c.func_241815_c_(), serverWorld.func_234925_Z_(), serverWorld.func_241109_A_(), flag));
        playerIn.field_71135_a.func_147359_a((IPacket)new SUpdateViewDistancePacket(((WorldBridge)serverWorld).bridge$spigotConfig().viewDistance));
        playerIn.func_70029_a((World)serverWorld);
        ((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$teleport(new Location(((WorldBridge)serverWorld).bridge$getWorld(), playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), playerIn.field_70177_z, playerIn.field_70125_A));
        playerIn.func_226284_e_(false);
        playerIn.field_71135_a.func_147359_a((IPacket)new SWorldSpawnChangedPacket(serverWorld.func_241135_u_(), serverWorld.func_242107_v()));
        playerIn.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worlddata.func_176130_y(), worlddata.func_176123_z()));
        playerIn.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(playerIn.field_71106_cc, playerIn.field_71067_cb, playerIn.field_71068_ca));
        this.func_72354_b(playerIn, serverWorld);
        this.func_187243_f(playerIn);
        if (!((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
            serverWorld.func_217446_a(playerIn);
            this.addPlayer(playerIn);
            this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        }
        playerIn.func_70606_j(playerIn.func_110143_aJ());
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)playerIn, (RegistryKey)((CraftWorld)fromWorld).getHandle().field_73011_w, (RegistryKey)serverWorld.field_73011_w);
        if (flag3) {
            playerIn.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_232818_ms_, SoundCategory.BLOCKS, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, 1.0f));
        }
        this.func_72385_f(playerIn);
        playerIn.func_71016_p();
        for (Object o1 : playerIn.func_70651_bq()) {
            EffectInstance mobEffect = (EffectInstance)o1;
            playerIn.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(playerIn.func_145782_y(), mobEffect));
        }
        playerIn.func_213846_b(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity(), fromWorld);
            Bukkit.getPluginManager().callEvent(event);
        }
        if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
            this.func_72391_b(playerIn);
        }
        return playerIn;
    }

    @Overwrite
    public ServerPlayerEntity func_232644_a_(ServerPlayerEntity playerIn, boolean conqueredEnd) {
        Location location = this.arclight$loc;
        this.arclight$loc = null;
        boolean avoidSuffocation = this.arclight$suffo == null || this.arclight$suffo != false;
        this.arclight$suffo = null;
        playerIn.func_184210_p();
        this.removePlayer(playerIn);
        playerIn.func_71121_q().removePlayer(playerIn, true);
        BlockPos pos = playerIn.func_241140_K_();
        float f = playerIn.func_242109_L();
        boolean flag2 = playerIn.func_241142_M_();
        org.bukkit.World fromWorld = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().getWorld();
        playerIn.field_71136_j = false;
        boolean flag3 = false;
        ServerWorld spawnWorld = this.field_72400_f.func_71218_a(playerIn.func_241141_L_());
        if (location == null) {
            boolean isBedSpawn = false;
            if (spawnWorld != null) {
                Optional optional = pos != null ? PlayerEntity.func_242374_a((ServerWorld)spawnWorld, (BlockPos)pos, (float)f, (boolean)flag2, (boolean)conqueredEnd) : Optional.empty();
                if (optional.isPresent()) {
                    float f2;
                    BlockState iblockdata = spawnWorld.func_180495_p(pos);
                    boolean flag4 = iblockdata.func_203425_a(Blocks.field_235400_nj_);
                    Vector3d vec3d = (Vector3d)optional.get();
                    if (!iblockdata.func_235714_a_((ITag)BlockTags.field_219747_F) && !flag4) {
                        f2 = f;
                    } else {
                        Vector3d vec3d2 = Vector3d.func_237492_c_((Vector3i)pos).func_178788_d(vec3d).func_72432_b();
                        f2 = (float)MathHelper.func_76138_g((double)(MathHelper.func_181159_b((double)vec3d2.field_72449_c, (double)vec3d2.field_72450_a) * 57.2957763671875 - 90.0));
                    }
                    playerIn.func_242111_a(spawnWorld.func_234923_W_(), pos, f2, flag2, false);
                    flag3 = !flag2 && flag4;
                    isBedSpawn = true;
                    location = new Location(((WorldBridge)spawnWorld).bridge$getWorld(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                } else if (pos != null) {
                    playerIn.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241764_a_, 0.0f));
                }
            }
            if (location == null) {
                spawnWorld = this.field_72400_f.func_71218_a(World.field_234918_g_);
                pos = ((ServerPlayerEntityBridge)playerIn).bridge$getSpawnPoint(spawnWorld);
                location = new Location(((WorldBridge)spawnWorld).bridge$getWorld(), (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.1f, (float)pos.func_177952_p() + 0.5f);
            }
            Player respawnPlayer = this.cserver.getPlayer(playerIn);
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(respawnPlayer, location, isBedSpawn && !flag3, flag3);
            this.cserver.getPluginManager().callEvent(respawnEvent);
            if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
                return playerIn;
            }
            location = respawnEvent.getRespawnLocation();
            if (!conqueredEnd) {
                ((ServerPlayerEntityBridge)playerIn).bridge$reset();
            }
        } else {
            location.setWorld(((WorldBridge)spawnWorld).bridge$getWorld());
        }
        ServerWorld serverWorld = ((CraftWorld)location.getWorld()).getHandle();
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(serverWorld) : new PlayerInteractionManager(serverWorld);
        ServerPlayerEntity serverplayerentity = new ServerPlayerEntity(this.field_72400_f, serverWorld, playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        ((InternalEntityBridge)playerIn).internal$getBukkitEntity().setHandle((Entity)serverplayerentity);
        ((EntityBridge)serverplayerentity).bridge$setBukkitEntity(((InternalEntityBridge)playerIn).internal$getBukkitEntity());
        if (playerIn instanceof MobEntity) {
            ((MobEntity)playerIn).func_110160_i(true, false);
        }
        playerIn.field_71135_a.field_147369_b = serverplayerentity;
        serverplayerentity.field_71135_a = playerIn.field_71135_a;
        serverplayerentity.func_193104_a(playerIn, conqueredEnd);
        serverplayerentity.func_242111_a(playerIn.func_241141_L_(), playerIn.func_241140_K_(), playerIn.func_242109_L(), playerIn.func_241142_M_(), false);
        if (!conqueredEnd) {
            serverplayerentity.field_71071_by.func_70455_b(playerIn.field_71071_by);
        }
        playerIn.remove(false);
        serverplayerentity.func_145769_d(playerIn.func_145782_y());
        serverplayerentity.func_184819_a(playerIn.func_184591_cq());
        for (Object s2 : playerIn.func_184216_O()) {
            serverplayerentity.func_184211_a((String)s2);
        }
        serverplayerentity.func_70080_a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        serverplayerentity.field_71135_a.func_184342_d();
        this.func_72381_a(serverplayerentity, playerIn, serverWorld);
        while (avoidSuffocation && !serverWorld.func_226669_j_((Entity)serverplayerentity) && serverplayerentity.func_226278_cu_() < 256.0) {
            serverplayerentity.func_70107_b(serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_() + 1.0, serverplayerentity.func_226281_cx_());
        }
        IWorldInfo iworldinfo = serverplayerentity.field_70170_p.func_72912_H();
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(serverplayerentity.field_70170_p.func_230315_m_(), serverplayerentity.field_70170_p.func_234923_W_(), BiomeManager.func_235200_a_((long)serverplayerentity.func_71121_q().func_72905_C()), serverplayerentity.field_71134_c.func_73081_b(), serverplayerentity.field_71134_c.func_241815_c_(), serverplayerentity.func_71121_q().func_234925_Z_(), serverplayerentity.func_71121_q().func_241109_A_(), conqueredEnd));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SUpdateViewDistancePacket(((WorldBridge)serverWorld).bridge$spigotConfig().viewDistance));
        serverplayerentity.func_70029_a((World)serverWorld);
        ((ServerPlayNetHandlerBridge)serverplayerentity.field_71135_a).bridge$teleport(new Location(((WorldBridge)serverWorld).bridge$getWorld(), serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_(), serverplayerentity.func_226281_cx_(), serverplayerentity.field_70177_z, serverplayerentity.field_70125_A));
        serverplayerentity.func_226284_e_(false);
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SWorldSpawnChangedPacket(serverWorld.func_241135_u_(), serverWorld.func_242107_v()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(serverplayerentity.field_71106_cc, serverplayerentity.field_71067_cb, serverplayerentity.field_71068_ca));
        this.func_72354_b(serverplayerentity, serverWorld);
        this.func_187243_f(serverplayerentity);
        if (!((ServerPlayNetHandlerBridge)serverplayerentity.field_71135_a).bridge$isDisconnected()) {
            serverWorld.func_217433_d(serverplayerentity);
            this.addPlayer(serverplayerentity);
            this.field_177454_f.put(serverplayerentity.func_110124_au(), serverplayerentity);
        }
        serverplayerentity.func_71116_b();
        serverplayerentity.func_70606_j(serverplayerentity.func_110143_aJ());
        BasicEventHooks.firePlayerRespawnEvent((PlayerEntity)serverplayerentity, (boolean)conqueredEnd);
        if (flag2) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_232818_ms_, SoundCategory.BLOCKS, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, 1.0f));
        }
        this.func_72385_f(serverplayerentity);
        serverplayerentity.func_71016_p();
        for (Object o1 : serverplayerentity.func_70651_bq()) {
            EffectInstance mobEffect = (EffectInstance)o1;
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(serverplayerentity.func_145782_y(), mobEffect));
        }
        serverplayerentity.func_213846_b(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)((ServerPlayerEntityBridge)serverplayerentity).bridge$getBukkitEntity(), fromWorld);
            Bukkit.getPluginManager().callEvent(event);
        }
        if (((ServerPlayNetHandlerBridge)serverplayerentity.field_71135_a).bridge$isDisconnected()) {
            this.func_72391_b(serverplayerentity);
        }
        return serverplayerentity;
    }

    public void sendAll(IPacket<?> packet, PlayerEntity entityhuman) {
        for (ServerPlayerEntity entityplayer : this.field_72404_b) {
            if (entityhuman instanceof ServerPlayerEntity && !((ServerPlayerEntityBridge)entityplayer).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)entityhuman).bridge$getBukkitEntity())) continue;
            entityplayer.field_71135_a.func_147359_a(packet);
        }
    }

    public void sendAll(IPacket<?> packet, World world) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            ((ServerPlayerEntity)world.func_217369_A().get((int)i)).field_71135_a.func_147359_a(packet);
        }
    }

    @Inject(method={"sendPlayerPermissionLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCommandManager()Lnet/minecraft/command/Commands;")})
    private void arclight$calculatePerms(ServerPlayerEntity player, int permLevel, CallbackInfo ci) {
        ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity().recalculatePermissions();
    }

    @Redirect(method={"sendInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setPlayerHealthUpdated()V"))
    private void arclight$useScaledHealth(ServerPlayerEntity playerEntity) {
        ((ServerPlayerEntityBridge)playerEntity).bridge$getBukkitEntity().updateScaledHealth();
        int i = playerEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223612_o) ? 22 : 23;
        playerEntity.field_71135_a.func_147359_a((IPacket)new SEntityStatusPacket((Entity)playerEntity, (byte)i));
        if (ArclightVersion.atLeast(ArclightVersion.v1_15)) {
            float immediateRespawn = playerEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226683_z_) ? 1.0f : 0.0f;
            playerEntity.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241775_l_, immediateRespawn));
        }
    }

    public void sendMessage(ITextComponent[] components) {
        for (ITextComponent component : components) {
            this.func_232641_a_(component, ChatType.SYSTEM, Util.field_240973_b_);
        }
    }

    @Override
    public void bridge$sendMessage(ITextComponent[] components) {
        this.sendMessage(components);
    }

    @Redirect(method={"func_232641_a_"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SChatPacket"))
    private SChatPacket arclight$addWebLinks(ITextComponent message, ChatType type, UUID uuid) {
        return new SChatPacket(CraftChatMessage.fixComponent(message), type, uuid);
    }

    public ServerStatisticsManager getStatisticManager(ServerPlayerEntity entityhuman) {
        ServerStatisticsManager serverstatisticmanager = entityhuman.func_147099_x();
        return serverstatisticmanager == null ? this.getStatisticManager(entityhuman.func_110124_au(), entityhuman.func_200200_C_().getString()) : serverstatisticmanager;
    }

    public ServerStatisticsManager getStatisticManager(UUID uuid, String displayName) {
        ServerPlayerEntity entityhuman = this.func_177451_a(uuid);
        ServerStatisticsManager serverstatisticmanager = entityhuman == null ? null : entityhuman.func_147099_x();
        ServerStatisticsManager serverStatisticsManager = serverstatisticmanager;
        if (serverstatisticmanager == null) {
            File file2;
            File file = this.field_72400_f.func_240776_a_(FolderName.field_237246_b_).toFile();
            File file1 = new File(file, uuid + ".json");
            if (!file1.exists() && (file2 = new File(file, String.valueOf(displayName) + ".json")).exists() && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticsManager(this.field_72400_f, file1);
        }
        return serverstatisticmanager;
    }
}

