/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.server;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.world.ExplosionBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.world.server.ServerWorldBridge;
import io.izzel.arclight.common.bridge.world.storage.DerivedWorldInfoBridge;
import io.izzel.arclight.common.bridge.world.storage.MapDataBridge;
import io.izzel.arclight.common.bridge.world.storage.WorldInfoBridge;
import io.izzel.arclight.common.mixin.core.world.WorldMixin;
import io.izzel.arclight.common.mod.server.world.WorldSymlink;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.DelegateWorldInfo;
import io.izzel.arclight.i18n.ArclightConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_16_R3.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_16_R3.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerWorld.class})
@Implements(value={@Interface(iface=ServerWorldBridge.Hack.class, prefix="hack$")})
public abstract class ServerWorldMixin
extends WorldMixin
implements ServerWorldBridge {
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_217491_A;
    @Shadow
    @Final
    public Int2ObjectMap<Entity> field_217498_x;
    @Shadow
    private boolean field_73068_P;
    @Shadow
    @Final
    private ServerChunkProvider field_241102_C_;
    @Shadow
    @Final
    public static BlockPos field_241108_a_;
    @Shadow
    @Final
    public IServerWorldInfo field_241103_E_;
    public ServerWorldInfo $$worldDataServer;
    public SaveFormat.LevelSave convertable;
    public UUID uuid;
    private transient boolean arclight$force;
    private transient LightningStrikeEvent.Cause arclight$cause;
    private transient CreatureSpawnEvent.SpawnReason arclight$reason;
    private transient boolean arclight$timeSkipCancelled;

    @Shadow
    public abstract boolean func_217376_c(Entity var1);

    @Shadow
    public abstract boolean func_217470_d(Entity var1);

    @Shadow
    public abstract <T extends IParticleData> int func_195598_a(T var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    @Shadow
    protected abstract boolean func_195601_a(ServerPlayerEntity var1, boolean var2, double var3, double var5, double var7, IPacket<?> var9);

    @Override
    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$func_73046_m();

    @Shadow
    public abstract ServerChunkProvider func_72863_F();

    @Shadow
    protected abstract void func_229856_ab_();

    @Shadow
    protected abstract boolean func_217478_l(Entity var1);

    public void arclight$constructor(MinecraftServer server, Executor backgroundExecutor, SaveFormat.LevelSave levelSave, IServerWorldInfo serverWorldInfo, RegistryKey<World> dimension, DimensionType dimensionType, IChunkStatusListener statusListener, ChunkGenerator chunkGenerator, boolean isDebug, long seed, List<ISpecialSpawner> specialSpawners, boolean shouldBeTicking) {
        throw new RuntimeException();
    }

    public void arclight$constructor(MinecraftServer server, Executor backgroundExecutor, SaveFormat.LevelSave levelSave, IServerWorldInfo serverWorldInfo, RegistryKey<World> dimension, DimensionType dimensionType, IChunkStatusListener statusListener, ChunkGenerator chunkGenerator, boolean isDebug, long seed, List<ISpecialSpawner> specialSpawners, boolean shouldBeTicking, World.Environment env, org.bukkit.generator.ChunkGenerator gen) {
        this.arclight$constructor(server, backgroundExecutor, levelSave, serverWorldInfo, dimension, dimensionType, statusListener, chunkGenerator, isDebug, seed, specialSpawners, shouldBeTicking);
        this.generator = gen;
        this.environment = env;
        if (gen != null) {
            CustomChunkGenerator generator = new CustomChunkGenerator((ServerWorld)this, this.field_241102_C_.func_201711_g(), gen);
            ((ServerChunkProviderBridge)this.field_241102_C_).bridge$setChunkGenerator(generator);
        }
        this.bridge$getWorld();
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/storage/SaveFormat$LevelSave;Lnet/minecraft/world/storage/IServerWorldInfo;Lnet/minecraft/util/RegistryKey;Lnet/minecraft/world/DimensionType;Lnet/minecraft/world/chunk/listener/IChunkStatusListener;Lnet/minecraft/world/gen/ChunkGenerator;ZJLjava/util/List;Z)V"}, at={@At(value="RETURN")})
    private void arclight$init(MinecraftServer minecraftServer, Executor backgroundExecutor, SaveFormat.LevelSave levelSave, IServerWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, IChunkStatusListener statusListener, ChunkGenerator chunkGenerator, boolean isDebug, long seed, List<ISpecialSpawner> specialSpawners, boolean shouldBeTicking, CallbackInfo ci) {
        this.pvpMode = minecraftServer.func_71219_W();
        this.convertable = levelSave;
        this.uuid = WorldUUID.getUUID(levelSave.func_237291_a_(this.func_234923_W_()));
        if (worldInfo instanceof ServerWorldInfo) {
            this.$$worldDataServer = (ServerWorldInfo)worldInfo;
        } else if (worldInfo instanceof DerivedWorldInfo) {
            this.$$worldDataServer = DelegateWorldInfo.wrap((DerivedWorldInfo)worldInfo);
            ((DerivedWorldInfoBridge)worldInfo).bridge$setDimType(this.getTypeKey());
            if (ArclightConfig.spec().getCompat().isSymlinkWorld()) {
                WorldSymlink.create((DerivedWorldInfo)worldInfo, levelSave.func_237291_a_(this.func_234923_W_()));
            }
        }
        ((ServerChunkProviderBridge)this.field_241102_C_).bridge$setViewDistance(this.spigotConfig.viewDistance);
        ((WorldInfoBridge)this.$$worldDataServer).bridge$setWorld((ServerWorld)this);
    }

    public Chunk getChunkIfLoaded(int x, int z) {
        return this.field_241102_C_.func_217205_a(x, z, false);
    }

    public <T extends IParticleData> int sendParticles(ServerPlayerEntity sender, T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6, boolean force) {
        SSpawnParticlePacket packet = new SSpawnParticlePacket(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        int j = 0;
        for (ServerPlayerEntity entity : this.field_217491_A) {
            if (sender != null && !((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)sender).bridge$getBukkitEntity()) || !this.func_195601_a(entity, force, d0, d1, d2, (IPacket<?>)packet)) continue;
            ++j;
        }
        return j;
    }

    @Override
    public SaveFormat.LevelSave bridge$getConvertable() {
        return this.convertable;
    }

    @Inject(method={"onEntityAdded"}, at={@At(value="RETURN")})
    private void arclight$validEntity(Entity entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$setValid(true);
    }

    @Inject(method={"updateEntity"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/Entity;tick()V")})
    private void arclight$tickPortal(Entity entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$postTick();
    }

    @Inject(method={"tickPassenger"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/Entity;updateRidden()V")})
    private void arclight$tickPortalPassenger(Entity ridingEntity, Entity passengerEntity, CallbackInfo ci) {
        ((EntityBridge)passengerEntity).bridge$postTick();
    }

    @Inject(method={"removeEntityComplete"}, remap=false, at={@At(value="RETURN")})
    private void arclight$invalidEntity(Entity entityIn, boolean keepData, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$setValid(false);
    }

    @Inject(method={"tickEnvironment"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/server/ServerWorld;addEntity(Lnet/minecraft/entity/Entity;)Z")})
    public void arclight$thunder(Chunk chunkIn, int randomTickSpeed, CallbackInfo ci) {
        this.bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.LIGHTNING);
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/server/ServerWorld;addEntity(Lnet/minecraft/entity/Entity;)Z"))
    private boolean arclight$thunder(ServerWorld serverWorld, Entity entityIn) {
        return this.strikeLightning(entityIn, LightningStrikeEvent.Cause.WEATHER);
    }

    public boolean strikeLightning(Entity entity) {
        return this.strikeLightning(entity, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning;
        if (this.arclight$cause != null) {
            cause = this.arclight$cause;
            this.arclight$cause = null;
        }
        if ((lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)((Object)((EntityBridge)entity).bridge$getBukkitEntity()), cause)).isCancelled()) {
            return false;
        }
        return this.func_217376_c(entity);
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    public boolean arclight$snowForm(ServerWorld serverWorld, BlockPos pos, BlockState state) {
        return CraftEventFactory.handleBlockFormEvent((World)serverWorld, pos, state, null);
    }

    @Inject(method={"save"}, at={@At(value="JUMP", ordinal=0, opcode=198)})
    private void arclight$worldSaveEvent(IProgressUpdate progress, boolean flush, boolean skipSave, CallbackInfo ci) {
        Bukkit.getPluginManager().callEvent(new WorldSaveEvent(this.bridge$getWorld()));
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    private void arclight$saveLevelDat(IProgressUpdate progress, boolean flush, boolean skipSave, CallbackInfo ci) {
        if (this.field_241103_E_ instanceof ServerWorldInfo) {
            ServerWorldInfo worldInfo = (ServerWorldInfo)this.field_241103_E_;
            worldInfo.func_230393_a_(this.func_175723_af().func_235927_t_());
            worldInfo.func_230414_b_(this.shadow$func_73046_m().func_201300_aS().func_201380_c());
            this.convertable.func_237288_a_((DynamicRegistries)this.shadow$func_73046_m().field_240767_f_, (IServerConfiguration)worldInfo, this.shadow$func_73046_m().func_184103_al().func_72378_q());
        }
    }

    @Inject(method={"onChunkUnloading"}, at={@At(value="HEAD")})
    public void arclight$closeOnChunkUnloading(Chunk chunkIn, CallbackInfo ci) {
        for (TileEntity tileentity : chunkIn.func_177434_r().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventoryBridge)tileentity).getViewers())) {
                if (!(h2 instanceof CraftHumanEntity)) continue;
                ((CraftHumanEntity)h2).getHandle().func_71053_j();
            }
        }
    }

    @Redirect(method={"spawnParticle(Lnet/minecraft/particles/IParticleData;DDDIDDDD)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;sendPacketWithinDistance(Lnet/minecraft/entity/player/ServerPlayerEntity;ZDDDLnet/minecraft/network/IPacket;)Z"))
    public boolean arclight$particleVisible(ServerWorld serverWorld, ServerPlayerEntity player, boolean longDistance, double posX, double posY, double posZ, IPacket<?> packet) {
        return this.func_195601_a(player, this.arclight$force, posX, posY, posZ, packet);
    }

    public <T extends IParticleData> int sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        this.arclight$force = force;
        return this.func_195598_a(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    @Override
    public <T extends IParticleData> int bridge$sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        return this.sendParticles(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed, force);
    }

    @Override
    public void bridge$pushStrikeLightningCause(LightningStrikeEvent.Cause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public void bridge$strikeLightning(LightningBoltEntity entity, LightningStrikeEvent.Cause cause) {
        this.strikeLightning((Entity)entity, cause);
    }

    @Inject(method={"addEntity0"}, cancellable=true, at={@At(value="INVOKE", remap=false, target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")})
    private void arclight$addEntityEvent(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        CreatureSpawnEvent.SpawnReason reason = this.arclight$reason == null ? CreatureSpawnEvent.SpawnReason.DEFAULT : this.arclight$reason;
        this.arclight$reason = null;
        if (!CraftEventFactory.doEntityAddEventCalling((World)((ServerWorld)this), entityIn, reason)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addEntity0"}, at={@At(value="RETURN")})
    public void arclight$resetReason(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$reason = null;
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        this.arclight$reason = reason;
    }

    @Override
    public CreatureSpawnEvent.SpawnReason bridge$getAddEntityReason() {
        return this.arclight$reason;
    }

    public boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.func_217376_c(entity);
    }

    @Override
    public boolean bridge$addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addEntitySerialized(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.func_217470_d(entity);
    }

    @Override
    public boolean bridge$addEntitySerialized(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntitySerialized(entity, reason);
    }

    public boolean addAllEntitiesSafely(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.func_226276_cg_().anyMatch(this::func_217478_l)) {
            return false;
        }
        return this.bridge$addAllEntities(entity, reason);
    }

    @Override
    public boolean bridge$addAllEntitiesSafely(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addAllEntitiesSafely(entity, reason);
    }

    @Inject(method={"createExplosion"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/Explosion;doExplosionB(Z)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void arclight$doExplosion(Entity entityIn, DamageSource damageSourceIn, @Nullable ExplosionContext context, double xIn, double yIn, double zIn, float explosionRadius, boolean causesFire, Explosion.Mode modeIn, CallbackInfoReturnable<Explosion> cir, Explosion explosion) {
        if (((ExplosionBridge)explosion).bridge$wasCancelled()) {
            cir.setReturnValue((Object)explosion);
        }
    }

    @Overwrite
    @Nullable
    public MapData func_217406_a(String mapName) {
        return (MapData)this.shadow$func_73046_m().func_241755_D_().func_217481_x().func_215753_b(() -> {
            MapData newMap = new MapData(mapName);
            MapInitializeEvent event = new MapInitializeEvent(((MapDataBridge)newMap).bridge$getMapView());
            Bukkit.getServer().getPluginManager().callEvent(event);
            return newMap;
        }, mapName);
    }

    @Inject(method={"updateBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;notifyNeighborsOfStateChange(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)V")})
    private void arclight$returnIfPopulate(BlockPos pos, Block block, CallbackInfo ci) {
        if (this.populating) {
            ci.cancel();
        }
    }

    @Override
    public TileEntity bridge$getTileEntity(BlockPos blockPos) {
        return this.func_175625_s(blockPos);
    }

    public TileEntity hack$getTileEntity(BlockPos pos) {
        return this.func_175625_s(pos);
    }

    @Override
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getTileEntity(pos, true);
    }

    @Override
    public TileEntity getTileEntity(BlockPos pos, boolean validate) {
        TileEntity result = super.func_175625_s(pos);
        if (!validate || Thread.currentThread() != this.arclight$getMainThread()) {
            return result;
        }
        BlockState state = this.func_180495_p(pos);
        Block type = state.func_177230_c();
        if (result != null && type != Blocks.field_150350_a && !result.func_200662_C().func_223045_a(type)) {
            result = this.fixTileEntity(pos, state, type, result);
        }
        return result;
    }

    private TileEntity fixTileEntity(BlockPos pos, Block type, TileEntity found) {
        return this.fixTileEntity(pos, this.func_180495_p(pos), type, found);
    }

    private TileEntity fixTileEntity(BlockPos pos, BlockState state, Block type, TileEntity found) {
        ResourceLocation registryName = found.func_200662_C().getRegistryName();
        if (registryName == null || !registryName.func_110624_b().equals("minecraft")) {
            return found;
        }
        ResourceLocation blockType = type.getRegistryName();
        if (blockType == null || !blockType.func_110624_b().equals("minecraft")) {
            return found;
        }
        this.getServer().getLogger().log(Level.SEVERE, "Block at {0}, {1}, {2} is {3} but has {4}. Bukkit will attempt to fix this, but there may be additional damage that we cannot recover.", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), type, found});
        if (type.hasTileEntity(state)) {
            TileEntity replacement = type.createTileEntity(state, (IBlockReader)this);
            if (replacement == null) {
                return found;
            }
            replacement.func_226984_a_((World)this, pos);
            this.func_175690_a(pos, replacement);
            return replacement;
        }
        return found;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setDayTime(J)V"))
    private void arclight$timeSkip(ServerWorld world, long time) {
        TimeSkipEvent event = new TimeSkipEvent(this.bridge$getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, time - time % 24000L - this.func_72820_D());
        Bukkit.getPluginManager().callEvent(event);
        this.arclight$timeSkipCancelled = event.isCancelled();
        if (!event.isCancelled()) {
            world.func_241114_a_(this.func_72820_D() + event.getSkipAmount());
            this.field_73068_P = this.field_217491_A.stream().allMatch(LivingEntity::func_70608_bn);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;wakeUpAllPlayers()V"))
    private void arclight$notWakeIfCancelled(ServerWorld world) {
        if (!this.arclight$timeSkipCancelled) {
            this.func_229856_ab_();
        }
        this.arclight$timeSkipCancelled = false;
    }

    @Override
    public ServerWorld bridge$getMinecraftWorld() {
        return (ServerWorld)this;
    }

    @Overwrite
    public static void func_241121_a_(ServerWorld world) {
        BlockPos blockpos = field_241108_a_;
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o() - 2;
        int k = blockpos.func_177952_p();
        BlockStateListPopulator blockList = new BlockStateListPopulator((World)world);
        BlockPos.func_191531_b((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(pos -> blockList.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 3));
        BlockPos.func_191531_b((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(pos -> blockList.func_180501_a((BlockPos)pos, Blocks.field_150343_Z.func_176223_P(), 3));
        CraftWorld bworld = ((WorldBridge)world).bridge$getWorld();
        boolean spawnPortal = ArclightCaptures.getEndPortalSpawn();
        Entity entity = ArclightCaptures.getEndPortalEntity();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), bworld, entity == null ? null : ((EntityBridge)entity).bridge$getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        portalEvent.setCancelled(!spawnPortal);
        Bukkit.getPluginManager().callEvent(portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }
}

