/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import io.izzel.arclight.common.bridge.world.storage.MapDataBridge;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.map.CraftMapView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapData.class})
public abstract class MapDataMixin
implements MapDataBridge {
    @Shadow
    public RegistryKey<World> field_76200_c;
    public CraftMapView mapView;
    private CraftServer server;
    private UUID uniqueId;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$init(String mapname, CallbackInfo ci) {
        this.mapView = new CraftMapView((MapData)this);
        this.server = (CraftServer)Bukkit.getServer();
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Ljava/util/Optional;orElseThrow(Ljava/util/function/Supplier;)Ljava/lang/Object;"))
    public Object arclight$customDimension(Optional<RegistryKey<World>> optional, Supplier<?> exceptionSupplier, CompoundNBT nbt) {
        return optional.orElseGet(() -> {
            long least = nbt.func_74763_f("UUIDLeast");
            long most = nbt.func_74763_f("UUIDMost");
            if (least != 0L && most != 0L) {
                this.uniqueId = new UUID(most, least);
                CraftWorld world = (CraftWorld)this.server.getWorld(this.uniqueId);
                if (world != null) {
                    return world.getHandle().func_234923_W_();
                }
            }
            throw new IllegalArgumentException("Invalid map dimension: " + nbt.func_74781_a("dimension"));
        });
    }

    @Inject(method={"write"}, at={@At(value="HEAD")})
    public void arclight$storeDimension(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().func_234923_W_() != this.field_76200_c) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            compound.func_74772_a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            compound.func_74772_a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
    }

    @Override
    public CraftMapView bridge$getMapView() {
        return this.mapView;
    }
}

