/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import com.mojang.serialization.Lifecycle;
import io.izzel.arclight.common.bridge.world.storage.WorldInfoBridge;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.world.Difficulty;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerWorldInfo.class})
public abstract class ServerWorldInfoMixin
implements WorldInfoBridge {
    @Shadow
    private boolean field_237358_r_;
    @Shadow
    private boolean field_237356_p_;
    @Shadow
    private WorldSettings field_237342_b_;
    @Shadow
    @Final
    private Lifecycle field_237344_d_;
    public ServerWorld world;

    @Shadow
    public abstract String func_76065_j();

    @Shadow
    public abstract boolean func_176123_z();

    @Inject(method={"setThundering"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$thunder(boolean thunderingIn, CallbackInfo ci) {
        if (this.field_237358_r_ == thunderingIn) {
            return;
        }
        World world = Bukkit.getWorld(this.func_76065_j());
        if (world != null) {
            ThunderChangeEvent event = new ThunderChangeEvent(world, thunderingIn);
            Bukkit.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setRaining"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$storm(boolean isRaining, CallbackInfo ci) {
        if (this.field_237356_p_ == isRaining) {
            return;
        }
        World world = Bukkit.getWorld(this.func_76065_j());
        if (world != null) {
            WeatherChangeEvent event = new WeatherChangeEvent(world, isRaining);
            Bukkit.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setDifficulty"}, at={@At(value="RETURN")})
    private void arclight$sendDiffChange(Difficulty newDifficulty, CallbackInfo ci) {
        SServerDifficultyPacket packet = new SServerDifficultyPacket(newDifficulty, this.func_176123_z());
        for (PlayerEntity player : this.world.func_217369_A()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    @Override
    public void bridge$setWorld(ServerWorld world) {
        this.world = world;
    }

    @Override
    public ServerWorld bridge$getWorld() {
        return this.world;
    }

    public void checkName(String name) {
        if (!this.field_237342_b_.field_234943_a_.equals(name)) {
            this.field_237342_b_.field_234943_a_ = name;
        }
    }

    @Override
    public WorldSettings bridge$getWorldSettings() {
        return this.field_237342_b_;
    }

    @Override
    public Lifecycle bridge$getLifecycle() {
        return this.field_237344_d_;
    }
}

