/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.forge;

import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.fml.FMLWorldPersistenceHook;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FMLWorldPersistenceHook.class}, remap=false)
public class FMLWorldPersistenceHookMixin {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private static Marker WORLDPERSISTENCE;
    private final Map<Path, CompoundNBT> map = new HashMap<Path, CompoundNBT>();
    private boolean injected = false;

    @Redirect(method={"readData"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/registries/GameData;injectSnapshot(Ljava/util/Map;ZZ)Lcom/google/common/collect/Multimap;"))
    private Multimap<ResourceLocation, ResourceLocation> arclight$handleInject(Map<ResourceLocation, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld, SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo, CompoundNBT tag) {
        if (!this.injected) {
            this.injected = true;
            return GameData.injectSnapshot(snapshot, (boolean)injectFrozenData, (boolean)isLocalWorld);
        }
        this.map.put(levelSave.getWorldDir(), tag.func_74775_l("Registries").func_74737_b());
        LOGGER.debug(WORLDPERSISTENCE, "Skipped registry injection for {}", (Object)serverInfo.func_76065_j());
        return null;
    }

    @Overwrite
    public CompoundNBT getDataForWriting(SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo) {
        CompoundNBT fmlData = new CompoundNBT();
        ListNBT modList = new ListNBT();
        ModList.get().getMods().forEach(mi -> {
            CompoundNBT mod = new CompoundNBT();
            mod.func_74778_a("ModId", mi.getModId());
            mod.func_74778_a("ModVersion", MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)mi.getVersion()));
            modList.add((Object)mod);
        });
        fmlData.func_218657_a("LoadingModList", (INBT)modList);
        CompoundNBT nbt = this.map.get(levelSave.getWorldDir());
        if (nbt != null) {
            fmlData.func_218657_a("Registries", (INBT)nbt);
            LOGGER.debug(WORLDPERSISTENCE, "Skipped ID Map collection for {}", (Object)serverInfo.func_76065_j());
        } else {
            CompoundNBT registries = new CompoundNBT();
            fmlData.func_218657_a("Registries", (INBT)registries);
            LOGGER.debug(WORLDPERSISTENCE, "Gathering id map for writing to world save {}", (Object)serverInfo.func_76065_j());
            for (Map.Entry e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
                registries.func_218657_a(((ResourceLocation)e.getKey()).toString(), (INBT)((ForgeRegistry.Snapshot)e.getValue()).write());
            }
            LOGGER.debug(WORLDPERSISTENCE, "ID Map collection complete {}", (Object)serverInfo.func_76065_j());
        }
        return fmlData;
    }
}

