/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import io.izzel.arclight.api.Arclight;
import io.izzel.arclight.common.bridge.bukkit.CraftServerBridge;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.server.ArclightPermissionHandler;
import io.izzel.arclight.common.mod.server.BukkitRegistry;
import io.izzel.arclight.common.mod.server.api.DefaultArclightServer;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.command.ColouredConsoleSender;
import org.spigotmc.SpigotConfig;

public class ArclightServer {
    private static final Executor mainThreadExecutor = ArclightServer::executeOnMainThread;
    private static CraftServer server;

    public static CraftServer createOrLoad(DedicatedServer console, PlayerList playerList) {
        if (server == null) {
            Arclight.setServer(new DefaultArclightServer());
            try {
                server = new CraftServer(console, playerList);
                ((MinecraftServerBridge)console).bridge$setServer(server);
                ((MinecraftServerBridge)console).bridge$setConsole(ColouredConsoleSender.getInstance());
                ArclightPermissionHandler.INSTANCE.initialize();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                ArclightMod.LOGGER.info("registry.begin");
                BukkitRegistry.registerAll();
                SpigotConfig.init(new File("./spigot.yml"));
                SpigotConfig.registerCommands();
            }
            catch (Throwable t) {
                ArclightMod.LOGGER.error("registry.error", t);
            }
        } else {
            ((CraftServerBridge)((Object)server)).bridge$setPlayerList(playerList);
        }
        return server;
    }

    public static CraftServer get() {
        return Objects.requireNonNull(server);
    }

    public static boolean isPrimaryThread() {
        if (server == null) {
            return Thread.currentThread().equals(ArclightServer.getMinecraftServer().func_213170_ax());
        }
        return server.isPrimaryThread();
    }

    public static MinecraftServer getMinecraftServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static void executeOnMainThread(Runnable runnable) {
        ((MinecraftServerBridge)ArclightServer.getMinecraftServer()).bridge$queuedProcess(runnable);
        if (LockSupport.getBlocker(ArclightServer.getMinecraftServer().func_213170_ax()) == "waiting for tasks") {
            LockSupport.unpark(ArclightServer.getMinecraftServer().func_213170_ax());
        }
    }

    public static Executor getMainThreadExecutor() {
        return mainThreadExecutor;
    }

    public static World.Environment getEnvironment(RegistryKey<DimensionType> key) {
        return (World.Environment)((Object)BukkitRegistry.DIM_MAP.get(key));
    }

    public static RegistryKey<DimensionType> getDimensionType(World.Environment environment) {
        return (RegistryKey)BukkitRegistry.DIM_MAP.inverse().get((Object)environment);
    }
}

