/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server.event;

import io.izzel.arclight.common.mod.server.event.ArclightEventFactory;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.tools.collection.XmapList;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class EntityEventDispatcher {
    @SubscribeEvent(receiveCanceled=true)
    public void onLivingDeath(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        ArrayList drops = event.getDrops();
        if (!(drops instanceof ArrayList)) {
            drops = new ArrayList(drops);
        }
        XmapList<ItemEntity, ItemStack> itemStackList = XmapList.create(drops, ItemStack.class, entity -> CraftItemStack.asCraftMirror(entity.func_92059_d()), itemStack -> {
            ItemEntity itemEntity = new ItemEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), CraftItemStack.asNMSCopy(itemStack));
            itemEntity.func_174869_p();
            return itemEntity;
        });
        ArclightEventFactory.callEntityDeathEvent(livingEntity, itemStackList);
        if (drops.isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityTame(AnimalTameEvent event) {
        event.setCanceled(CraftEventFactory.callEntityTameEvent((MobEntity)event.getAnimal(), event.getTamer()).isCancelled());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLightningBolt(EntityStruckByLightningEvent event) {
        ArclightCaptures.captureDamageEventEntity((Entity)event.getLightning());
    }
}

