/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util;

import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.mod.ArclightMod;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.bukkit.plugin.Plugin;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PluginEventHandler
extends ASMEventHandler {
    private static final String HANDLER_DESC = Type.getInternalName(IEventListener.class);
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Event.class)});
    private static final MethodHandle MH_GET_LISTENERS;
    private static final MethodHandle MH_ADD_LISTENERS;
    private static final MethodHandle MH_UNIQUE_NAME;
    private final Plugin plugin;

    public PluginEventHandler(Plugin plugin, Object target, Method method, boolean isGeneric) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        super(target, method, isGeneric);
        this.plugin = plugin;
    }

    public static void register(Plugin plugin, EventBus bus, Object target) throws Throwable {
        ConcurrentHashMap listeners = MH_GET_LISTENERS.invokeExact(bus);
        if (!listeners.containsKey(target)) {
            if (target.getClass() == Class.class) {
                PluginEventHandler.registerClass((Class)target, plugin, bus);
            } else {
                PluginEventHandler.registerObject(target, plugin, bus);
            }
        }
    }

    private static void registerClass(Class<?> clazz, Plugin plugin, EventBus bus) {
        Arrays.stream(clazz.getMethods()).filter(m3 -> Modifier.isStatic(m3.getModifiers())).filter(m3 -> m3.isAnnotationPresent(SubscribeEvent.class)).forEach(m3 -> PluginEventHandler.registerListener(clazz, m3, m3, plugin, bus));
    }

    private static Optional<Method> getDeclMethod(Class<?> clz, Method in) {
        try {
            return Optional.of(clz.getDeclaredMethod(in.getName(), in.getParameterTypes()));
        }
        catch (NoSuchMethodException nse) {
            return Optional.empty();
        }
    }

    private static void registerObject(Object obj, Plugin plugin, EventBus bus) {
        HashSet classes = new HashSet();
        PluginEventHandler.typesFor(obj.getClass(), classes);
        Arrays.stream(obj.getClass().getMethods()).filter(m3 -> !Modifier.isStatic(m3.getModifiers())).forEach(m3 -> classes.stream().map(c -> PluginEventHandler.getDeclMethod(c, m3)).filter(rm -> rm.isPresent() && ((Method)rm.get()).isAnnotationPresent(SubscribeEvent.class)).findFirst().ifPresent(rm -> PluginEventHandler.registerListener(obj, m3, (Method)rm.get(), plugin, bus)));
    }

    private static void typesFor(Class<?> clz, Set<Class<?>> visited) {
        if (clz.getSuperclass() == null) {
            return;
        }
        PluginEventHandler.typesFor(clz.getSuperclass(), visited);
        Arrays.stream(clz.getInterfaces()).forEach(i -> PluginEventHandler.typesFor(i, visited));
        visited.add(clz);
    }

    private static void registerListener(Object target, Method method, Method real, Plugin plugin, EventBus bus) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        PluginEventHandler.register(eventType, target, real, plugin, bus);
    }

    private static void register(Class<?> eventType, Object target, Method method, Plugin plugin, EventBus bus) {
        try {
            PluginEventHandler asm = new PluginEventHandler(plugin, target, method, IGenericEvent.class.isAssignableFrom(eventType));
            MH_ADD_LISTENERS.invokeExact(bus, target, eventType, (IEventListener)asm, asm.getPriority());
        }
        catch (Throwable e) {
            ArclightMod.LOGGER.error("Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }

    public Class<?> createWrapper(Method callback) {
        String name;
        ClassWriter cw = new ClassWriter(0);
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        try {
            name = MH_UNIQUE_NAME.invoke(this, callback);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        String desc = name.replace('.', '/');
        String instType = Type.getInternalName(callback.getDeclaringClass());
        String eventType = Type.getInternalName(callback.getParameterTypes()[0]);
        cw.visit(50, 33, desc, null, "java/lang/Object", new String[]{HANDLER_DESC});
        cw.visitSource(".dynamic", null);
        if (!isStatic) {
            cw.visitField(1, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", isStatic ? "()V" : "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (!isStatic) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, desc, "instance", "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (!isStatic) {
            mv.visitFieldInsn(180, desc, "instance", "Ljava/lang/Object;");
            mv.visitTypeInsn(192, instType);
        }
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventType);
        mv.visitMethodInsn(isStatic ? 184 : 182, instType, callback.getName(), Type.getMethodDescriptor((Method)callback), false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        return Unsafe.defineClass(name, bytes, 0, bytes.length, callback.getDeclaringClass().getClassLoader(), callback.getDeclaringClass().getProtectionDomain());
    }

    public String toString() {
        return "PL:" + this.plugin.getName() + " " + super.toString();
    }

    static {
        try {
            MH_GET_LISTENERS = Unsafe.lookup().findGetter(EventBus.class, "listeners", ConcurrentHashMap.class);
            MH_ADD_LISTENERS = Unsafe.lookup().findVirtual(EventBus.class, "addToListeners", MethodType.methodType(Void.TYPE, Object.class, Class.class, IEventListener.class, EventPriority.class));
            MH_UNIQUE_NAME = Unsafe.lookup().findVirtual(ASMEventHandler.class, "getUniqueName", MethodType.methodType(String.class, Method.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

