/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;

public enum CraftStatistic {
    DAMAGE_DEALT(Stats.field_188111_y),
    DAMAGE_TAKEN(Stats.field_188112_z),
    DEATHS(Stats.field_188069_A),
    MOB_KILLS(Stats.field_188070_B),
    PLAYER_KILLS(Stats.field_75932_A),
    FISH_CAUGHT(Stats.field_188071_E),
    ANIMALS_BRED(Stats.field_151186_x),
    LEAVE_GAME(Stats.field_75947_j),
    JUMP(Stats.field_75953_u),
    DROP_COUNT(Stats.field_75952_v),
    DROP(new ResourceLocation("dropped")),
    PICKUP(new ResourceLocation("picked_up")),
    PLAY_ONE_MINUTE(Stats.field_188097_g),
    WALK_ONE_CM(Stats.field_188100_j),
    WALK_ON_WATER_ONE_CM(Stats.field_211755_s),
    FALL_ONE_CM(Stats.field_75943_n),
    SNEAK_TIME(Stats.field_226147_n_),
    CLIMB_ONE_CM(Stats.field_188103_o),
    FLY_ONE_CM(Stats.field_188104_p),
    WALK_UNDER_WATER_ONE_CM(Stats.field_211756_w),
    MINECART_ONE_CM(Stats.field_188106_r),
    BOAT_ONE_CM(Stats.field_188107_s),
    PIG_ONE_CM(Stats.field_188108_t),
    HORSE_ONE_CM(Stats.field_188109_u),
    SPRINT_ONE_CM(Stats.field_188102_l),
    CROUCH_ONE_CM(Stats.field_188101_k),
    AVIATE_ONE_CM(Stats.field_188110_v),
    MINE_BLOCK(new ResourceLocation("mined")),
    USE_ITEM(new ResourceLocation("used")),
    BREAK_ITEM(new ResourceLocation("broken")),
    CRAFT_ITEM(new ResourceLocation("crafted")),
    KILL_ENTITY(new ResourceLocation("killed")),
    ENTITY_KILLED_BY(new ResourceLocation("killed_by")),
    TIME_SINCE_DEATH(Stats.field_188098_h),
    TALKED_TO_VILLAGER(Stats.field_188074_H),
    TRADED_WITH_VILLAGER(Stats.field_188075_I),
    CAKE_SLICES_EATEN(Stats.field_188076_J),
    CAULDRON_FILLED(Stats.field_188077_K),
    CAULDRON_USED(Stats.field_188078_L),
    ARMOR_CLEANED(Stats.field_188079_M),
    BANNER_CLEANED(Stats.field_188080_N),
    BREWINGSTAND_INTERACTION(Stats.field_188081_O),
    BEACON_INTERACTION(Stats.field_188082_P),
    DROPPER_INSPECTED(Stats.field_188083_Q),
    HOPPER_INSPECTED(Stats.field_188084_R),
    DISPENSER_INSPECTED(Stats.field_188085_S),
    NOTEBLOCK_PLAYED(Stats.field_188086_T),
    NOTEBLOCK_TUNED(Stats.field_188087_U),
    FLOWER_POTTED(Stats.field_188088_V),
    TRAPPED_CHEST_TRIGGERED(Stats.field_188089_W),
    ENDERCHEST_OPENED(Stats.field_188090_X),
    ITEM_ENCHANTED(Stats.field_188091_Y),
    RECORD_PLAYED(Stats.field_188092_Z),
    FURNACE_INTERACTION(Stats.field_188061_aa),
    CRAFTING_TABLE_INTERACTION(Stats.field_188062_ab),
    CHEST_OPENED(Stats.field_188063_ac),
    SLEEP_IN_BED(Stats.field_188064_ad),
    SHULKER_BOX_OPENED(Stats.field_191272_ae),
    TIME_SINCE_REST(Stats.field_203284_n),
    SWIM_ONE_CM(Stats.field_75946_m),
    DAMAGE_DEALT_ABSORBED(Stats.field_212735_F),
    DAMAGE_DEALT_RESISTED(Stats.field_212736_G),
    DAMAGE_BLOCKED_BY_SHIELD(Stats.field_212737_I),
    DAMAGE_ABSORBED(Stats.field_212738_J),
    DAMAGE_RESISTED(Stats.field_212739_K),
    CLEAN_SHULKER_BOX(Stats.field_212740_X),
    OPEN_BARREL(Stats.field_219732_ap),
    INTERACT_WITH_BLAST_FURNACE(Stats.field_219733_aq),
    INTERACT_WITH_SMOKER(Stats.field_219734_ar),
    INTERACT_WITH_LECTERN(Stats.field_219735_as),
    INTERACT_WITH_CAMPFIRE(Stats.field_219736_at),
    INTERACT_WITH_CARTOGRAPHY_TABLE(Stats.field_219737_au),
    INTERACT_WITH_LOOM(Stats.field_219738_av),
    INTERACT_WITH_STONECUTTER(Stats.field_219739_aw),
    BELL_RING(Stats.field_219740_ax),
    RAID_TRIGGER(Stats.field_219741_ay),
    RAID_WIN(Stats.field_219742_az),
    INTERACT_WITH_ANVIL(Stats.field_226145_aA_),
    INTERACT_WITH_GRINDSTONE(Stats.field_226146_aB_),
    TARGET_HIT(Stats.field_232863_aD_),
    INTERACT_WITH_SMITHING_TABLE(Stats.field_232864_aE_),
    STRIDER_ONE_CM(Stats.field_232862_C_);

    private final ResourceLocation minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<ResourceLocation, Statistic> statistics;

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        CraftStatistic[] craftStatisticArray = CraftStatistic.values();
        int n = craftStatisticArray.length;
        int n2 = 0;
        while (n2 < n) {
            CraftStatistic statistic = craftStatisticArray[n2];
            statisticBuilder.put(statistic.minecraftKey, statistic.bukkit);
            ++n2;
        }
        statistics = statisticBuilder.build();
    }

    private CraftStatistic(ResourceLocation minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf(this.name());
        Preconditions.checkState(this.bukkit != null, "Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(Stat<?> statistic) {
        Registry statRegistry = statistic.func_197921_a().func_199080_a();
        ResourceLocation nmsKey = Registry.field_212634_w.func_177774_c((Object)statistic.func_197921_a());
        if (statRegistry == Registry.field_212623_l) {
            nmsKey = (ResourceLocation)statistic.func_197920_b();
        }
        return (Statistic)statistics.get(nmsKey);
    }

    public static Stat getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument(bukkit.getType() == Statistic.Type.UNTYPED, "This method only accepts untyped statistics");
        Stat nms = Stats.field_199092_j.func_199076_b((Object)((ResourceLocation)statistics.inverse().get(bukkit)));
        Preconditions.checkArgument(nms != null, "NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static Stat getMaterialStatistic(Statistic stat, Material material) {
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return Stats.field_188065_ae.func_199076_b((Object)CraftMagicNumbers.getBlock(material));
            }
            if (stat == Statistic.CRAFT_ITEM) {
                return Stats.field_188066_af.func_199076_b((Object)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.USE_ITEM) {
                return Stats.field_75929_E.func_199076_b((Object)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.BREAK_ITEM) {
                return Stats.field_199088_e.func_199076_b((Object)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.PICKUP) {
                return Stats.field_199089_f.func_199076_b((Object)CraftMagicNumbers.getItem(material));
            }
            if (stat == Statistic.DROP) {
                return Stats.field_188068_aj.func_199076_b((Object)CraftMagicNumbers.getItem(material));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    public static Stat getEntityStatistic(Statistic stat, org.bukkit.entity.EntityType entity) {
        if (entity.getName() != null) {
            EntityType nmsEntity = (EntityType)Registry.field_212629_r.func_82594_a(new ResourceLocation(entity.getName()));
            if (stat == Statistic.KILL_ENTITY) {
                return Stats.field_199090_h.func_199076_b((Object)nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return Stats.field_199091_i.func_199076_b((Object)nmsEntity);
            }
        }
        return null;
    }

    public static org.bukkit.entity.EntityType getEntityTypeFromStatistic(Stat<EntityType<?>> statistic) {
        ResourceLocation name = EntityType.func_200718_a((EntityType)((EntityType)statistic.func_197920_b()));
        return org.bukkit.entity.EntityType.fromName(name.func_110623_a());
    }

    public static Material getMaterialFromStatistic(Stat<?> statistic) {
        if (statistic.func_197920_b() instanceof Item) {
            return CraftMagicNumbers.getMaterial((Item)statistic.func_197920_b());
        }
        if (statistic.func_197920_b() instanceof Block) {
            return CraftMagicNumbers.getMaterial((Block)statistic.func_197920_b());
        }
        return null;
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic) {
        CraftStatistic.incrementStatistic(manager, statistic, 1);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic) {
        CraftStatistic.decrementStatistic(manager, statistic, 1);
    }

    public static int getStatistic(ServerStatisticsManager manager, Statistic statistic) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        return manager.func_77444_a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount);
    }

    public static void setStatistic(ServerStatisticsManager manager, Statistic statistic, int newValue) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Stat nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.func_150873_a(null, nmsStatistic, newValue);
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1);
    }

    public static int getStatistic(ServerStatisticsManager manager, Statistic statistic, Material material) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.notNull((Object)material, (String)"Material cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        Stat nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        return manager.func_77444_a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount);
    }

    public static void setStatistic(ServerStatisticsManager manager, Statistic statistic, Material material, int newValue) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.notNull((Object)material, (String)"Material cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        Stat nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        manager.func_150873_a(null, nmsStatistic, newValue);
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1);
    }

    public static int getStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.notNull((Object)entityType, (String)"EntityType cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        Stat nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        return manager.func_77444_a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount);
    }

    public static void decrementStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount);
    }

    public static void setStatistic(ServerStatisticsManager manager, Statistic statistic, org.bukkit.entity.EntityType entityType, int newValue) {
        Validate.notNull((Object)statistic, (String)"Statistic cannot be null");
        Validate.notNull((Object)entityType, (String)"EntityType cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        Stat nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        manager.func_150873_a(null, nmsStatistic, newValue);
    }
}

