/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerTileEntity;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;

public class CraftBanner
extends CraftBlockEntityState<BannerTileEntity>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(Block block) {
        super(block, BannerTileEntity.class);
    }

    public CraftBanner(Material material, BannerTileEntity te) {
        super(material, te);
    }

    @Override
    public void load(BannerTileEntity banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((AbstractBannerBlock)this.data.func_177230_c()).func_196285_M_().func_196059_a());
        this.patterns = new ArrayList<Pattern>();
        if (banner.field_175118_f != null) {
            int i = 0;
            while (i < banner.field_175118_f.size()) {
                CompoundNBT p = (CompoundNBT)banner.field_175118_f.get(i);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)p.func_74762_e("Color")), PatternType.getByIdentifier(p.func_74779_i("Pattern"))));
                ++i;
            }
        }
    }

    @Override
    public DyeColor getBaseColor() {
        return this.base;
    }

    @Override
    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument(color != null, "color");
        this.base = color;
    }

    @Override
    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    @Override
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    @Override
    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    @Override
    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    @Override
    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    @Override
    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(BannerTileEntity banner) {
        super.applyTo(banner);
        banner.field_175120_a = net.minecraft.item.DyeColor.func_196056_a((int)this.base.getWoolData());
        ListNBT newPatterns = new ListNBT();
        for (Pattern p : this.patterns) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("Color", (int)p.getColor().getWoolData());
            compound.func_74778_a("Pattern", p.getPattern().getIdentifier());
            newPatterns.add((Object)compound);
        }
        banner.field_175118_f = newPatterns;
    }
}

