/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBanner;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBarrel;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBed;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBeehive;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBell;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftCampfire;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftChest;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftComparator;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftConduit;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftDropper;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftEnderChest;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftHopper;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftJigsaw;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftLectern;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSmoker;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftStructureBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftRayTraceResult;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftBlock
implements Block {
    private final IWorld world;
    private final BlockPos position;

    public CraftBlock(IWorld world, BlockPos position) {
        this.world = world;
        this.position = position.func_185334_h();
    }

    public static CraftBlock at(IWorld world, BlockPos position) {
        return new CraftBlock(world, position);
    }

    private net.minecraft.block.Block getNMSBlock() {
        return this.getNMS().func_177230_c();
    }

    public net.minecraft.block.BlockState getNMS() {
        return this.world.func_180495_p(this.position);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public World getWorld() {
        return this.world.getMinecraftWorld().getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.position.func_177958_n(), this.position.func_177956_o(), this.position.func_177952_p());
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.position.func_177958_n());
            loc.setY(this.position.func_177956_o());
            loc.setZ(this.position.func_177952_p());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int getX() {
        return this.position.func_177958_n();
    }

    @Override
    public int getY() {
        return this.position.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.position.func_177952_p();
    }

    @Override
    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this);
    }

    public void setData(byte data) {
        this.setData(data, 3);
    }

    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.setData(data, 3);
        } else {
            this.setData(data, 2);
        }
    }

    private void setData(byte data, int flag) {
        this.world.func_180501_a(this.position, CraftMagicNumbers.getBlock(this.getType(), data), flag);
    }

    @Override
    public byte getData() {
        net.minecraft.block.BlockState blockData = this.world.func_180495_p(this.position);
        return CraftMagicNumbers.toLegacyData(blockData);
    }

    @Override
    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getNMS());
    }

    @Override
    public void setType(Material type) {
        this.setType(type, true);
    }

    @Override
    public void setType(Material type, boolean applyPhysics) {
        Preconditions.checkArgument(type != null, "Material cannot be null");
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    @Override
    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    @Override
    public void setBlockData(BlockData data, boolean applyPhysics) {
        Preconditions.checkArgument(data != null, "BlockData cannot be null");
        this.setTypeAndData(((CraftBlockData)data).getState(), applyPhysics);
    }

    public boolean setTypeAndData(net.minecraft.block.BlockState blockData, boolean applyPhysics) {
        if (!blockData.func_196958_f() && blockData.func_177230_c() instanceof ContainerBlock && blockData.func_177230_c() != this.getNMSBlock()) {
            if (this.world instanceof net.minecraft.world.World) {
                ((net.minecraft.world.World)this.world).func_175713_t(this.position);
            } else {
                this.world.func_180501_a(this.position, Blocks.field_150350_a.func_176223_P(), 0);
            }
        }
        if (applyPhysics) {
            return this.world.func_180501_a(this.position, blockData, 3);
        }
        net.minecraft.block.BlockState old = this.world.func_180495_p(this.position);
        boolean success = this.world.func_180501_a(this.position, blockData, 1042);
        if (success) {
            this.world.getMinecraftWorld().func_184138_a(this.position, old, blockData, 3);
        }
        return success;
    }

    @Override
    public Material getType() {
        return CraftMagicNumbers.getMaterial(this.world.func_180495_p(this.position).func_177230_c());
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.world.getMinecraftWorld().func_201696_r(this.position);
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.world.func_226658_a_(LightType.SKY, this.position);
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.world.func_226658_a_(LightType.BLOCK, this.position);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        BlockFace[] blockFaceArray = values = BlockFace.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            if (this.getX() + face.getModX() == block.getX() && this.getY() + face.getModY() == block.getY() && this.getZ() + face.getModZ() == block.getZ()) {
                return face;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{pos=" + this.position + ",type=" + this.getType() + ",data=" + this.getNMS() + ",fluid=" + this.world.func_204610_c(this.position) + '}';
    }

    public static BlockFace notchToBlockFace(Direction notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        switch (notch) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static Direction blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return Direction.DOWN;
            }
            case UP: {
                return Direction.UP;
            }
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
        }
        return null;
    }

    @Override
    public BlockState getState() {
        Material material = this.getType();
        switch (material) {
            case OAK_SIGN: 
            case SPRUCE_SIGN: 
            case BIRCH_SIGN: 
            case JUNGLE_SIGN: 
            case ACACIA_SIGN: 
            case DARK_OAK_SIGN: 
            case CRIMSON_SIGN: 
            case WARPED_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case BIRCH_WALL_SIGN: 
            case ACACIA_WALL_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case CRIMSON_WALL_SIGN: 
            case WARPED_WALL_SIGN: {
                return new CraftSign(this);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new CraftChest(this);
            }
            case FURNACE: {
                return new CraftFurnaceFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case DROPPER: {
                return new CraftDropper(this);
            }
            case END_GATEWAY: {
                return new CraftEndGateway(this);
            }
            case HOPPER: {
                return new CraftHopper(this);
            }
            case SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKELETON_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case PLAYER_HEAD: 
            case ZOMBIE_HEAD: 
            case CREEPER_HEAD: 
            case DRAGON_HEAD: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_WALL_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_WALL_HEAD: {
                return new CraftSkull(this);
            }
            case COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: {
                return new CraftCommandBlock(this);
            }
            case BEACON: {
                return new CraftBeacon(this);
            }
            case WHITE_BANNER: 
            case ORANGE_BANNER: 
            case MAGENTA_BANNER: 
            case LIGHT_BLUE_BANNER: 
            case YELLOW_BANNER: 
            case LIME_BANNER: 
            case PINK_BANNER: 
            case GRAY_BANNER: 
            case LIGHT_GRAY_BANNER: 
            case CYAN_BANNER: 
            case PURPLE_BANNER: 
            case BLUE_BANNER: 
            case BROWN_BANNER: 
            case GREEN_BANNER: 
            case RED_BANNER: 
            case BLACK_BANNER: 
            case WHITE_WALL_BANNER: 
            case ORANGE_WALL_BANNER: 
            case MAGENTA_WALL_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: 
            case YELLOW_WALL_BANNER: 
            case LIME_WALL_BANNER: 
            case PINK_WALL_BANNER: 
            case GRAY_WALL_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: 
            case CYAN_WALL_BANNER: 
            case PURPLE_WALL_BANNER: 
            case BLUE_WALL_BANNER: 
            case BROWN_WALL_BANNER: 
            case GREEN_WALL_BANNER: 
            case RED_WALL_BANNER: 
            case BLACK_WALL_BANNER: {
                return new CraftBanner(this);
            }
            case STRUCTURE_BLOCK: {
                return new CraftStructureBlock(this);
            }
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                return new CraftShulkerBox(this);
            }
            case ENCHANTING_TABLE: {
                return new CraftEnchantingTable(this);
            }
            case ENDER_CHEST: {
                return new CraftEnderChest(this);
            }
            case DAYLIGHT_DETECTOR: {
                return new CraftDaylightDetector(this);
            }
            case COMPARATOR: {
                return new CraftComparator(this);
            }
            case WHITE_BED: 
            case ORANGE_BED: 
            case MAGENTA_BED: 
            case LIGHT_BLUE_BED: 
            case YELLOW_BED: 
            case LIME_BED: 
            case PINK_BED: 
            case GRAY_BED: 
            case LIGHT_GRAY_BED: 
            case CYAN_BED: 
            case PURPLE_BED: 
            case BLUE_BED: 
            case BROWN_BED: 
            case GREEN_BED: 
            case RED_BED: 
            case BLACK_BED: {
                return new CraftBed(this);
            }
            case CONDUIT: {
                return new CraftConduit(this);
            }
            case BARREL: {
                return new CraftBarrel(this);
            }
            case BELL: {
                return new CraftBell(this);
            }
            case BLAST_FURNACE: {
                return new CraftBlastFurnace(this);
            }
            case CAMPFIRE: 
            case SOUL_CAMPFIRE: {
                return new CraftCampfire(this);
            }
            case JIGSAW: {
                return new CraftJigsaw(this);
            }
            case LECTERN: {
                return new CraftLectern(this);
            }
            case SMOKER: {
                return new CraftSmoker(this);
            }
            case BEE_NEST: 
            case BEEHIVE: {
                return new CraftBeehive(this);
            }
        }
        TileEntity tileEntity = this.world.func_175625_s(this.position);
        if (tileEntity != null) {
            return new CraftBlockEntityState((Block)this, tileEntity.getClass());
        }
        return new CraftBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.getX(), this.getY(), this.getZ(), bio);
    }

    public static Biome biomeBaseToBiome(net.minecraft.util.registry.Registry<net.minecraft.world.biome.Biome> registry, net.minecraft.world.biome.Biome base) {
        if (base == null) {
            return null;
        }
        Biome biome = Registry.BIOME.get(CraftNamespacedKey.fromMinecraft(registry.func_177774_c((Object)base)));
        return biome == null ? Biome.CUSTOM : biome;
    }

    public static net.minecraft.world.biome.Biome biomeToBiomeBase(net.minecraft.util.registry.Registry<net.minecraft.world.biome.Biome> registry, Biome bio) {
        if (bio == null || bio == Biome.CUSTOM) {
            return null;
        }
        return (net.minecraft.world.biome.Biome)registry.func_82594_a(CraftNamespacedKey.toMinecraft(bio.getKey()));
    }

    @Override
    public double getTemperature() {
        return this.world.func_226691_t_(this.position).func_225486_c(this.position);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isBlockPowered() {
        return this.world.getMinecraftWorld().func_175676_y(this.position) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.world.getMinecraftWorld().func_175640_z(this.position);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.position.equals((Object)other.position) && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.position.hashCode() ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.world.getMinecraftWorld().func_175709_b(this.position, CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.world.getMinecraftWorld().func_175651_c(this.position, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        ServerWorld world = this.world.getMinecraftWorld();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x, y - 1, z), Direction.DOWN)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x, y - 1, z)));
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x, y + 1, z), Direction.UP)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x, y + 1, z)));
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x + 1, y, z), Direction.EAST)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x + 1, y, z)));
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x - 1, y, z), Direction.WEST)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x - 1, y, z)));
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x, y, z - 1), Direction.NORTH)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x, y, z - 1)));
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.func_175709_b(new BlockPos(x, y, z + 1), Direction.SOUTH)) {
            power = CraftBlock.getPower(power, world.func_180495_p(new BlockPos(x, y, z + 1)));
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    private static int getPower(int i, net.minecraft.block.BlockState iblockdata) {
        if (!iblockdata.func_177230_c().func_235332_a_(Blocks.field_150488_af)) {
            return i;
        }
        int j = (Integer)iblockdata.func_177229_b((Property)RedstoneWireBlock.field_176351_O);
        return j > i ? j : i;
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        return this.getNMS().func_196958_f();
    }

    @Override
    public boolean isLiquid() {
        return this.getNMS().func_185904_a().func_76224_d();
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getNMS().func_185905_o().ordinal());
    }

    @Override
    public boolean breakNaturally() {
        return this.breakNaturally(null);
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        net.minecraft.block.BlockState iblockdata = this.getNMS();
        net.minecraft.block.Block block = iblockdata.func_177230_c();
        net.minecraft.item.ItemStack nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != Blocks.field_150350_a && (item == null || !iblockdata.func_235783_q_() || nmsItem.func_150998_b(iblockdata))) {
            net.minecraft.block.Block.func_220054_a((net.minecraft.block.BlockState)iblockdata, (net.minecraft.world.World)this.world.getMinecraftWorld(), (BlockPos)this.position, (TileEntity)this.world.func_175625_s(this.position), null, (net.minecraft.item.ItemStack)nmsItem);
            result = true;
        }
        return this.setTypeAndData(Blocks.field_150350_a.func_176223_P(), true) && result;
    }

    @Override
    public boolean applyBoneMeal(BlockFace face) {
        Direction direction = CraftBlock.blockFaceToNotch(face);
        ItemUseContext context = new ItemUseContext((net.minecraft.world.World)this.getCraftWorld().getHandle(), null, Hand.MAIN_HAND, Items.field_196106_bc.func_190903_i(), new BlockRayTraceResult(Vector3d.field_186680_a, direction, this.getPosition(), false));
        return BoneMealItem.applyBonemeal((ItemUseContext)context) == ActionResultType.SUCCESS;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return this.getDrops(null);
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        return this.getDrops(item, null);
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item, Entity entity) {
        net.minecraft.block.BlockState iblockdata = this.getNMS();
        net.minecraft.item.ItemStack nms = CraftItemStack.asNMSCopy(item);
        if (item == null || this.isPreferredTool(iblockdata, nms)) {
            return net.minecraft.block.Block.func_220077_a((net.minecraft.block.BlockState)iblockdata, (ServerWorld)this.world.getMinecraftWorld(), (BlockPos)this.position, (TileEntity)this.world.func_175625_s(this.position), (net.minecraft.entity.Entity)(entity == null ? null : ((CraftEntity)entity).getHandle()), (net.minecraft.item.ItemStack)nms).stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPreferredTool(ItemStack item) {
        net.minecraft.block.BlockState iblockdata = this.getNMS();
        net.minecraft.item.ItemStack nms = CraftItemStack.asNMSCopy(item);
        return this.isPreferredTool(iblockdata, nms);
    }

    private boolean isPreferredTool(net.minecraft.block.BlockState iblockdata, net.minecraft.item.ItemStack nmsItem) {
        return !iblockdata.func_235783_q_() || nmsItem.func_150998_b(iblockdata);
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isPassable() {
        return this.getNMS().func_196952_d((IBlockReader)this.world, this.position).func_197766_b();
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        Validate.isTrue((boolean)this.getWorld().equals(start.getWorld()), (String)"Start location is from different world!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        Validate.notNull((Object)((Object)fluidCollisionMode), (String)"Fluid collision mode is null!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vector3d startPos = new Vector3d(start.getX(), start.getY(), start.getZ());
        Vector3d endPos = new Vector3d(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        BlockRayTraceResult nmsHitResult = this.world.rayTraceBlock(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.OUTLINE, CraftFluidCollisionMode.toNMS(fluidCollisionMode), null), this.position);
        return CraftRayTraceResult.fromNMS(this.getWorld(), (net.minecraft.util.math.RayTraceResult)nmsHitResult);
    }

    @Override
    public BoundingBox getBoundingBox() {
        VoxelShape shape = this.getNMS().func_196954_c((IBlockReader)this.world, this.position);
        if (shape.func_197766_b()) {
            return new BoundingBox();
        }
        AxisAlignedBB aabb = shape.func_197752_a();
        return new BoundingBox((double)this.getX() + aabb.field_72340_a, (double)this.getY() + aabb.field_72338_b, (double)this.getZ() + aabb.field_72339_c, (double)this.getX() + aabb.field_72336_d, (double)this.getY() + aabb.field_72337_e, (double)this.getZ() + aabb.field_72334_f);
    }
}

