/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import com.google.common.base.Preconditions;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<StructureBlockTileEntity>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(Block block) {
        super(block, StructureBlockTileEntity.class);
    }

    public CraftStructureBlock(Material material, StructureBlockTileEntity structure) {
        super(material, structure);
    }

    @Override
    public String getStructureName() {
        return ((StructureBlockTileEntity)this.getSnapshot()).func_189715_d();
    }

    @Override
    public void setStructureName(String name) {
        Preconditions.checkArgument(name != null, "Structure Name cannot be null");
        ((StructureBlockTileEntity)this.getSnapshot()).func_184404_a(name);
    }

    @Override
    public String getAuthor() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_184421_f;
    }

    @Override
    public void setAuthor(String author) {
        Preconditions.checkArgument(author != null && !author.isEmpty(), "Author name cannot be null nor empty");
        ((StructureBlockTileEntity)this.getSnapshot()).field_184421_f = author;
    }

    @Override
    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument(entity != null, "Structure Block author entity cannot be null");
        ((StructureBlockTileEntity)this.getSnapshot()).func_189720_a(((CraftLivingEntity)entity).getHandle());
    }

    @Override
    public BlockVector getRelativePosition() {
        return new BlockVector(((StructureBlockTileEntity)this.getSnapshot()).field_184423_h.func_177958_n(), ((StructureBlockTileEntity)this.getSnapshot()).field_184423_h.func_177956_o(), ((StructureBlockTileEntity)this.getSnapshot()).field_184423_h.func_177952_p());
    }

    @Override
    public void setRelativePosition(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -48 and 48", (Object[])new Object[0]);
        ((StructureBlockTileEntity)this.getSnapshot()).field_184423_h = new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Override
    public BlockVector getStructureSize() {
        return new BlockVector(((StructureBlockTileEntity)this.getSnapshot()).field_184424_i.func_177958_n(), ((StructureBlockTileEntity)this.getSnapshot()).field_184424_i.func_177956_o(), ((StructureBlockTileEntity)this.getSnapshot()).field_184424_i.func_177952_p());
    }

    @Override
    public void setStructureSize(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between 0 and 48", (Object[])new Object[0]);
        ((StructureBlockTileEntity)this.getSnapshot()).field_184424_i = new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Override
    public void setMirror(org.bukkit.block.structure.Mirror mirror) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_184425_j = Mirror.valueOf((String)mirror.name());
    }

    @Override
    public org.bukkit.block.structure.Mirror getMirror() {
        return org.bukkit.block.structure.Mirror.valueOf(((StructureBlockTileEntity)this.getSnapshot()).field_184425_j.name());
    }

    @Override
    public void setRotation(StructureRotation rotation) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_184426_k = Rotation.valueOf((String)rotation.name());
    }

    @Override
    public StructureRotation getRotation() {
        return StructureRotation.valueOf(((StructureBlockTileEntity)this.getSnapshot()).field_184426_k.name());
    }

    @Override
    public void setUsageMode(UsageMode mode) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_184427_l = StructureMode.valueOf((String)mode.name());
    }

    @Override
    public UsageMode getUsageMode() {
        return UsageMode.valueOf(((StructureBlockTileEntity)this.getSnapshot()).func_189700_k().name());
    }

    @Override
    public void setIgnoreEntities(boolean flag) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_184428_m = flag;
    }

    @Override
    public boolean isIgnoreEntities() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_184428_m;
    }

    @Override
    public void setShowAir(boolean showAir) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_189728_o = showAir;
    }

    @Override
    public boolean isShowAir() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_189728_o;
    }

    @Override
    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_189729_p = showBoundingBox;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_189729_p;
    }

    @Override
    public void setIntegrity(float integrity) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f", (Object[])new Object[0]);
        ((StructureBlockTileEntity)this.getSnapshot()).field_189730_q = integrity;
    }

    @Override
    public float getIntegrity() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_189730_q;
    }

    @Override
    public void setSeed(long seed) {
        ((StructureBlockTileEntity)this.getSnapshot()).field_189731_r = seed;
    }

    @Override
    public long getSeed() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_189731_r;
    }

    @Override
    public void setMetadata(String metadata) {
        Validate.notNull((Object)metadata, (String)"Structure metadata cannot be null", (Object[])new Object[0]);
        if (this.getUsageMode() == UsageMode.DATA) {
            ((StructureBlockTileEntity)this.getSnapshot()).field_184422_g = metadata;
        }
    }

    @Override
    public String getMetadata() {
        return ((StructureBlockTileEntity)this.getSnapshot()).field_184422_g;
    }

    @Override
    protected void applyTo(StructureBlockTileEntity tileEntity) {
        super.applyTo(tileEntity);
        tileEntity.func_184405_a(tileEntity.func_189700_k());
    }

    private static boolean isBetween(int num, int min2, int max) {
        return num >= min2 && num <= max;
    }

    private static boolean isBetween(float num, float min2, float max) {
        return num >= min2 && num <= max;
    }
}

