/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_16_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, AreaEffectCloudEntity entity) {
        super(server, (Entity)entity);
    }

    public AreaEffectCloudEntity getHandle() {
        return (AreaEffectCloudEntity)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    @Override
    public EntityType getType() {
        return EntityType.AREA_EFFECT_CLOUD;
    }

    @Override
    public int getDuration() {
        return this.getHandle().func_184489_o();
    }

    @Override
    public void setDuration(int duration) {
        this.getHandle().func_184486_b(duration);
    }

    @Override
    public int getWaitTime() {
        return this.getHandle().field_184506_as;
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.getHandle().func_184485_d(waitTime);
    }

    @Override
    public int getReapplicationDelay() {
        return this.getHandle().field_184507_at;
    }

    @Override
    public void setReapplicationDelay(int delay) {
        this.getHandle().field_184507_at = delay;
    }

    @Override
    public int getDurationOnUse() {
        return this.getHandle().field_184509_av;
    }

    @Override
    public void setDurationOnUse(int duration) {
        this.getHandle().field_184509_av = duration;
    }

    @Override
    public float getRadius() {
        return this.getHandle().func_184490_j();
    }

    @Override
    public void setRadius(float radius) {
        this.getHandle().func_184483_a(radius);
    }

    @Override
    public float getRadiusOnUse() {
        return this.getHandle().field_184510_aw;
    }

    @Override
    public void setRadiusOnUse(float radius) {
        this.getHandle().func_184495_b(radius);
    }

    @Override
    public float getRadiusPerTick() {
        return this.getHandle().field_184511_ax;
    }

    @Override
    public void setRadiusPerTick(float radius) {
        this.getHandle().func_184487_c(radius);
    }

    @Override
    public Particle getParticle() {
        return CraftParticle.toBukkit(this.getHandle().func_195058_l());
    }

    @Override
    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    @Override
    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().func_195059_a(CraftParticle.toNMS(particle, data));
    }

    @Override
    public Color getColor() {
        return Color.fromRGB(this.getHandle().func_184492_k());
    }

    @Override
    public void setColor(Color color) {
        this.getHandle().func_184482_a(color.asRGB());
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        int effectId = effect.getType().getId();
        EffectInstance existing = null;
        for (EffectInstance mobEffect : this.getHandle().field_184503_f) {
            if (Effect.func_188409_a((Effect)mobEffect.func_188419_a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().field_184503_f.remove(existing);
        }
        this.getHandle().func_184496_a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        this.getHandle().field_184503_f.clear();
        this.getHandle().refreshEffects();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EffectInstance effect : this.getHandle().field_184503_f) {
            builder.add(CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (EffectInstance effect : this.getHandle().field_184503_f) {
            if (!CraftPotionUtil.equals(effect.func_188419_a(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().field_184503_f.isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        int effectId = effect.getId();
        EffectInstance existing = null;
        for (EffectInstance mobEffect : this.getHandle().field_184503_f) {
            if (Effect.func_188409_a((Effect)mobEffect.func_188419_a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().field_184503_f.remove(existing);
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        Validate.notNull((Object)data, (String)"PotionData cannot be null");
        this.getHandle().setType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getHandle().getType());
    }

    @Override
    public ProjectileSource getSource() {
        LivingEntity source = this.getHandle().func_184494_w();
        return source == null ? null : (org.bukkit.entity.LivingEntity)((Object)source.getBukkitEntity());
    }

    @Override
    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            this.getHandle().func_184481_a(((CraftLivingEntity)shooter).getHandle());
        } else {
            this.getHandle().func_184481_a(null);
        }
    }
}

