/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftTippedArrow
extends CraftArrow
implements Arrow {
    public CraftTippedArrow(CraftServer server, ArrowEntity entity) {
        super(server, (AbstractArrowEntity)entity);
    }

    public ArrowEntity getHandle() {
        return (ArrowEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    @Override
    public EntityType getType() {
        return EntityType.ARROW;
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        int effectId = effect.getType().getId();
        EffectInstance existing = null;
        for (EffectInstance mobEffect : this.getHandle().field_184561_h) {
            if (Effect.func_188409_a((Effect)mobEffect.func_188419_a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().field_184561_h.remove(existing);
        }
        this.getHandle().func_184558_a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        this.getHandle().field_184561_h.clear();
        this.getHandle().refreshEffects();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EffectInstance effect : this.getHandle().field_184561_h) {
            builder.add(CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (EffectInstance effect : this.getHandle().field_184561_h) {
            if (!CraftPotionUtil.equals(effect.func_188419_a(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().field_184561_h.isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        int effectId = effect.getId();
        EffectInstance existing = null;
        for (EffectInstance mobEffect : this.getHandle().field_184561_h) {
            if (Effect.func_188409_a((Effect)mobEffect.func_188419_a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().field_184561_h.remove(existing);
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        Validate.notNull((Object)data, (String)"PotionData cannot be null");
        this.getHandle().setType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getHandle().getType());
    }

    @Override
    public void setColor(Color color) {
        this.getHandle().func_191507_d(color.asRGB());
    }

    @Override
    public Color getColor() {
        return Color.fromRGB(this.getHandle().func_184557_n());
    }
}

