/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.event;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.stats.Stat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_16_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_16_R3.CraftRaid;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftStatistic;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftDamageSource;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.potion.PotionEffect;

public class CraftEventFactory {
    public static final DamageSource MELTING = CraftDamageSource.copyOf(DamageSource.field_76370_b);
    public static final DamageSource POISON = CraftDamageSource.copyOf(DamageSource.field_76376_m);
    public static Block blockDamage;
    public static net.minecraft.entity.Entity entityDamage;
    private static final com.google.common.base.Function<? super Double, Double> ZERO;

    static {
        ZERO = Functions.constant(-0.0);
    }

    private static boolean canBuild(ServerWorld world, Player player, int x, int z) {
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.func_234923_W_() != net.minecraft.world.World.field_234918_g_) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().func_152603_m().func_152690_d()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        BlockPos chunkcoordinates = world.func_241135_u_();
        int distanceFromSpawn = Math.max(Math.abs(x - chunkcoordinates.func_177958_n()), Math.abs(z - chunkcoordinates.func_177952_p()));
        return distanceFromSpawn > spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static Either<PlayerEntity.SleepResult, Unit> callPlayerBedEnterEvent(PlayerEntity player, BlockPos bed, Either<PlayerEntity.SleepResult, Unit> nmsBedResult) {
        PlayerBedEnterEvent.BedEnterResult bedEnterResult = (PlayerBedEnterEvent.BedEnterResult)((Object)nmsBedResult.mapBoth((Function)new com.google.common.base.Function<PlayerEntity.SleepResult, PlayerBedEnterEvent.BedEnterResult>(){

            @Override
            public PlayerBedEnterEvent.BedEnterResult apply(PlayerEntity.SleepResult t) {
                switch (t) {
                    case NOT_POSSIBLE_HERE: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
                    }
                    case NOT_POSSIBLE_NOW: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
                    }
                    case TOO_FAR_AWAY: {
                        return PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
                    }
                    case NOT_SAFE: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
                    }
                }
                return PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
            }
        }, t -> PlayerBedEnterEvent.BedEnterResult.OK).map(Function.identity(), Function.identity()));
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((Player)((Object)player.getBukkitEntity()), CraftBlock.at((IWorld)player.field_70170_p, bed), bedEnterResult);
        Bukkit.getServer().getPluginManager().callEvent(event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right((Object)Unit.INSTANCE);
        }
        if (result == Event.Result.DENY) {
            return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(PlayerEntity entityHuman, AnimalEntity entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)((Object)entityAnimal.getBukkitEntity()), entityHuman != null ? entityHuman.getBukkitEntity() : null, loveTicks);
        Bukkit.getPluginManager().callEvent(entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(net.minecraft.world.World world, BlockPos blockposition, PlayerEntity who, List<net.minecraft.item.ItemStack> itemsToHarvest) {
        ArrayList<ItemStack> bukkitItemsToHarvest = new ArrayList<ItemStack>(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Player player = (Player)((Object)who.getBukkitEntity());
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent(player, CraftBlock.at((IWorld)world, blockposition), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent(playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketFishEvent callPlayerFishBucketEvent(AbstractFishEntity fish, PlayerEntity entityHuman, net.minecraft.item.ItemStack waterBucket, net.minecraft.item.ItemStack fishBucket) {
        Fish bukkitFish = (Fish)((Object)fish.getBukkitEntity());
        Player player = (Player)((Object)entityHuman.getBukkitEntity());
        PlayerBucketFishEvent playerBucketFishEvent = new PlayerBucketFishEvent(player, bukkitFish, CraftItemStack.asBukkitCopy(waterBucket), CraftItemStack.asBukkitCopy(fishBucket));
        Bukkit.getPluginManager().callEvent(playerBucketFishEvent);
        return playerBucketFishEvent;
    }

    public static TradeSelectEvent callTradeSelectEvent(ServerPlayerEntity player, int newIndex, MerchantContainer merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent(merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent(tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(ServerWorld world, PlayerEntity who, Hand hand, List<org.bukkit.block.BlockState> blockStates, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getServer();
        Player player = (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        boolean canBuild = true;
        int i = 0;
        while (i < blockStates.size()) {
            if (!CraftEventFactory.canBuild(world, player, blockStates.get(i).getX(), blockStates.get(i).getZ())) {
                canBuild = false;
                break;
            }
            ++i;
        }
        ItemStack item = hand == Hand.MAIN_HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, blockClicked, item, player, canBuild);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(ServerWorld world, PlayerEntity who, Hand hand, org.bukkit.block.BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        EquipmentSlot equipmentSlot;
        ItemStack item;
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getServer();
        Player player = (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(world, player, placedBlock.getX(), placedBlock.getZ());
        if (hand == Hand.MAIN_HAND) {
            item = player.getInventory().getItemInMainHand();
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            item = player.getInventory().getItemInOffHand();
            equipmentSlot = EquipmentSlot.OFF_HAND;
        }
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, org.bukkit.block.BlockState state, ServerPlayerEntity player, List<ItemEntity> items) {
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, player.getBukkitEntity(), Lists.transform(items, item -> (org.bukkit.entity.Item)((Object)item.getBukkitEntity())));
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            for (ItemEntity item2 : items) {
                item2.field_70170_p.func_217376_c((net.minecraft.entity.Entity)item2);
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(ItemUseContext itemactioncontext, net.minecraft.entity.Entity entity) {
        return CraftEventFactory.callEntityPlaceEvent(itemactioncontext.func_195991_k(), itemactioncontext.func_195995_a(), itemactioncontext.func_196000_l(), itemactioncontext.func_195999_j(), entity);
    }

    public static EntityPlaceEvent callEntityPlaceEvent(net.minecraft.world.World world, BlockPos clickPosition, Direction clickedFace, PlayerEntity human, net.minecraft.entity.Entity entity) {
        Player who = human == null ? null : (Player)((Object)human.getBukkitEntity());
        CraftBlock blockClicked = CraftBlock.at((IWorld)world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent(entity.getBukkitEntity(), who, blockClicked, blockFace);
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(ServerWorld world, PlayerEntity who, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.item.ItemStack itemInHand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemInHand, Items.field_151133_ar);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(ServerWorld world, PlayerEntity who, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.item.ItemStack itemInHand, Item bucket) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, ServerWorld world, PlayerEntity who, BlockPos changed, BlockPos clicked, Direction clickedFace, net.minecraft.item.ItemStack itemstack, Item item) {
        PlayerBucketEvent event;
        Player player = (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftMagicNumbers.getMaterial(itemstack.func_77973_b());
        CraftServer craftServer = (CraftServer)player.getServer();
        CraftBlock block = CraftBlock.at((IWorld)world, changed);
        CraftBlock blockClicked = CraftBlock.at((IWorld)world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, block, blockClicked, blockFace, bucket, itemInHand);
            event.setCancelled(!CraftEventFactory.canBuild(world, player, changed.func_177958_n(), changed.func_177952_p()));
        } else {
            event = new PlayerBucketEmptyEvent(player, block, blockClicked, blockFace, bucket, itemInHand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, player, changed.func_177958_n(), changed.func_177952_p()));
        }
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(PlayerEntity who, Action action, net.minecraft.item.ItemStack itemstack, Hand hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", new Object[]{who, action, itemstack}));
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, null, Direction.SOUTH, itemstack, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(PlayerEntity who, Action action, BlockPos position, Direction direction, net.minecraft.item.ItemStack itemstack, Hand hand) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, false, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(PlayerEntity who, Action action, BlockPos position, Direction direction, net.minecraft.item.ItemStack itemstack, boolean cancelledBlock, Hand hand) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = null;
        if (position != null) {
            blockClicked = craftWorld.getBlockAt(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, itemInHand, blockClicked, blockFace, hand == null ? null : (hand == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(net.minecraft.entity.LivingEntity original, net.minecraft.entity.LivingEntity coverted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(coverted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(net.minecraft.entity.LivingEntity original, List<net.minecraft.entity.LivingEntity> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (net.minecraft.entity.LivingEntity entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent(original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(net.minecraft.entity.LivingEntity who, net.minecraft.item.ItemStack bow, net.minecraft.item.ItemStack consumableItem, net.minecraft.entity.Entity entityArrow, Hand hand, float force, boolean consumeItem) {
        EquipmentSlot handSlot;
        LivingEntity shooter = (LivingEntity)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        EquipmentSlot equipmentSlot = handSlot = hand == Hand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, itemInHand, itemConsumable, arrow, handSlot, force, consumeItem);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(VillagerEntity vilager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)((Object)vilager.getBukkitEntity()), future, reason);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(PlayerEntity who, int x, int y, int z, net.minecraft.item.ItemStack itemstack, boolean instaBreak) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = craftWorld.getBlockAt(x, y, z);
        BlockDamageEvent event = new BlockDamageEvent(player, blockClicked, itemInHand, instaBreak);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean doEntityAddEventCalling(net.minecraft.world.World world, net.minecraft.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        Event event = null;
        if (entity instanceof net.minecraft.entity.LivingEntity && !(entity instanceof ServerPlayerEntity)) {
            boolean isAnimal = entity instanceof AnimalEntity || entity instanceof WaterMobEntity || entity instanceof GolemEntity;
            boolean isMonster = entity instanceof MonsterEntity || entity instanceof GhastEntity || entity instanceof SlimeEntity;
            boolean isNpc = entity instanceof INPC;
            if (spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM && (isAnimal && !world.getWorld().getAllowAnimals() || isMonster && !world.getWorld().getAllowMonsters() || isNpc && !world.getServer().getServer().func_230538_V_())) {
                entity.field_70128_L = true;
                return false;
            }
            event = CraftEventFactory.callCreatureSpawnEvent((net.minecraft.entity.LivingEntity)entity, spawnReason);
        } else if (entity instanceof ItemEntity) {
            event = CraftEventFactory.callItemSpawnEvent((ItemEntity)entity);
        } else if (entity.getBukkitEntity() instanceof Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause = spawnReason == CreatureSpawnEvent.SpawnReason.COMMAND ? LightningStrikeEvent.Cause.COMMAND : LightningStrikeEvent.Cause.UNKNOWN;
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)((Object)entity.getBukkitEntity()), cause);
        } else if (entity instanceof ExperienceOrbEntity) {
            ExperienceOrbEntity xp = (ExperienceOrbEntity)entity;
            double radius = world.spigotConfig.expMerge;
            if (radius > 0.0) {
                List entities = world.func_72839_b(entity, entity.func_174813_aQ().func_72314_b(radius, radius, radius));
                for (net.minecraft.entity.Entity e : entities) {
                    if (!(e instanceof ExperienceOrbEntity)) continue;
                    ExperienceOrbEntity loopItem = (ExperienceOrbEntity)e;
                    if (loopItem.field_70128_L) continue;
                    xp.field_70530_e += loopItem.field_70530_e;
                    loopItem.func_70106_y();
                }
            }
        } else if (!(entity instanceof ServerPlayerEntity)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.field_70128_L)) {
            net.minecraft.entity.Entity vehicle = entity.func_184187_bx();
            if (vehicle != null) {
                vehicle.field_70128_L = true;
            }
            for (net.minecraft.entity.Entity passenger : entity.func_184182_bu()) {
                passenger.field_70128_L = true;
            }
            entity.field_70128_L = true;
            return false;
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(net.minecraft.entity.Entity entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent(bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(net.minecraft.entity.LivingEntity entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)((Object)entityliving.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(MobEntity entity, PlayerEntity tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        entity.field_82179_bU = true;
        EntityTameEvent event = new EntityTameEvent((LivingEntity)((Object)bukkitEntity), bukkitTamer);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(ItemEntity entityitem) {
        org.bukkit.entity.Item entity = (org.bukkit.entity.Item)((Object)entityitem.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(ItemEntity entityitem) {
        org.bukkit.entity.Item entity = (org.bukkit.entity.Item)((Object)entityitem.getBukkitEntity());
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static ItemMergeEvent callItemMergeEvent(ItemEntity merging, ItemEntity mergingWith) {
        org.bukkit.entity.Item entityMerging = (org.bukkit.entity.Item)((Object)merging.getBukkitEntity());
        org.bukkit.entity.Item entityMergingWith = (org.bukkit.entity.Item)((Object)mergingWith.getBukkitEntity());
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PotionSplashEvent callPotionSplashEvent(PotionEntity potion, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)((Object)potion.getBukkitEntity());
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, affectedEntities);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(PotionEntity potion, AreaEffectCloudEntity cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)((Object)potion.getBukkitEntity());
        AreaEffectCloud effectCloud = (AreaEffectCloud)((Object)cloud.getBukkitEntity());
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, effectCloud);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(IWorld world, BlockPos pos, BlockState newBlock) {
        CraftBlockState state = CraftBlockState.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(net.minecraft.world.World world, BlockPos pos, BlockState newBlock, int flag) {
        CraftBlockState state = CraftBlockState.getBlockState(world, pos, flag);
        state.setData(newBlock);
        MoistureChangeEvent event = new MoistureChangeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBlockSpreadEvent(net.minecraft.world.World world, BlockPos source, BlockPos target, BlockState block) {
        return CraftEventFactory.handleBlockSpreadEvent(world, source, target, block, 2);
    }

    public static boolean handleBlockSpreadEvent(net.minecraft.world.World world, BlockPos source, BlockPos target, BlockState block, int flag) {
        CraftBlockState state = CraftBlockState.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent(world.getWorld().getBlockAt(target.func_177958_n(), target.func_177956_o(), target.func_177952_p()), world.getWorld().getBlockAt(source.func_177958_n(), source.func_177956_o(), source.func_177952_p()), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static EntityDeathEvent callEntityDeathEvent(net.minecraft.entity.LivingEntity victim) {
        return CraftEventFactory.callEntityDeathEvent(victim, new ArrayList<ItemStack>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(net.minecraft.entity.LivingEntity victim, List<ItemStack> drops) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent(entity, drops, victim.getExpReward());
        CraftWorld world = (CraftWorld)entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.expToDrop = event.getDroppedExp();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(ServerPlayerEntity victim, List<ItemStack> drops, String deathMessage, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        PlayerDeathEvent event = new PlayerDeathEvent(entity, drops, victim.getExpReward(), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        World world = entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static ServerListPingEvent callServerListPingEvent(Server craftServer, InetAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent(address, motd, numPlayers, maxPlayers);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.entity.Entity entity, DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.entity.Entity entity, DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        if (source.func_94541_c()) {
            EntityDamageEvent event;
            net.minecraft.entity.Entity damager = entityDamage;
            entityDamage = null;
            if (damager == null) {
                event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, modifiers, modifierFunctions);
            } else {
                boolean cfr_ignored_0 = entity instanceof EnderDragonEntity;
                EntityDamageEvent.DamageCause damageCause = damager instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
                event = new EntityDamageByEntityEvent(damager.getBukkitEntity(), entity.getBukkitEntity(), damageCause, modifiers, modifierFunctions);
            }
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (source instanceof EntityDamageSource) {
            EntityDamageEvent.DamageCause cause;
            net.minecraft.entity.Entity damager = source.func_76346_g();
            EntityDamageEvent.DamageCause damageCause = cause = source.isSweep() ? EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK : EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (source instanceof IndirectEntityDamageSource) {
                damager = ((IndirectEntityDamageSource)source).getProximateDamageSource();
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if ("thorns".equals(source.field_76373_n)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, modifiers, modifierFunctions, cancelled);
        }
        if (source == DamageSource.field_76380_i) {
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.VOID, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (source == DamageSource.field_76371_c) {
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.LAVA, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (blockDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            Block damager = blockDamage;
            blockDamage = null;
            if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v) {
                cause = EntityDamageEvent.DamageCause.CONTACT;
            } else if (source == DamageSource.field_190095_e) {
                cause = EntityDamageEvent.DamageCause.HOT_FLOOR;
            } else if (source == DamageSource.field_76376_m) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            } else {
                throw new IllegalStateException(String.format("Unhandled damage of %s by %s from %s", entity, damager, source.field_76373_n));
            }
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (entityDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            CraftEntity damager = entityDamage.getBukkitEntity();
            entityDamage = null;
            if (source == DamageSource.field_82728_o || source == DamageSource.field_82729_p) {
                cause = EntityDamageEvent.DamageCause.FALLING_BLOCK;
            } else if (damager instanceof LightningStrike) {
                cause = EntityDamageEvent.DamageCause.LIGHTNING;
            } else if (source == DamageSource.field_76379_h) {
                cause = EntityDamageEvent.DamageCause.FALL;
            } else if (source == DamageSource.field_188407_q) {
                cause = EntityDamageEvent.DamageCause.DRAGON_BREATH;
            } else if (source == DamageSource.field_76376_m) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            } else {
                throw new IllegalStateException(String.format("Unhandled damage of %s by %s from %s", entity, damager.getHandle(), source.field_76373_n));
            }
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        EntityDamageEvent.DamageCause cause = null;
        if (source == DamageSource.field_76372_a) {
            cause = EntityDamageEvent.DamageCause.FIRE;
        } else if (source == DamageSource.field_76366_f) {
            cause = EntityDamageEvent.DamageCause.STARVATION;
        } else if (source == DamageSource.field_82727_n) {
            cause = EntityDamageEvent.DamageCause.WITHER;
        } else if (source == DamageSource.field_76368_d) {
            cause = EntityDamageEvent.DamageCause.SUFFOCATION;
        } else if (source == DamageSource.field_76369_e) {
            cause = EntityDamageEvent.DamageCause.DROWNING;
        } else if (source == DamageSource.field_76370_b) {
            cause = EntityDamageEvent.DamageCause.FIRE_TICK;
        } else if (source == MELTING) {
            cause = EntityDamageEvent.DamageCause.MELTING;
        } else if (source == POISON) {
            cause = EntityDamageEvent.DamageCause.POISON;
        } else if (source == DamageSource.field_76376_m) {
            cause = EntityDamageEvent.DamageCause.MAGIC;
        } else if (source == DamageSource.field_76379_h) {
            cause = EntityDamageEvent.DamageCause.FALL;
        } else if (source == DamageSource.field_188406_j) {
            cause = EntityDamageEvent.DamageCause.FLY_INTO_WALL;
        } else if (source == DamageSource.field_191291_g) {
            cause = EntityDamageEvent.DamageCause.CRAMMING;
        } else if (source == DamageSource.field_205132_u) {
            cause = EntityDamageEvent.DamageCause.DRYOUT;
        } else if (source == DamageSource.field_76377_j) {
            cause = EntityDamageEvent.DamageCause.CUSTOM;
        }
        if (cause != null) {
            return CraftEventFactory.callEntityDamageEvent(null, entity, cause, modifiers, modifierFunctions, cancelled);
        }
        throw new IllegalStateException(String.format("Unhandled damage of %s from %s", entity, source.field_76373_n));
    }

    private static EntityDamageEvent callEntityDamageEvent(net.minecraft.entity.Entity damager, net.minecraft.entity.Entity damagee, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.callEntityDamageEvent(damager, damagee, cause, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent callEntityDamageEvent(net.minecraft.entity.Entity damager, net.minecraft.entity.Entity damagee, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageEvent event = damager != null ? new EntityDamageByEntityEvent(damager.getBukkitEntity(), damagee.getBukkitEntity(), cause, modifiers, modifierFunctions) : new EntityDamageEvent(damagee.getBukkitEntity(), cause, modifiers, modifierFunctions);
        event.setCancelled(cancelled);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.entity.Entity damagee, DamageSource source, double rawDamage, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source == DamageSource.field_82729_p || source == DamageSource.field_82728_o) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof PlayerEntity) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.entity.Entity entity, DamageSource source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.entity.Entity entity, DamageSource source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.entity.Entity entity, DamageSource source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        EntityDamageEvent event = CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(PlayerEntity entity, int expAmount) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(PlayerEntity entity, ExperienceOrbEntity orb, net.minecraft.item.ItemStack nmsMendedItem, int repairAmount) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, bukkitStack, (ExperienceOrb)((Object)orb.getBukkitEntity()), repairAmount);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleBlockGrowEvent(net.minecraft.world.World world, BlockPos pos, BlockState block) {
        return CraftEventFactory.handleBlockGrowEvent(world, pos, block, 3);
    }

    public static boolean handleBlockGrowEvent(net.minecraft.world.World world, BlockPos pos, BlockState newData, int flag) {
        Block block = world.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(net.minecraft.world.World world, BlockPos block, BlockState newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent(CraftBlock.at((IWorld)world, block), CraftBlockData.fromData(newData));
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(PlayerEntity entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(PlayerEntity entity, int level, net.minecraft.item.ItemStack item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent(entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(net.minecraft.entity.Entity pig, net.minecraft.entity.Entity lightning, net.minecraft.entity.Entity pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)((Object)pig.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), (PigZombie)((Object)pigzombie.getBukkitEntity()));
        pig.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static HorseJumpEvent callHorseJumpEvent(net.minecraft.entity.Entity horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)((Object)horse.getBukkitEntity()), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(net.minecraft.entity.Entity entity, BlockPos position, BlockState newBlock) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, position, newBlock, false);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(net.minecraft.entity.Entity entity, BlockPos position, BlockState newBlock, boolean cancelled) {
        Block block = entity.field_70170_p.getWorld().getBlockAt(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity.getBukkitEntity(), block, CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static CreeperPowerEvent callCreeperPowerEvent(net.minecraft.entity.Entity creeper, net.minecraft.entity.Entity lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)((Object)creeper.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(net.minecraft.entity.Entity entity, net.minecraft.entity.Entity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent(entity.getBukkitEntity(), target == null ? null : target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(net.minecraft.entity.Entity entity, net.minecraft.entity.LivingEntity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)((Object)target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(net.minecraft.entity.Entity entity, BlockPos pos) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at((IWorld)entity.field_70170_p, pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)((Object)entity1), block);
        entity1.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static Container callInventoryOpenEvent(ServerPlayerEntity player, Container container) {
        return CraftEventFactory.callInventoryOpenEvent(player, container, false);
    }

    public static Container callInventoryOpenEvent(ServerPlayerEntity player, Container container, boolean cancelled) {
        if (player.field_71070_bA != player.field_71069_bz) {
            player.field_71135_a.func_147356_a(new CCloseWindowPacket(player.field_71070_bA.field_75152_c));
        }
        CraftServer server = player.field_70170_p.getServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.field_71070_bA.transferTo(container, (CraftHumanEntity)craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            container.transferTo(player.field_71070_bA, (CraftHumanEntity)craftPlayer);
            return null;
        }
        return container;
    }

    public static net.minecraft.item.ItemStack callPreCraftEvent(IInventory matrix, IInventory resultInventory, net.minecraft.item.ItemStack result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent(inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent(event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(net.minecraft.entity.Entity entity) {
        Projectile bukkitEntity = (Projectile)((Object)entity.getBukkitEntity());
        ProjectileLaunchEvent event = new ProjectileLaunchEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(net.minecraft.entity.Entity entity, RayTraceResult position) {
        if (position.func_216346_c() == RayTraceResult.Type.MISS) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult positionBlock = (BlockRayTraceResult)position;
            hitBlock = CraftBlock.at((IWorld)entity.field_70170_p, positionBlock.func_216350_a());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.func_216354_b());
        }
        CraftEntity hitEntity = null;
        if (position.func_216346_c() == RayTraceResult.Type.ENTITY) {
            hitEntity = ((EntityRayTraceResult)position).func_216348_a().getBukkitEntity();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)((Object)entity.getBukkitEntity()), hitEntity, hitBlock, hitFace);
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(net.minecraft.entity.Entity entity, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)((Object)entity.getBukkitEntity());
        ExpBottleEvent event = new ExpBottleEvent(bottle, exp);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(net.minecraft.world.World world, BlockPos pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), oldCurrent, newCurrent);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(net.minecraft.world.World world, BlockPos pos, NoteBlockInstrument instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), Instrument.getByType((byte)instrument.ordinal()), new Note(note));
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void callPlayerItemBreakEvent(PlayerEntity human, net.minecraft.item.ItemStack brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)((Object)human.getBukkitEntity()), item);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.World world, BlockPos block, BlockPos source) {
        BlockIgniteEvent.IgniteCause cause;
        CraftWorld bukkitWorld = world.getWorld();
        Block igniter = bukkitWorld.getBlockAt(source.func_177958_n(), source.func_177956_o(), source.func_177952_p());
        switch (igniter.getType()) {
            case LAVA: {
                cause = BlockIgniteEvent.IgniteCause.LAVA;
                break;
            }
            case DISPENSER: {
                cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
                break;
            }
            default: {
                cause = BlockIgniteEvent.IgniteCause.SPREAD;
            }
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(block.func_177958_n(), block.func_177956_o(), block.func_177952_p()), cause, igniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.World world, BlockPos pos, net.minecraft.entity.Entity igniter) {
        net.minecraft.entity.Entity shooter;
        BlockIgniteEvent.IgniteCause cause;
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        switch (bukkitIgniter.getType()) {
            case ENDER_CRYSTAL: {
                cause = BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
                break;
            }
            case LIGHTNING: {
                cause = BlockIgniteEvent.IgniteCause.LIGHTNING;
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                cause = BlockIgniteEvent.IgniteCause.FIREBALL;
                break;
            }
            case ARROW: {
                cause = BlockIgniteEvent.IgniteCause.ARROW;
                break;
            }
            default: {
                cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            }
        }
        if (igniter instanceof ProjectileEntity && (shooter = ((ProjectileEntity)igniter).func_234616_v_()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), cause, bukkitIgniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.World world, int x, int y, int z, Explosion explosion) {
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity igniter = explosion.field_77283_e == null ? null : explosion.field_77283_e.getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y, z), BlockIgniteEvent.IgniteCause.EXPLOSION, igniter);
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.World world, BlockPos pos, BlockIgniteEvent.IgniteCause cause, net.minecraft.entity.Entity igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), cause, igniter.getBukkitEntity());
        world.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void handleInventoryCloseEvent(PlayerEntity human) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.field_71070_bA.getBukkitView());
        human.field_70170_p.getServer().getPluginManager().callEvent(event);
        human.field_71070_bA.transferTo((Container)human.field_71069_bz, human.getBukkitEntity());
    }

    public static net.minecraft.item.ItemStack handleEditBookEvent(ServerPlayerEntity player, int itemInHandIndex, net.minecraft.item.ItemStack itemInHand, net.minecraft.item.ItemStack newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent(player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.func_77973_b() == Items.field_151164_bB);
        player.field_70170_p.getServer().getPluginManager().callEvent(editBookEvent);
        if (itemInHand != null && itemInHand.func_77973_b() == Items.field_151099_bA && !editBookEvent.isCancelled()) {
            if (editBookEvent.isSigning()) {
                itemInHand.setItem(Items.field_151164_bB);
            }
            CraftMetaBook meta = (CraftMetaBook)editBookEvent.getNewBookMeta();
            CraftItemStack.setItemMeta(itemInHand, meta);
        }
        return itemInHand;
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(MobEntity entity, PlayerEntity player) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()));
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(MobEntity entity, net.minecraft.entity.Entity leashHolder, PlayerEntity player) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent(entity.getBukkitEntity(), leashHolder.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()));
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(net.minecraft.entity.Entity animal, Block dispenser, CraftItemStack is) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, animal.getBukkitEntity(), is);
        Bukkit.getPluginManager().callEvent(bse);
        return bse;
    }

    public static boolean handlePlayerShearEntityEvent(PlayerEntity player, net.minecraft.entity.Entity sheared, net.minecraft.item.ItemStack shears, Hand hand) {
        if (!(player instanceof ServerPlayerEntity)) {
            return true;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)((Object)player.getBukkitEntity()), sheared.getBukkitEntity(), CraftItemStack.asCraftMirror(shears), hand == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static Cancellable handleStatisticsIncrease(PlayerEntity entityHuman, Stat<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((ServerPlayerEntity)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + statistic);
            return null;
        }
        switch (stat) {
            case PLAY_ONE_MINUTE: 
            case WALK_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case FALL_ONE_CM: 
            case SNEAK_TIME: 
            case CLIMB_ONE_CM: 
            case FLY_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case MINECART_ONE_CM: 
            case BOAT_ONE_CM: 
            case PIG_ONE_CM: 
            case HORSE_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SWIM_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent(player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, material);
        }
        entityHuman.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static FireworkExplodeEvent callFireworkExplodeEvent(FireworkRocketEntity firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)((Object)firework.getBukkitEntity()));
        firework.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(InventoryView view, net.minecraft.item.ItemStack item) {
        PrepareAnvilEvent event = new PrepareAnvilEvent(view, CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent(event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, net.minecraft.item.ItemStack item) {
        PrepareSmithingEvent event = new PrepareSmithingEvent(view, CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent(event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(net.minecraft.entity.Entity spawnee, BlockPos pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        org.bukkit.block.BlockState state = entity.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent(entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(net.minecraft.entity.LivingEntity entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((LivingEntity)((Object)entity.getBukkitEntity()), gliding);
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(net.minecraft.entity.LivingEntity entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)((Object)entity.getBukkitEntity()), swimming);
        entity.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(AreaEffectCloudEntity cloud, List<LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)((Object)cloud.getBukkitEntity()), entities);
        cloud.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(net.minecraft.entity.Entity entity) {
        Vehicle bukkitEntity = (Vehicle)((Object)entity.getBukkitEntity());
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(net.minecraft.entity.LivingEntity child, net.minecraft.entity.LivingEntity mother, net.minecraft.entity.LivingEntity father, net.minecraft.entity.LivingEntity breeder, net.minecraft.item.ItemStack bredWith, int experience) {
        LivingEntity breederEntity = (LivingEntity)((Object)(breeder == null ? null : breeder.getBukkitEntity()));
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)((Object)child.getBukkitEntity()), (LivingEntity)((Object)mother.getBukkitEntity()), (LivingEntity)((Object)father.getBukkitEntity()), breederEntity, bredWithStack, experience);
        child.field_70170_p.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(IWorld world, BlockPos blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent(block, block.getBlockData());
        if (world instanceof net.minecraft.world.World) {
            ((net.minecraft.world.World)world).func_73046_m().server.getPluginManager().callEvent(event);
        }
        return event;
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.World world, BlockPos pos, BlockState block) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(net.minecraft.entity.LivingEntity entity, @Nullable EffectInstance oldEffect, @Nullable EffectInstance newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(net.minecraft.entity.LivingEntity entity, @Nullable EffectInstance oldEffect, @Nullable EffectInstance newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(net.minecraft.entity.LivingEntity entity, @Nullable EffectInstance oldEffect, @Nullable EffectInstance newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(net.minecraft.entity.LivingEntity entity, @Nullable EffectInstance oldEffect, @Nullable EffectInstance newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitNewEffect;
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect potionEffect = bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        if (bukkitOldEffect == null && bukkitNewEffect == null) {
            throw new IllegalStateException("Old and new potion effect are both null");
        }
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((LivingEntity)((Object)entity.getBukkitEntity()), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.World world, BlockPos pos, BlockState block, @Nullable net.minecraft.entity.Entity entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3, entity);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.World world, BlockPos pos, BlockState block, int flag) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, flag, null);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.World world, BlockPos pos, BlockState block, int flag, @Nullable net.minecraft.entity.Entity entity) {
        CraftBlockState blockState = CraftBlockState.getBlockState(world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent(blockState.getBlock(), blockState) : new EntityBlockFormEvent(entity.getBukkitEntity(), blockState.getBlock(), blockState);
        world.getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBatToggleSleepEvent(net.minecraft.entity.Entity bat, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)((Object)bat.getBukkitEntity()), awake);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static boolean handlePlayerRecipeListUpdateEvent(PlayerEntity who, ResourceLocation recipe) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)((Object)who.getBukkitEntity()), CraftNamespacedKey.fromMinecraft(recipe));
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(net.minecraft.entity.Entity who, ItemEntity item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)((Object)who.getBukkitEntity()), (org.bukkit.entity.Item)((Object)item.getBukkitEntity()), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callRaidTriggerEvent(Raid raid, ServerPlayerEntity player) {
        RaidTriggerEvent event = new RaidTriggerEvent(new CraftRaid(raid), raid.func_221316_i().getWorld(), player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(Raid raid, List<Player> players) {
        RaidFinishEvent event = new RaidFinishEvent(new CraftRaid(raid), raid.func_221316_i().getWorld(), players);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callRaidStopEvent(Raid raid, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent(new CraftRaid(raid), raid.func_221316_i().getWorld(), reason);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callRaidSpawnWaveEvent(Raid raid, AbstractRaiderEntity leader, List<AbstractRaiderEntity> raiders) {
        CraftRaider craftLeader = (CraftRaider)leader.getBukkitEntity();
        ArrayList<Raider> craftRaiders = new ArrayList<Raider>();
        for (AbstractRaiderEntity entityRaider : raiders) {
            craftRaiders.add((Raider)((Object)entityRaider.getBukkitEntity()));
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent(new CraftRaid(raid), raid.func_221316_i().getWorld(), craftLeader, craftRaiders);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static LootGenerateEvent callLootGenerateEvent(IInventory inventory, LootTable lootTable, LootContext lootInfo, List<net.minecraft.item.ItemStack> loot, boolean plugin) {
        CraftWorld world = lootInfo.func_202879_g().getWorld();
        net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)lootInfo.func_216031_c(LootParameters.field_216281_a);
        NamespacedKey key = CraftNamespacedKey.fromMinecraft((ResourceLocation)world.getHandle().func_73046_m().func_200249_aQ().lootTableToKey.get(lootTable));
        CraftLootTable craftLootTable = new CraftLootTable(key, lootTable);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent(world, entity != null ? entity.getBukkitEntity() : null, inventory.getOwner(), craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static void callStriderTemperatureChangeEvent(StriderEntity strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)((Object)strider.getBukkitEntity()), shivering);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static boolean handleEntitySpellCastEvent(SpellcastingIllagerEntity caster, SpellcastingIllagerEntity.SpellType spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)((Object)caster.getBukkitEntity()), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(net.minecraft.entity.LivingEntity entity, int oldAmount, int newAmount, boolean isReset) {
        LivingEntity bukkitEntity = (LivingEntity)((Object)entity.getBukkitEntity());
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(PlayerEntity humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent(humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(PiglinEntity piglin, List<net.minecraft.item.ItemStack> outcome, net.minecraft.item.ItemStack input) {
        PiglinBarterEvent event = new PiglinBarterEvent((Piglin)((Object)piglin.getBukkitEntity()), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }
}

