/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftMetaItem;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaEntityTag
extends CraftMetaItem {
    static final CraftMetaItem.ItemMetaKey ENTITY_TAG = new CraftMetaItem.ItemMetaKey("EntityTag", "entity-tag");
    CompoundNBT entityTag;

    CraftMetaEntityTag(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaEntityTag)) {
            return;
        }
        CraftMetaEntityTag entity = (CraftMetaEntityTag)meta;
        this.entityTag = entity.entityTag;
    }

    CraftMetaEntityTag(CompoundNBT tag) {
        super(tag);
        if (tag.func_74764_b(CraftMetaEntityTag.ENTITY_TAG.NBT)) {
            this.entityTag = tag.func_74775_l(CraftMetaEntityTag.ENTITY_TAG.NBT);
        }
    }

    CraftMetaEntityTag(Map<String, Object> map) {
        super(map);
    }

    @Override
    void deserializeInternal(CompoundNBT tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.func_74764_b(CraftMetaEntityTag.ENTITY_TAG.NBT)) {
            this.entityTag = tag.func_74775_l(CraftMetaEntityTag.ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, INBT> internalTags) {
        if (this.entityTag != null && !this.entityTag.isEmpty()) {
            internalTags.put(CraftMetaEntityTag.ENTITY_TAG.NBT, (INBT)this.entityTag);
        }
    }

    @Override
    void applyToItem(CompoundNBT tag) {
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.func_218657_a(CraftMetaEntityTag.ENTITY_TAG.NBT, (INBT)this.entityTag);
        }
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case PAINTING: 
            case PUFFERFISH_BUCKET: 
            case SALMON_BUCKET: 
            case COD_BUCKET: 
            case ITEM_FRAME: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isEntityTagEmpty();
    }

    boolean isEntityTagEmpty() {
        return this.entityTag == null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaEntityTag) {
            CraftMetaEntityTag that = (CraftMetaEntityTag)meta;
            return this.entityTag != null ? that.entityTag != null && this.entityTag.equals((Object)that.entityTag) : this.entityTag == null;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaEntityTag || this.isEntityTagEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.entityTag != null) {
            hash = 73 * hash + this.entityTag.hashCode();
        }
        return original != hash ? CraftMetaEntityTag.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        return builder;
    }

    @Override
    public CraftMetaEntityTag clone() {
        CraftMetaEntityTag clone = (CraftMetaEntityTag)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.func_74737_b();
        }
        return clone;
    }
}

