/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CommandNodeTransformer
implements ITransformer<ClassNode> {
    @Nonnull
    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        MethodNode canUseMethod = input.methods.stream().filter(methodNode -> Objects.equals(methodNode.name, "canUse") && Objects.equals(methodNode.desc, "(Ljava/lang/Object;)Z")).findFirst().orElseThrow(() -> new RuntimeException("Can't found canUse method!"));
        canUseMethod.localVariables.clear();
        canUseMethod.instructions.clear();
        canUseMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        canUseMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        canUseMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        canUseMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "com/mojang/brigadier/tree/CommandNode", "requirement", "Ljava/util/function/Predicate;"));
        canUseMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "catserver/server/hook/CommandNodeHook", "canUse", "(Lcom/mojang/brigadier/tree/CommandNode;Ljava/lang/Object;Ljava/util/function/Predicate;)Z", false));
        canUseMethod.instructions.add((AbstractInsnNode)new InsnNode(172));
        canUseMethod.maxStack = 3;
        canUseMethod.maxLocals = 2;
        MethodNode addChildMethod = input.methods.stream().filter(methodNode -> Objects.equals(methodNode.name, "addChild") && Objects.equals(methodNode.desc, "(Lcom/mojang/brigadier/tree/CommandNode;)V")).findFirst().orElseThrow(() -> new RuntimeException("Can't found addChild method!"));
        InsnList dispatcherHook = new InsnList();
        dispatcherHook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        dispatcherHook.add((AbstractInsnNode)new VarInsnNode(25, 1));
        dispatcherHook.add((AbstractInsnNode)new MethodInsnNode(184, "catserver/server/hook/CommandNodeHook", "dispatcher", "(Lcom/mojang/brigadier/tree/CommandNode;Lcom/mojang/brigadier/tree/CommandNode;)V", false));
        List returnInsnNodes = Arrays.stream(addChildMethod.instructions.toArray()).filter(insnNode -> insnNode instanceof InsnNode && insnNode.getOpcode() == 177).collect(Collectors.toList());
        if (returnInsnNodes.size() == 0) {
            throw new RuntimeException("Can't found addChild return!");
        }
        AbstractInsnNode lastReturnInsnNode = (AbstractInsnNode)returnInsnNodes.get(returnInsnNodes.size() - 1);
        addChildMethod.instructions.insertBefore(lastReturnInsnNode, dispatcherHook);
        MethodNode removeCommandMethod = new MethodNode(1, "removeCommand", "(Ljava/lang/String;)V", null, new String[0]);
        for (String fieldName : new String[]{"children", "literals", "arguments"}) {
            removeCommandMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            removeCommandMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "com/mojang/brigadier/tree/CommandNode", fieldName, "Ljava/util/Map;"));
            removeCommandMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            removeCommandMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", true));
            removeCommandMethod.instructions.add((AbstractInsnNode)new InsnNode(87));
        }
        removeCommandMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        removeCommandMethod.maxLocals = 2;
        removeCommandMethod.maxStack = 2;
        input.methods.add(removeCommandMethod);
        return input;
    }

    @Nonnull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @Nonnull
    public Set<ITransformer.Target> targets() {
        return Collections.singleton(ITransformer.Target.targetPreClass((String)"com.mojang.brigadier.tree.CommandNode"));
    }
}

