/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch;

import foxlaunch.LanguageUtils;
import foxlaunch.LibrariesDownloader;
import foxlaunch.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DataManager {
    private static final Map<String, File> librariesMap = new TreeMap<String, File>();
    private static final Map<String, File> librariesWithoutLaunchMap = new TreeMap<String, File>();
    private static final Map<String, String> librariesHashMap = new TreeMap<String, String>();
    private static final Map<String, File> foxLaunchLibsMap = new TreeMap<String, File>();
    private static final Map<String, String> versionData = new TreeMap<String, String>();

    public static void setup() {
        File foxLaunchData;
        File foxLaunchLibs = new File("foxlaunch-libs");
        if (!foxLaunchLibs.exists()) {
            foxLaunchLibs.mkdirs();
        }
        if (!(foxLaunchData = new File("foxlaunch-data")).exists()) {
            foxLaunchData.mkdirs();
        }
        try (JarFile serverJar = new JarFile(Utils.findServerJar());){
            String[] libraries;
            String classPath = Objects.requireNonNull(serverJar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH), "Missing MANIFEST.MF?");
            for (String library : libraries = classPath.split(" ")) {
                File file = new File(library);
                librariesMap.put(file.getName(), file.getParentFile());
            }
            if (librariesMap.size() == 0) {
                throw new RuntimeException("Class-Path is empty!");
            }
            versionData.put("minecraft", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/mcp/").getValue(Attributes.Name.SPECIFICATION_VERSION)));
            versionData.put("mcp", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/mcp/").getValue(Attributes.Name.IMPLEMENTATION_VERSION)));
            versionData.put("forge", Objects.requireNonNull(serverJar.getManifest().getAttributes("net/minecraftforge/versions/forge/").getValue(Attributes.Name.IMPLEMENTATION_VERSION)));
            Enumeration<JarEntry> entry = serverJar.entries();
            while (entry.hasMoreElements()) {
                Object out;
                String[] name;
                JarEntry jarEntry = entry.nextElement();
                if (jarEntry == null || (name = jarEntry.getName().split("/")).length != 2 || !Objects.equals(name[0], "data")) continue;
                if (name[1].endsWith(".jar")) {
                    String[] split;
                    File path = librariesMap.get(name[1]);
                    if (path == null && (split = name[1].substring(0, name[1].length() - 4).split("-")).length != 3 && split.length == 4 && Objects.equals(split[0], "forge") && Objects.equals(split[3], "universal")) {
                        path = new File("libraries/net/minecraftforge/" + split[0] + "/" + split[1] + "-" + split[2]);
                    }
                    boolean isCustomLib = false;
                    if (path == null) {
                        path = foxLaunchLibs;
                        foxLaunchLibsMap.put(name[1], path);
                        isCustomLib = true;
                    } else if (!path.exists()) {
                        path.mkdirs();
                    }
                    File file = new File(path, name[1]);
                    if (isCustomLib && file.exists() && !Utils.isJarCorrupted(file)) continue;
                    out = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        try (InputStream in = serverJar.getInputStream(jarEntry);){
                            int readSize;
                            byte[] bytes = new byte[4096];
                            while ((readSize = in.read(bytes)) > 0) {
                                ((OutputStream)out).write(bytes, 0, readSize);
                            }
                        }
                        ((OutputStream)out).flush();
                        continue;
                    }
                    catch (Throwable in) {
                        throwable = in;
                        throw in;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable in) {
                                throwable.addSuppressed(in);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                        continue;
                    }
                }
                if (Objects.equals(name[1], "server.lzma")) {
                    FileOutputStream out2 = new FileOutputStream(new File(foxLaunchData, name[1]));
                    Throwable throwable = null;
                    try {
                        InputStream in = serverJar.getInputStream(jarEntry);
                        out = null;
                        try {
                            int readSize;
                            byte[] bytes = new byte[4096];
                            while ((readSize = in.read(bytes)) > 0) {
                                ((OutputStream)out2).write(bytes, 0, readSize);
                            }
                        }
                        catch (Throwable bytes) {
                            out = bytes;
                            throw bytes;
                        }
                        finally {
                            if (in != null) {
                                if (out != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable bytes) {
                                        ((Throwable)out).addSuppressed(bytes);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                        }
                        out2.flush();
                        continue;
                    }
                    catch (Throwable in) {
                        throwable = in;
                        throw in;
                    }
                    finally {
                        if (out2 == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out2).close();
                            }
                            catch (Throwable in) {
                                throwable.addSuppressed(in);
                            }
                            continue;
                        }
                        ((OutputStream)out2).close();
                        continue;
                    }
                }
                if (!Objects.equals(name[1], "libraries.txt")) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(serverJar.getInputStream(jarEntry)));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] split = line.split("\\|");
                        if (split.length != 2) continue;
                        File libFile = new File(split[0]);
                        librariesHashMap.put(libFile.getName(), split[1].toUpperCase());
                        if (librariesMap.containsKey(libFile.getName()) || !libFile.getName().endsWith(".jar")) continue;
                        librariesWithoutLaunchMap.put(libFile.getName(), libFile.getParentFile());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not unpack data!", e);
        }
    }

    public static void downloadLibraries() {
        TreeMap<File, String> needDownloadLibrariesMap = new TreeMap<File, String>();
        TreeMap<File, String> needDownloadMappingDataMap = new TreeMap<File, String>();
        for (Map librariesMap : new Map[]{DataManager.librariesMap, librariesWithoutLaunchMap}) {
            for (Map.Entry libraryEntry : librariesMap.entrySet()) {
                String filename = (String)libraryEntry.getKey();
                String md5 = librariesHashMap.get(filename);
                File file = new File((File)libraryEntry.getValue(), (String)libraryEntry.getKey());
                if (file.exists() && (md5 == null || Objects.equals(Utils.getFileMD5(file), md5))) continue;
                needDownloadLibrariesMap.put(file, md5);
            }
        }
        String minecraftVersion = versionData.get("minecraft");
        String mcpVersion = versionData.get("mcp");
        if (minecraftVersion != null && mcpVersion != null) {
            File mcpZip = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s.zip", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            if (!mcpZip.exists() || !Objects.equals(Utils.getFileMD5(mcpZip), librariesHashMap.get(mcpZip.getName()))) {
                needDownloadMappingDataMap.put(mcpZip, librariesHashMap.get(mcpZip.getName()));
            }
            File mcpMappings = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s-mappings.txt", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            String mcpMappingsMD5 = "428EBB172F1E2D80FCC03331DE0EB42E";
            if (!mcpMappings.exists() || !Objects.equals(Utils.getFileMD5(mcpMappings), mcpMappingsMD5)) {
                needDownloadMappingDataMap.put(new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s-mappings.packed", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion)), mcpMappingsMD5);
            }
        }
        if (needDownloadLibrariesMap.size() > 0 || needDownloadMappingDataMap.size() > 0) {
            System.out.println(LanguageUtils.I18nToString("launch.lib_missing"));
            LibrariesDownloader.setupDownloadSource();
            for (Map.Entry libraryEntry : needDownloadLibrariesMap.entrySet()) {
                LibrariesDownloader.tryDownload((File)libraryEntry.getKey(), (String)libraryEntry.getValue());
            }
            for (Map.Entry libraryEntry : needDownloadMappingDataMap.entrySet()) {
                LibrariesDownloader.tryDownload((File)libraryEntry.getKey(), (String)libraryEntry.getValue(), "mappings-data");
            }
            System.out.println(LanguageUtils.I18nToString("launch.lib_download_completed"));
        }
    }

    public static Map<String, File> getLibrariesMap() {
        return librariesMap;
    }

    public static String getVersionData(String target) {
        return versionData.get(target);
    }

    @Deprecated
    protected static void gc() {
        librariesMap.clear();
        librariesWithoutLaunchMap.clear();
        librariesHashMap.clear();
        foxLaunchLibsMap.clear();
        versionData.clear();
        System.gc();
    }
}

