/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileMD5(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            int read = in.read(buffer, 0, 4096);
            while (read > -1) {
                md.update(buffer, 0, read);
                read = in.read(buffer, 0, 4096);
            }
            byte[] digest = md.digest();
            String string = String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest)).toUpperCase();
            return string;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileSHA256(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[4096];
            int read = in.read(buffer, 0, 4096);
            while (read > -1) {
                md.update(buffer, 0, read);
                read = in.read(buffer, 0, 4096);
            }
            byte[] digest = md.digest();
            String string = String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest)).toUpperCase();
            return string;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public static URL pathToURL(String path) throws Exception {
        return new File(path).toURI().toURL();
    }

    public static void relaunch(String mainClass, URL[] classPath, String[] args, boolean closeClassLoader) throws Exception {
        URLClassLoader ucl = new URLClassLoader(classPath, null);
        Class.forName(mainClass, true, ucl).getMethod("main", String[].class).invoke(null, new Object[]{args});
        if (closeClassLoader) {
            ucl.close();
        }
    }

    public static boolean isJarCorrupted(File jarFile) {
        try {
            if (jarFile.exists()) {
                new JarFile(jarFile).close();
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File unpackSingleFileZip(File file) throws IOException {
        try {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(file);){
                if (zipFile.size() > 1) {
                    throw new IOException("Not single file zip!");
                }
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                if (!enumeration.hasMoreElements()) throw new IOException("Empty zip!");
                ZipEntry zipEntry = enumeration.nextElement();
                File outFile = new File(file.getParentFile(), zipEntry.getName());
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    try (InputStream in = zipFile.getInputStream(zipEntry);){
                        int readSize;
                        byte[] bytes = new byte[4096];
                        while ((readSize = in.read(bytes)) > 0) {
                            out.write(bytes, 0, readSize);
                        }
                    }
                    out.flush();
                    File file2 = outFile;
                    return file2;
                }
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
    }

    public static File findServerJar() throws IOException {
        try {
            URL jarUrl = Utils.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(URLDecoder.decode(jarUrl.getPath(), "UTF-8"));
            if (jarFile.isFile()) {
                return jarFile;
            }
            throw new IOException(jarFile.getName() + " is not a file!");
        }
        catch (IOException e) {
            String s = System.getProperty("java.class.path");
            if (s != null && s.replace(":", ";").split(";").length == 1) {
                return new File(s);
            }
            throw e;
        }
    }
}

