/*
 * Decompiled with CFR 0.152.
 */
package foxlaunch.legacy;

import foxlaunch.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.util.Objects;

public class InstallTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(String minecraftVersion, String mcpVersion, String forgeVersion) throws Exception {
        Throwable throwable;
        File forgeServerJar;
        File minecraftSrg;
        File minecraftSlim;
        File minecraftExtra;
        File minecraftServer;
        File mcpMappings;
        File mcpZip;
        File serverLZMA;
        File serverJar;
        File installLog;
        File installHASH;
        URL[] libBinaryPatcher;
        URL[] libSpecialSource;
        URL[] libJarSplitter;
        URL[] libInstallerTools;
        block51: {
            if (minecraftVersion == null || mcpVersion == null || forgeVersion == null) {
                throw new RuntimeException(String.format("Missing version data: [minecraft: %s, mcp: %s, forge: %s]", minecraftVersion, mcpVersion, forgeVersion));
            }
            libInstallerTools = new URL[]{Utils.pathToURL("libraries/net/minecraftforge/installertools/1.1.11/installertools-1.1.11.jar"), Utils.pathToURL("libraries/de/siegmar/fastcsv/1.0.2/fastcsv-1.0.2.jar"), Utils.pathToURL("libraries/com/google/code/gson/gson/2.8.0/gson-2.8.0.jar"), Utils.pathToURL("libraries/com/google/guava/guava/25.1-jre/guava-25.1-jre.jar"), Utils.pathToURL("libraries/com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar"), Utils.pathToURL("libraries/com/google/errorprone/error_prone_annotations/2.1.3/error_prone_annotations-2.1.3.jar"), Utils.pathToURL("libraries/com/google/j2objc/j2objc-annotations/1.1/j2objc-annotations-1.1.jar"), Utils.pathToURL("libraries/org/codehaus/mojo/animal-sniffer-annotations/1.14/animal-sniffer-annotations-1.14.jar"), Utils.pathToURL("libraries/net/md-5/SpecialSource/1.8.5/SpecialSource-1.8.5.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/net/sf/opencsv/opencsv/2.3/opencsv-2.3.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-commons/9.1/asm-commons-9.1.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-analysis/6.1.1/asm-analysis-9.1.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-tree/9.1/asm-tree-9.1jar"), Utils.pathToURL("libraries/org/ow2/asm/asm/9.1/asm-9.1.jar")};
            libJarSplitter = new URL[]{Utils.pathToURL("libraries/net/minecraftforge/jarsplitter/1.1.2/jarsplitter-1.1.2.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar")};
            libSpecialSource = new URL[]{Utils.pathToURL("libraries/net/md-5/SpecialSource/1.8.5/SpecialSource-1.8.5.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/net/sf/opencsv/opencsv/2.3/opencsv-2.3.jar"), Utils.pathToURL("libraries/com/google/guava/guava/25.1-jre/guava-25.1-jre.jar"), Utils.pathToURL("libraries/com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar"), Utils.pathToURL("libraries/com/google/errorprone/error_prone_annotations/2.1.3/error_prone_annotations-2.1.3.jar"), Utils.pathToURL("libraries/com/google/j2objc/j2objc-annotations/1.1/j2objc-annotations-1.1.jar"), Utils.pathToURL("libraries/org/codehaus/mojo/animal-sniffer-annotations/1.14/animal-sniffer-annotations-1.14.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-commons/6.1.1/asm-commons-6.1.1.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-analysis/6.1.1/asm-analysis-6.1.1.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm-tree/6.1.1/asm-tree-6.1.1.jar"), Utils.pathToURL("libraries/org/ow2/asm/asm/6.1.1/asm-6.1.1.jar")};
            libBinaryPatcher = new URL[]{Utils.pathToURL("libraries/net/minecraftforge/binarypatcher/1.0.12/binarypatcher-1.0.12.jar"), Utils.pathToURL("libraries/commons-io/commons-io/2.4/commons-io-2.4.jar"), Utils.pathToURL("libraries/net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar"), Utils.pathToURL("libraries/com/google/guava/guava/25.1-jre/guava-25.1-jre.jar"), Utils.pathToURL("libraries/com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar"), Utils.pathToURL("libraries/com/google/errorprone/error_prone_annotations/2.1.3/error_prone_annotations-2.1.3.jar"), Utils.pathToURL("libraries/com/google/j2objc/j2objc-annotations/1.1/j2objc-annotations-1.1.jar"), Utils.pathToURL("libraries/org/codehaus/mojo/animal-sniffer-annotations/1.14/animal-sniffer-annotations-1.14.jar"), Utils.pathToURL("libraries/com/github/jponge/lzma-java/1.3/lzma-java-1.3.jar"), Utils.pathToURL("libraries/com/nothome/javaxdelta/2.0.1/javaxdelta-2.0.1.jar"), Utils.pathToURL("libraries/org/checkerframework/checker-qual/2.0.0/checker-qual-2.0.0.jar"), Utils.pathToURL("libraries/trove/trove/1.0.2/trove-1.0.2.jar")};
            installHASH = new File("foxlaunch-data/install.dat");
            installLog = new File("foxlaunch-data/install.log");
            serverJar = Utils.findServerJar();
            serverLZMA = new File("foxlaunch-data/server.lzma");
            mcpZip = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s.zip", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            mcpMappings = new File(String.format("libraries/de/oceanlabs/mcp/mcp_config/%s-%s/mcp_config-%s-%s-mappings.txt", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftServer = new File("foxlaunch-data/minecraft_server." + minecraftVersion + ".jar");
            minecraftExtra = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-extra.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftSlim = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-slim.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            minecraftSrg = new File(String.format("libraries/net/minecraft/server/%s-%s/server-%s-%s-srg.jar", minecraftVersion, mcpVersion, minecraftVersion, mcpVersion));
            File forgeUniversalJar = new File(String.format("libraries/net/minecraftforge/forge/%s-%s/forge-%s-%s-universal.jar", minecraftVersion, forgeVersion, minecraftVersion, forgeVersion));
            forgeServerJar = new File(String.format("libraries/net/minecraftforge/forge/%s-%s/forge-%s-%s-server.jar", minecraftVersion, forgeVersion, minecraftVersion, forgeVersion));
            for (File checkFile : new File[]{minecraftServer, mcpZip, serverLZMA, forgeUniversalJar}) {
                if (checkFile.exists()) continue;
                throw new RuntimeException("Missing " + checkFile.getAbsolutePath() + " File!");
            }
            try {
                if (!installHASH.exists()) break block51;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(installHASH)));){
                    if (Objects.equals(reader.readLine(), Objects.requireNonNull(Utils.getFileSHA256(serverJar), serverJar.getName()) + Objects.requireNonNull(Utils.getFileSHA256(serverLZMA), serverLZMA.getName()))) {
                        return;
                    }
                }
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        PrintStream originOutPrint = System.out;
        try {
            throwable = null;
            try (PrintStream logOutPrint = new PrintStream(new BufferedOutputStream(new FileOutputStream(installLog)));){
                System.setOut(logOutPrint);
                originOutPrint.println("Initializing MCP data..");
                if (!mcpMappings.exists()) {
                    Utils.relaunch("net.minecraftforge.installertools.ConsoleTool", libInstallerTools, new String[]{"--task", "MCP_DATA", "--input", mcpZip.getAbsolutePath(), "--output", mcpMappings.getAbsolutePath(), "--key", "mappings"}, true);
                }
                logOutPrint.flush();
                originOutPrint.println("Splitting server jar..");
                if (Utils.isJarCorrupted(minecraftSlim) || Utils.isJarCorrupted(minecraftExtra)) {
                    minecraftSlim.delete();
                    minecraftExtra.delete();
                }
                if (!minecraftSlim.exists() || !minecraftExtra.exists()) {
                    Utils.relaunch("net.minecraftforge.jarsplitter.ConsoleTool", libJarSplitter, new String[]{"--input", minecraftServer.getAbsolutePath(), "--slim", minecraftSlim.getAbsolutePath(), "--extra", minecraftExtra.getAbsolutePath(), "--srg", mcpMappings.getAbsolutePath()}, true);
                }
                logOutPrint.flush();
                originOutPrint.println("Remapping server jar..");
                if (Utils.isJarCorrupted(minecraftSrg)) {
                    minecraftSrg.delete();
                }
                if (!minecraftSrg.exists()) {
                    Utils.relaunch("net.md_5.specialsource.SpecialSource", libSpecialSource, new String[]{"--in-jar", minecraftSlim.getAbsolutePath(), "--out-jar", minecraftSrg.getAbsolutePath(), "--srg-in", mcpMappings.getAbsolutePath()}, true);
                }
                logOutPrint.flush();
                originOutPrint.println("Applying patches..");
                Utils.relaunch("net.minecraftforge.binarypatcher.ConsoleTool", libBinaryPatcher, new String[]{"--clean", minecraftSrg.getAbsolutePath(), "--output", forgeServerJar.getAbsolutePath(), "--apply", serverLZMA.getAbsolutePath()}, true);
                logOutPrint.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            System.setOut(originOutPrint);
        }
        throwable = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(installHASH)));){
            writer.write(Objects.requireNonNull(Utils.getFileSHA256(serverJar), serverJar.getName()) + Objects.requireNonNull(Utils.getFileSHA256(serverLZMA), serverLZMA.getName()));
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

