/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.StringSubstitutor;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public class ModInfo
implements IModInfo,
IConfigurable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DefaultArtifactVersion DEFAULT_VERSION = new DefaultArtifactVersion("1");
    private static final Pattern VALID_LABEL = Pattern.compile("^[a-z][a-z0-9_-]{1,63}$");
    private final ModFileInfo owningFile;
    private final String modId;
    private final String namespace;
    private final ArtifactVersion version;
    private final String displayName;
    private final String description;
    private final Optional<String> logoFile;
    private final boolean logoBlur;
    private final URL updateJSONURL;
    private final List<? extends IModInfo.ModVersion> dependencies;
    private final Map<String, Object> properties;
    private final IConfigurable config;

    public ModInfo(ModFileInfo owningFile, IConfigurable config) {
        Optional<ModFileInfo> ownFile = Optional.ofNullable(owningFile);
        this.owningFile = owningFile;
        this.config = config;
        this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing modId", owningFile));
        if (!VALID_LABEL.matcher(this.modId).matches()) {
            LOGGER.fatal("Invalid modId found in file {} - {} does not match the standard: {}", (Object)this.owningFile.getFile().getFilePath(), (Object)this.modId, (Object)VALID_LABEL.pattern());
            throw new InvalidModFileException("Invalid modId found : " + this.modId, owningFile);
        }
        this.namespace = config.getConfigElement(new String[]{"namespace"}).orElse(this.modId);
        if (!VALID_LABEL.matcher(this.namespace).matches()) {
            LOGGER.fatal("Invalid override namespace found in file {} - {} does not match the standard: {}", (Object)this.owningFile.getFile().getFilePath(), (Object)this.namespace, (Object)VALID_LABEL.pattern());
            throw new InvalidModFileException("Invalid override namespace found : " + this.namespace, owningFile);
        }
        this.version = (ArtifactVersion)config.getConfigElement(new String[]{"version"}).map(s -> StringSubstitutor.replace(s, ownFile.map(ModFileInfo::getFile).orElse(null))).map(DefaultArtifactVersion::new).orElse(DEFAULT_VERSION);
        this.displayName = config.getConfigElement(new String[]{"displayName"}).orElse(this.modId);
        this.description = config.getConfigElement(new String[]{"description"}).orElse("MISSING DESCRIPTION");
        this.logoFile = Optional.ofNullable(config.getConfigElement(new String[]{"logoFile"}).orElseGet(() -> ownFile.flatMap(mf -> mf.getConfigElement("logoFile")).orElse(null)));
        this.logoBlur = config.getConfigElement(new String[]{"logoBlur"}).orElseGet(() -> ownFile.flatMap(f -> f.getConfigElement("logoBlur")).orElse(true));
        this.updateJSONURL = config.getConfigElement(new String[]{"updateJSONURL"}).map(StringUtils::toURL).orElse(null);
        this.dependencies = ownFile.map(mfi -> mfi.getConfigList("dependencies", this.modId).stream().map(dep -> new ModVersion(this, (IConfigurable)dep)).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.properties = ownFile.map(mfi -> mfi.getConfigElement("modproperties", this.modId).orElse(Collections.emptyMap())).orElse(Collections.emptyMap());
    }

    public ModFileInfo getOwningFile() {
        return this.owningFile;
    }

    public String getModId() {
        return this.modId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public List<? extends IModInfo.ModVersion> getDependencies() {
        return this.dependencies;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getModProperties() {
        return this.properties;
    }

    public URL getUpdateURL() {
        return this.updateJSONURL;
    }

    public Optional<String> getLogoFile() {
        return this.logoFile;
    }

    public boolean getLogoBlur() {
        return this.logoBlur;
    }

    @Deprecated
    public boolean hasConfigUI() {
        return false;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return null;
    }

    class ModVersion
    implements IModInfo.ModVersion {
        private IModInfo owner;
        private final String modId;
        private final VersionRange versionRange;
        private final boolean mandatory;
        private final IModInfo.Ordering ordering;
        private final IModInfo.DependencySide side;

        public ModVersion(IModInfo owner, IConfigurable config) {
            this.owner = owner;
            this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing required field modid in dependency", ModInfo.this.getOwningFile()));
            this.mandatory = (Boolean)config.getConfigElement(new String[]{"mandatory"}).orElseThrow(() -> new InvalidModFileException("Missing required field mandatory in dependency", ModInfo.this.getOwningFile()));
            this.versionRange = config.getConfigElement(new String[]{"versionRange"}).map(MavenVersionAdapter::createFromVersionSpec).orElse(IModInfo.UNBOUNDED);
            this.ordering = config.getConfigElement(new String[]{"ordering"}).map(IModInfo.Ordering::valueOf).orElse(IModInfo.Ordering.NONE);
            this.side = config.getConfigElement(new String[]{"side"}).map(IModInfo.DependencySide::valueOf).orElse(IModInfo.DependencySide.BOTH);
        }

        public String getModId() {
            return this.modId;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public IModInfo.Ordering getOrdering() {
            return this.ordering;
        }

        public IModInfo.DependencySide getSide() {
            return this.side;
        }

        public void setOwner(IModInfo owner) {
            this.owner = owner;
        }

        public IModInfo getOwner() {
            return this.owner;
        }
    }
}

