/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.Descriptored;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.mappings.EntryTriple;

class MappingResolverImpl
implements MappingResolver {
    private final Supplier<TinyTree> mappingsSupplier;
    private final Set<String> namespaces;
    private final Map<String, NamespaceData> namespaceDataMap = new HashMap<String, NamespaceData>();
    private final String targetNamespace;

    MappingResolverImpl(Supplier<TinyTree> mappingsSupplier, String targetNamespace) {
        this.mappingsSupplier = mappingsSupplier;
        this.targetNamespace = targetNamespace;
        this.namespaces = Collections.unmodifiableSet(new HashSet(mappingsSupplier.get().getMetadata().getNamespaces()));
    }

    protected final NamespaceData getNamespaceData(String namespace) {
        return this.namespaceDataMap.computeIfAbsent(namespace, fromNamespace -> {
            if (!this.namespaces.contains(namespace)) {
                throw new IllegalArgumentException("Unknown namespace: " + namespace);
            }
            NamespaceData data = new NamespaceData();
            TinyTree mappings = this.mappingsSupplier.get();
            HashMap<String, String> classNameMap = new HashMap<String, String>();
            for (ClassDef classEntry : mappings.getClasses()) {
                String fromClass = this.mapClassName(classNameMap, classEntry.getName(fromNamespace));
                String toClass = this.mapClassName(classNameMap, classEntry.getName(this.targetNamespace));
                data.classNames.put(fromClass, toClass);
                data.classNamesInverse.put(toClass, fromClass);
                String mappedClassName = this.mapClassName(classNameMap, fromClass);
                this.recordMember((String)fromNamespace, classEntry.getFields(), data.fieldNames, mappedClassName);
                this.recordMember((String)fromNamespace, classEntry.getMethods(), data.methodNames, mappedClassName);
            }
            return data;
        });
    }

    private static String replaceSlashesWithDots(String cname) {
        return cname.replace('/', '.');
    }

    private String mapClassName(Map<String, String> classNameMap, String s) {
        return classNameMap.computeIfAbsent(s, MappingResolverImpl::replaceSlashesWithDots);
    }

    private <T extends Descriptored> void recordMember(String fromNamespace, Collection<T> descriptoredList, Map<EntryTriple, String> putInto, String fromClass) {
        for (Descriptored descriptored : descriptoredList) {
            EntryTriple fromEntry = new EntryTriple(fromClass, descriptored.getName(fromNamespace), descriptored.getDescriptor(fromNamespace));
            putInto.put(fromEntry, descriptored.getName(this.targetNamespace));
        }
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getCurrentRuntimeNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String mapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return this.getNamespaceData(namespace).classNames.getOrDefault(className, className);
    }

    @Override
    public String unmapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return this.getNamespaceData(namespace).classNamesInverse.getOrDefault(className, className);
    }

    @Override
    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        return this.getNamespaceData(namespace).fieldNames.getOrDefault(new EntryTriple(owner, name, descriptor), name);
    }

    @Override
    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        return this.getNamespaceData(namespace).methodNames.getOrDefault(new EntryTriple(owner, name, descriptor), name);
    }

    private static class NamespaceData {
        private final Map<String, String> classNames = new HashMap<String, String>();
        private final Map<String, String> classNamesInverse = new HashMap<String, String>();
        private final Map<EntryTriple, String> fieldNames = new HashMap<EntryTriple, String>();
        private final Map<EntryTriple, String> methodNames = new HashMap<EntryTriple, String>();

        private NamespaceData() {
        }
    }
}

