/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerItemWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerRegistryWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithFluidHandler(adz stack, IFluidHandler fluidHandler, zs player) {
        if (stack == null || fluidHandler == null || player == null) {
            return false;
        }
        InvWrapper playerInventory = new InvWrapper((ql)player.bt);
        return FluidUtil.tryFillContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player) || FluidUtil.tryEmptyContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
    }

    public static adz tryFillContainer(adz container, IFluidHandler fluidSource, int maxAmount, @Nullable zs player, boolean doFill) {
        FluidStack simulatedTransfer;
        container = container.k();
        container.b = 1;
        IFluidHandler containerFluidHandler = FluidUtil.getFluidHandler(container);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    ni soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.a(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            return container;
        }
        return null;
    }

    @Nullable
    public static adz tryEmptyContainer(adz container, IFluidHandler fluidDestination, int maxAmount, @Nullable zs player, boolean doDrain) {
        FluidStack simulatedTransfer;
        container = container.k();
        container.b = 1;
        IFluidHandler containerFluidHandler = FluidUtil.getFluidHandler(container);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, false)) != null) {
            if (doDrain) {
                FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, true);
                if (player != null) {
                    ni soundevent = simulatedTransfer.getFluid().getEmptySound(simulatedTransfer);
                    player.a(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.drain(simulatedTransfer, true);
            }
            return container;
        }
        return null;
    }

    public static boolean tryFillContainerAndStow(adz container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable zs player) {
        if (container == null || container.b < 1) {
            return false;
        }
        if (player != null && player.bL.d) {
            adz filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal != null) {
                return true;
            }
        } else if (container.b == 1) {
            adz filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal != null) {
                container.deserializeNBT(filledReal.serializeNBT());
                return true;
            }
        } else {
            adz remainder;
            adz filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated != null && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated, true)) == null || player != null)) {
                adz filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal, false);
                if (remainder != null && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                --container.b;
                return true;
            }
        }
        return false;
    }

    public static boolean tryEmptyContainerAndStow(adz container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable zs player) {
        if (container == null || container.b < 1) {
            return false;
        }
        if (player != null && player.bL.d) {
            adz emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal != null) {
                return true;
            }
        } else if (container.b == 1) {
            adz emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal != null) {
                if (emptiedReal.b <= 0) {
                    --container.b;
                } else {
                    container.deserializeNBT(emptiedReal.serializeNBT());
                }
                return true;
            }
        } else {
            adz emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated != null) {
                if (emptiedSimulated.b <= 0) {
                    FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
                    --container.b;
                    return true;
                }
                adz remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated, true);
                if (remainder == null || player != null) {
                    adz emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
                    remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal, false);
                    if (remainder != null && player != null) {
                        ItemHandlerHelper.giveItemToPlayer(player, remainder);
                    }
                    --container.b;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drained;
        int fillableAmount;
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0 && (fillableAmount = fluidDestination.fill(drainable, false)) > 0 && (drained = fluidSource.drain(fillableAmount, doTransfer)) != null) {
            drained.amount = fluidDestination.fill(drained, doTransfer);
            return drained;
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(adz itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        adx item = itemStack.b();
        if (item instanceof IFluidContainerItem) {
            return new FluidContainerItemWrapper((IFluidContainerItem)item, itemStack);
        }
        if (FluidContainerRegistry.isContainer(itemStack)) {
            return new FluidContainerRegistryWrapper(itemStack);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(adz container) {
        if (container != null) {
            container = container.k();
            container.b = 1;
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler(container);
            if (fluidHandler != null) {
                return fluidHandler.drain(Integer.MAX_VALUE, false);
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(aid world, cm blockPos, @Nullable ct side) {
        ars state = world.o(blockPos);
        akf block = state.t();
        if (block.hasTileEntity(state)) {
            aqk tileEntity = world.r(blockPos);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            }
        } else {
            if (block instanceof IFluidBlock) {
                return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
            }
            if (block instanceof anb) {
                return new BlockLiquidWrapper((anb)block, world, blockPos);
            }
        }
        return null;
    }

    public static boolean tryPlaceFluid(@Nullable zs player, aid worldIn, FluidStack fluidStack, cm pos) {
        if (worldIn == null || fluidStack == null || pos == null) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return false;
        }
        ars destBlockState = worldIn.o(pos);
        axx destMaterial = destBlockState.a();
        boolean isDestNonSolid = !destMaterial.a();
        boolean isDestReplaceable = destBlockState.t().a((aih)worldIn, pos);
        if (!(worldIn.d(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (worldIn.s.l() && fluid.doesVaporize(fluidStack)) {
            fluid.vaporize(player, worldIn, pos, fluidStack);
        } else {
            if (!worldIn.E && (isDestNonSolid || isDestReplaceable) && !destMaterial.d()) {
                worldIn.b(pos, true);
            }
            ni soundevent = fluid.getEmptySound(fluidStack);
            worldIn.a(player, pos, soundevent, nk.e, 1.0f, 1.0f);
            ars fluidBlockState = fluid.getBlock().u();
            worldIn.a(pos, fluidBlockState, 11);
        }
        return true;
    }

    @Nullable
    public static adz tryPickUpFluid(adz emptyContainer, @Nullable zs playerIn, aid worldIn, cm pos, ct side) {
        IFluidHandler targetFluidHandler;
        if (emptyContainer == null || worldIn == null || pos == null) {
            return null;
        }
        ars state = worldIn.o(pos);
        akf block = state.t();
        if ((block instanceof IFluidBlock || block instanceof anb) && (targetFluidHandler = FluidUtil.getFluidHandler(worldIn, pos, side)) != null) {
            return FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
        }
        return null;
    }

    @Deprecated
    public static boolean interactWithTank(adz stack, zs player, net.minecraftforge.fluids.IFluidHandler tank, ct side) {
        FluidHandlerWrapper fluidHandler = new FluidHandlerWrapper(tank, side);
        return FluidUtil.interactWithFluidHandler(stack, fluidHandler, player);
    }

    @Deprecated
    public static adz tryFillBucket(adz bucket, net.minecraftforge.fluids.IFluidHandler tank, ct side) {
        return FluidUtil.tryFillBucket(bucket, tank, side, null);
    }

    @Deprecated
    public static adz tryFillBucket(adz bucket, net.minecraftforge.fluids.IFluidHandler tank, ct side, zs player) {
        FluidHandlerWrapper newFluidHandler = new FluidHandlerWrapper(tank, side);
        return FluidUtil.tryFillContainer(bucket, newFluidHandler, 1000, player, true);
    }

    @Deprecated
    public static adz tryEmptyBucket(adz bucket, net.minecraftforge.fluids.IFluidHandler tank, ct side) {
        return FluidUtil.tryEmptyBucket(bucket, tank, side, null);
    }

    @Deprecated
    public static adz tryEmptyBucket(adz bucket, net.minecraftforge.fluids.IFluidHandler tank, ct side, zs player) {
        FluidHandlerWrapper destination = new FluidHandlerWrapper(tank, side);
        return FluidUtil.tryEmptyContainer(bucket, destination, 1000, player, true);
    }

    @Deprecated
    public static boolean tryFillFluidContainerItem(adz container, net.minecraftforge.fluids.IFluidHandler tank, ct side, zs player) {
        return FluidUtil.tryFillFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.bt), -1, player);
    }

    @Deprecated
    public static boolean tryEmptyFluidContainerItem(adz container, net.minecraftforge.fluids.IFluidHandler tank, ct side, zs player) {
        return FluidUtil.tryEmptyFluidContainerItem(container, tank, side, new PlayerMainInvWrapper(player.bt), -1, player);
    }

    @Deprecated
    public static boolean tryFillFluidContainerItem(adz container, net.minecraftforge.fluids.IFluidHandler tank, ct side, IItemHandler inventory, int max, @Nullable zs player) {
        FluidStack liquid;
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            return false;
        }
        if (max <= 0) {
            max = fluidContainer.getCapacity(container);
        }
        if ((liquid = tank.drain(side, max, false)) != null && liquid.amount > 0) {
            if (container.b > 1) {
                adz toFill = container.k();
                toFill.b = 1;
                int filled = fluidContainer.fill(toFill, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(toFill, liquid, true);
                if (player == null || !player.l.E) {
                    adz remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, true);
                    if (remainder != null && player == null) {
                        return false;
                    }
                    remainder = ItemHandlerHelper.insertItemStacked(inventory, toFill, false);
                    if (remainder != null && player != null) {
                        ItemHandlerHelper.giveItemToPlayer(player, remainder);
                    }
                }
                tank.drain(side, filled, true);
                --container.b;
            } else {
                int filled = fluidContainer.fill(container, liquid, false);
                if (filled <= 0) {
                    return false;
                }
                filled = fluidContainer.fill(container, liquid, true);
                tank.drain(side, filled, true);
            }
            if (player != null) {
                ni soundevent = liquid.getFluid().getFillSound(liquid);
                player.a(soundevent, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean tryEmptyFluidContainerItem(adz container, net.minecraftforge.fluids.IFluidHandler tank, ct side, IItemHandler inventory, int max, zs player) {
        if (!(container.b() instanceof IFluidContainerItem)) {
            return false;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)container.b();
        if (fluidContainer.getFluid(container) != null) {
            int filled;
            FluidStack drained;
            if (max <= 0) {
                max = fluidContainer.getCapacity(container);
            }
            if ((drained = fluidContainer.drain(container, max, false)) != null && tank.canFill(side, drained.getFluid()) && (filled = tank.fill(side, drained, false)) > 0 && (drained = fluidContainer.drain(container, filled, false)) != null && drained.amount == filled) {
                if (container.b > 1) {
                    adz toEmpty = container.k();
                    toEmpty.b = 1;
                    drained = fluidContainer.drain(toEmpty, filled, true);
                    if (player == null || !player.l.E) {
                        adz remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, true);
                        if (remainder != null && player == null) {
                            return false;
                        }
                        remainder = ItemHandlerHelper.insertItemStacked(inventory, toEmpty, false);
                        if (remainder != null && player != null) {
                            ItemHandlerHelper.giveItemToPlayer(player, remainder);
                        }
                    }
                    tank.fill(side, drained, true);
                    --container.b;
                } else {
                    drained = fluidContainer.drain(container, filled, true);
                    tank.fill(side, drained, true);
                }
                if (player != null) {
                    ni soundevent = drained.getFluid().getEmptySound(drained);
                    player.a(soundevent, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }
}

