/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.templates;

import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerItemStackSimple
implements IFluidHandler,
ICapabilityProvider {
    public static final String FLUID_NBT_KEY = "Fluid";
    protected final adz container;
    protected final int capacity;

    public FluidHandlerItemStackSimple(adz container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        dr tagCompound = this.container.o();
        if (tagCompound == null || !tagCompound.e(FLUID_NBT_KEY)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT(tagCompound.o(FLUID_NBT_KEY));
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.n()) {
            this.container.d(new dr());
        }
        dr fluidTag = new dr();
        fluid.writeToNBT(fluidTag);
        this.container.o().a(FLUID_NBT_KEY, (ef)fluidTag);
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        int fillAmount;
        if (this.container.b != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null && (fillAmount = Math.min(this.capacity, resource.amount)) == this.capacity) {
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.b != 1 || resource == null || resource.amount <= 0 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.b != 1 || maxDrain <= 0) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = Math.min(contained.amount, maxDrain);
        if (drainAmount == this.capacity) {
            FluidStack drained = contained.copy();
            if (doDrain) {
                this.setContainerToEmpty();
            }
            return drained;
        }
        return null;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container.o().q(FLUID_NBT_KEY);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, ct facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, ct facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
    }

    public static class SwapEmpty
    extends FluidHandlerItemStackSimple {
        protected final adz emptyContainer;

        public SwapEmpty(adz container, adz emptyContainer, int capacity) {
            super(container, capacity);
            this.emptyContainer = emptyContainer;
        }

        @Override
        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container.deserializeNBT(this.emptyContainer.serializeNBT());
        }
    }

    public static class Consumable
    extends FluidHandlerItemStackSimple {
        public Consumable(adz container, int capacity) {
            super(container, capacity);
        }

        @Override
        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            --this.container.b;
        }
    }
}

