/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.FinalFieldHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final kn BLOCK_TO_ITEM = new kn("minecraft:blocktoitemmap");
    private static final kn BLOCKSTATE_TO_ID = new kn("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private static Field blockField;
    private final FMLControlledNamespacedRegistry<akf> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, akf.class, new kn("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<adx> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, adx.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<rp> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, rp.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<aiq> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, aiq.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<ni> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, ni.class, null, 0, 0x3FFFFFF, false, null, null, null, null);
    private final FMLControlledNamespacedRegistry<afn> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<agv> iEnchantmentRegistry;

    public GameData() {
        kn WATER = new kn("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, afn.class, WATER, 0, 0x3FFFFFF, false, null, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, agv.class, null, 0, 32766, false, null, null, null, null);
        try {
            blockField = FinalFieldHelper.makeWritable(ReflectionHelper.findField(acl.class, "block", "field_150939_a"));
        }
        catch (Exception e2) {
            FMLLog.log(Level.FATAL, e2, "Cannot access the 'block' field from ItemBlock, this is fatal!", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<akf> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<adx> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<rp> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<aiq> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<ni> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<afn> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<agv> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    static adx findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kn(modId, name));
    }

    @Deprecated
    static akf findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kn(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    @Deprecated
    int registerItem(adx item, String name) {
        return this.iItemRegistry.add(-1, this.addPrefix(name), item);
    }

    @Deprecated
    int registerBlock(akf block, String name) {
        return this.iBlockRegistry.add(-1, this.addPrefix(name), block);
    }

    private kn addPrefix(String name) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String prefix = mc != null ? mc.getModId().toLowerCase() : "minecraft";
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.bigWarning("Dangerous alternative prefix %s for name %s, invalid registry invocation/invalid name?", prefix, name);
            prefix = oldPrefix;
        }
        return new kn(prefix, name);
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kn nameToSubstitute = new kn(name);
        BiMap<akf, adx> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (akf)toReplace);
            this.iBlockRegistry.activateSubstitution(nameToSubstitute);
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (adx)toReplace);
            this.iItemRegistry.activateSubstitution(nameToSubstitute);
        }
    }

    public static BiMap<akf, adx> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, kn location) {
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static cw<ars> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, cw.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<aiq>,
    IForgeRegistry.ClearCallback<aiq>,
    IForgeRegistry.CreateCallback<aiq> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(aiq biome, int id, Map<kn, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<aiq> registry, Map<kn, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset, BiMap<kn, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<rp>,
    IForgeRegistry.ClearCallback<rp>,
    IForgeRegistry.CreateCallback<rp> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(rp potion, int id, Map<kn, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<rp> registry, Map<kn, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset, BiMap<kn, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<adx>,
    IForgeRegistry.ClearCallback<adx>,
    IForgeRegistry.CreateCallback<adx>,
    IForgeRegistry.SubstitutionCallback<adx> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(adx item, int blockId, Map<kn, ?> slaves) {
            if (item instanceof acl) {
                acl itemBlock = (acl)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                akf block = (akf)itemBlock.d().delegate.get();
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistry<adx> registry, Map<kn, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset, BiMap<kn, ? extends IForgeRegistry<?>> registries) {
            BiMap blockItemMap = ((IForgeRegistry)registries.get((Object)PersistentRegistryManager.BLOCKS)).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            slaveset.put(BLOCK_TO_ITEM, blockItemMap);
        }

        @Override
        public void onSubstituteActivated(Map<kn, ?> slaveset, adx original, adx replacement, kn name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<akf>,
    IForgeRegistry.ClearCallback<akf>,
    IForgeRegistry.CreateCallback<akf>,
    IForgeRegistry.SubstitutionCallback<akf> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(akf block, int blockId, Map<kn, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaves.get(BLOCKSTATE_TO_ID));
            boolean[] usedMeta = new boolean[16];
            for (ars state : block.t().a()) {
                int meta = block.e(state);
                blockstateMap.a(state, blockId << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (!usedMeta[meta]) continue;
                blockstateMap.a(block.a(meta), blockId << 4 | meta);
            }
        }

        @Override
        public void onClear(IForgeRegistry<akf> registry, Map<kn, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaveset.get(BLOCKSTATE_TO_ID));
            blockstateMap.clear();
            Map originals = (Map)slaveset.get(PersistentRegistryManager.SUBSTITUTION_ORIGINALS);
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            for (adx it2 : blockItemMap.values()) {
                if (!(it2 instanceof acl)) continue;
                acl itemBlock = (acl)it2;
                kn registryKey = registry.getKey(itemBlock.a);
                if (!originals.containsKey(registryKey)) continue;
                try {
                    FinalFieldHelper.setField(blockField, itemBlock, originals.get(registryKey));
                }
                catch (Exception e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset, BiMap<kn, ? extends IForgeRegistry<?>> registries) {
            ClearableObjectIntIdentityMap<ars> idMap = new ClearableObjectIntIdentityMap<ars>(){

                public int get(ars key) {
                    Integer integer = (Integer)this.a.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.a.get(key.t().a(key.t().e(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }

        @Override
        public void onSubstituteActivated(Map<kn, ?> slaveset, akf original, akf replacement, kn name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            if (blockItemMap.containsKey((Object)original)) {
                adx i = (adx)blockItemMap.get((Object)original);
                if (i instanceof acl) {
                    try {
                        FinalFieldHelper.setField(blockField, i, replacement);
                    }
                    catch (Exception e2) {
                        throw Throwables.propagate((Throwable)e2);
                    }
                }
                blockItemMap.forcePut((Object)replacement, (Object)i);
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends cw<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

