/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenEvent
extends Event {
    private final bft gui;

    public GuiScreenEvent(bft gui) {
        this.gui = gui;
    }

    public bft getGui() {
        return this.gui;
    }

    public static class KeyboardInputEvent
    extends GuiScreenEvent {
        public KeyboardInputEvent(bft gui) {
            super(gui);
        }

        public static class Post
        extends KeyboardInputEvent {
            public Post(bft gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardInputEvent {
            public Pre(bft gui) {
                super(gui);
            }
        }
    }

    public static class MouseInputEvent
    extends GuiScreenEvent {
        public MouseInputEvent(bft gui) {
            super(gui);
        }

        public static class Post
        extends MouseInputEvent {
            public Post(bft gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseInputEvent {
            public Pre(bft gui) {
                super(gui);
            }
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private bdr button;
        private List<bdr> buttonList;

        public ActionPerformedEvent(bft gui, bdr button, List<bdr> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<bdr>(buttonList));
        }

        public bdr getButton() {
            return this.button;
        }

        public void setButton(bdr button) {
            this.button = button;
        }

        public List<bdr> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bdr> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(bft gui, bdr button, List<bdr> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(bft gui, bdr button, List<bdr> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(bft gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;

        public BackgroundDrawnEvent(bft gui) {
            super(gui);
            bdp scaledresolution = new bdp(gui.j);
            int scaledWidth = scaledresolution.a();
            int scaledHeight = scaledresolution.b();
            this.mouseX = Mouse.getX() * scaledWidth / gui.j.d;
            this.mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.j.e - 1;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(bft gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(bft gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(bft gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private List<bdr> buttonList;

        public InitGuiEvent(bft gui, List<bdr> buttonList) {
            super(gui);
            this.setButtonList(buttonList);
        }

        public List<bdr> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bdr> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends InitGuiEvent {
            public Post(bft gui, List<bdr> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(bft gui, List<bdr> buttonList) {
                super(gui, buttonList);
            }
        }
    }
}

