/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    public static final int BUCKET_VOLUME = 1000;
    protected final String fluidName;
    protected String unlocalizedName;
    protected final kn still;
    protected final kn flowing;
    private ni fillSound;
    private ni emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected aen rarity = aen.a;
    protected akf block = null;

    public Fluid(String fluidName, kn still, kn flowing) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(akf block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to the Block " + this.block + ". You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", new Object[0]);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(aen rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(ni fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(ni emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final akf getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.u().a() == axx.h;
    }

    public void vaporize(@Nullable zs player, aid worldIn, cm pos, FluidStack fluidStack) {
        worldIn.a(player, pos, nj.bx, nk.e, 0.5f, 2.6f + (worldIn.r.nextFloat() - worldIn.r.nextFloat()) * 0.8f);
        for (int l2 = 0; l2 < 8; ++l2) {
            worldIn.a(db.m, (double)pos.p() + Math.random(), (double)pos.q() + Math.random(), (double)pos.r() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : dl.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public aen getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return -1;
    }

    public kn getStill() {
        return this.still;
    }

    public kn getFlowing() {
        return this.flowing;
    }

    public ni getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().u().a() == axx.i ? nj.O : nj.N;
        }
        return this.fillSound;
    }

    public ni getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().u().a() == axx.i ? nj.M : nj.L;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public aen getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public kn getStill(FluidStack stack) {
        return this.getStill();
    }

    public kn getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public ni getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public ni getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(aid world, cm pos) {
        return this.getLuminosity();
    }

    public int getDensity(aid world, cm pos) {
        return this.getDensity();
    }

    public int getTemperature(aid world, cm pos) {
        return this.getTemperature();
    }

    public int getViscosity(aid world, cm pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(aid world, cm pos) {
        return this.isGaseous();
    }

    public aen getRarity(aid world, cm pos) {
        return this.getRarity();
    }

    public int getColor(aid world, cm pos) {
        return this.getColor();
    }

    public kn getStill(aid world, cm pos) {
        return this.getStill();
    }

    public kn getFlowing(aid world, cm pos) {
        return this.getFlowing();
    }

    public ni getFillSound(aid world, cm pos) {
        return this.getFillSound();
    }

    public ni getEmptySound(aid world, cm pos) {
        return this.getEmptySound();
    }
}

