/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public final class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void modPreinitialization(FMLPreInitializationEvent evt) {
        if (ForgeRegistries.ITEMS == null) {
            throw new RuntimeException("Something horrible went wrong in init, ForgeRegistres didn't create...");
        }
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dr getDataForWriting(azy handler, baa info) {
        dr fmlData = new dr();
        dx modList = new dx();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dr mod = new dr();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            modList.a((ef)mod);
        }
        fmlData.a("ModList", (ef)modList);
        dr registries = new dr();
        fmlData.a("Registries", (ef)registries);
        FMLLog.fine("Gathering id map for writing to world save %s", info.j());
        PersistentRegistryManager.GameDataSnapshot dataSnapshot = PersistentRegistryManager.takeSnapshot();
        for (Map.Entry<kn, PersistentRegistryManager.GameDataSnapshot.Entry> e : dataSnapshot.entries.entrySet()) {
            Object entry3;
            dr data = new dr();
            registries.a(e.getKey().toString(), (ef)data);
            dx ids = new dx();
            for (Map.Entry<kn, Integer> entry2 : e.getValue().ids.entrySet()) {
                dr tag = new dr();
                tag.a("K", entry2.getKey().toString());
                tag.a("V", entry2.getValue().intValue());
                ids.a((ef)tag);
            }
            data.a("ids", (ef)ids);
            dx aliases = new dx();
            for (Object entry3 : e.getValue().aliases.entrySet()) {
                dr tag = new dr();
                tag.a("K", entry3.getKey().toString());
                tag.a("V", ((kn)entry3.getValue()).toString());
                aliases.a((ef)tag);
            }
            data.a("aliases", (ef)aliases);
            dx dx2 = new dx();
            entry3 = e.getValue().substitutions.iterator();
            while (entry3.hasNext()) {
                kn entry4 = (kn)entry3.next();
                dr tag = new dr();
                tag.a("K", entry4.toString());
                dx2.a((ef)tag);
            }
            data.a("substitutions", (ef)dx2);
            int[] blocked = new int[e.getValue().blocked.size()];
            int idx = 0;
            for (Integer i : e.getValue().blocked) {
                blocked[idx++] = i;
            }
            data.a("blocked", blocked);
            dx dummied = new dx();
            for (kn entry5 : e.getValue().dummied) {
                dr tag = new dr();
                tag.a("K", entry5.toString());
                dummied.a((ef)tag);
            }
            data.a("dummied", (ef)dummied);
        }
        return fmlData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readData(azy handler, baa info, Map<String, ef> propertyMap, dr tag) {
        if (tag.e("ModList")) {
            dx modList = tag.c("ModList", 10);
            for (int i = 0; i < modList.c(); ++i) {
                dr mod = modList.b(i);
                String modId = mod.l("ModId");
                String modVersion = mod.l("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.e("ModItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.e("ItemData")) {
            void var11_22;
            void var11_18;
            if (!tag.e("BlockedItemIds")) {
                StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
                StartupQuery.abort();
            }
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            PersistentRegistryManager.GameDataSnapshot.Entry blocks = new PersistentRegistryManager.GameDataSnapshot.Entry();
            PersistentRegistryManager.GameDataSnapshot.Entry items = new PersistentRegistryManager.GameDataSnapshot.Entry();
            snapshot.entries.put(PersistentRegistryManager.BLOCKS, blocks);
            snapshot.entries.put(PersistentRegistryManager.ITEMS, items);
            dx list = tag.c("ItemData", 10);
            for (int i2 = 0; i2 < list.c(); ++i2) {
                dr dr2 = list.b(i2);
                String name = dr2.l("K");
                if (name.charAt(0) == '\u0001') {
                    blocks.ids.put(new kn(name.substring(1)), dr2.h("V"));
                    continue;
                }
                if (name.charAt(0) != '\u0002') continue;
                items.ids.put(new kn(name.substring(1)), dr2.h("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            for (int id : tag.n("BlockedItemIds")) {
                blockedIds.add(id);
            }
            blocks.blocked.addAll(blockedIds);
            items.blocked.addAll(blockedIds);
            list = tag.c("BlockAliases", 10);
            boolean bl = false;
            while (var11_18 < list.c()) {
                dr dataTag = list.b((int)var11_18);
                blocks.aliases.put(new kn(dataTag.l("K")), new kn(dataTag.l("V")));
                ++var11_18;
            }
            if (tag.b("BlockSubstitutions", 9)) {
                void var11_20;
                list = tag.c("BlockSubstitutions", 10);
                boolean bl2 = false;
                while (var11_20 < list.c()) {
                    dr dataTag = list.b((int)var11_20);
                    blocks.substitutions.add(new kn(dataTag.l("K")));
                    ++var11_20;
                }
            }
            list = tag.c("ItemAliases", 10);
            boolean bl3 = false;
            while (var11_22 < list.c()) {
                dr dataTag = list.b((int)var11_22);
                items.aliases.put(new kn(dataTag.l("K")), new kn(dataTag.l("V")));
                ++var11_22;
            }
            if (tag.b("ItemSubstitutions", 9)) {
                void var11_24;
                list = tag.c("ItemSubstitutions", 10);
                boolean bl4 = false;
                while (var11_24 < list.c()) {
                    dr dataTag = list.b((int)var11_24);
                    items.substitutions.add(new kn(dataTag.l("K")));
                    ++var11_24;
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        } else if (tag.e("Registries")) {
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            dr regs = tag.o("Registries");
            for (String key : regs.c()) {
                int[] blocked;
                int x;
                void var11_25;
                PersistentRegistryManager.GameDataSnapshot.Entry entry = new PersistentRegistryManager.GameDataSnapshot.Entry();
                if ("fml:blocks".equals(key)) {
                    kn kn2 = PersistentRegistryManager.BLOCKS;
                } else if ("fml:items".equals(key)) {
                    kn kn3 = PersistentRegistryManager.ITEMS;
                } else if ("fmlgr:villagerprofessions".equals(key)) {
                    kn kn4 = VillagerRegistry.PROFESSIONS;
                } else {
                    kn kn5 = new kn(key);
                }
                snapshot.entries.put((kn)var11_25, entry);
                dx list = regs.o(key).c("ids", 10);
                for (x = 0; x < list.c(); ++x) {
                    dr e3 = list.b(x);
                    entry.ids.put(new kn(e3.l("K")), e3.h("V"));
                }
                list = regs.o(key).c("aliases", 10);
                for (x = 0; x < list.c(); ++x) {
                    dr e4 = list.b(x);
                    entry.aliases.put(new kn(e4.l("K")), new kn(e4.l("V")));
                }
                list = regs.o(key).c("substitutions", 10);
                for (x = 0; x < list.c(); ++x) {
                    dr e5 = list.b(x);
                    entry.substitutions.add(new kn(e5.l("K")));
                }
                for (int i : blocked = regs.o(key).n("blocked")) {
                    entry.blocked.add(i);
                }
                if (!regs.o(key).e("dummied")) continue;
                list = regs.o(key).c("dummied", 10);
                for (int x2 = 0; x2 < list.c(); ++x2) {
                    dr e6 = list.b(x2);
                    entry.dummied.add(new kn(e6.l("K")));
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

