/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.patcher;

import LZMA.LzmaInputStream;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.patcher.ClassPatch;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.repackage.com.nothome.delta.GDiffPatcher;
import org.apache.logging.log4j.Level;

public class ClassPatchManager {
    public static final ClassPatchManager INSTANCE = new ClassPatchManager();
    public static final boolean dumpPatched = Boolean.parseBoolean(System.getProperty("fml.dumpPatchedClasses", "false"));
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugClassPatchManager", "false"));
    private GDiffPatcher patcher = new GDiffPatcher();
    private ListMultimap<String, ClassPatch> patches;
    private Map<String, byte[]> patchedClasses = Maps.newHashMap();
    private File tempDir;

    private ClassPatchManager() {
        if (dumpPatched) {
            this.tempDir = Files.createTempDir();
            FMLRelaunchLog.info("Dumping patched classes to %s", this.tempDir.getAbsolutePath());
        }
    }

    public byte[] getPatchedResource(String name, String mappedName, LaunchClassLoader loader) throws IOException {
        byte[] rawClassBytes = loader.getClassBytes(name);
        return this.applyPatch(name, mappedName, rawClassBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] applyPatch(String name, String mappedName, byte[] inputData) {
        if (this.patches == null) {
            return inputData;
        }
        if (this.patchedClasses.containsKey(name)) {
            return this.patchedClasses.get(name);
        }
        List list = this.patches.get((Object)name);
        if (list.isEmpty()) {
            return inputData;
        }
        boolean ignoredError = false;
        if (DEBUG) {
            FMLRelaunchLog.fine("Runtime patching class %s (input size %d), found %d patch%s", mappedName, inputData == null ? 0 : inputData.length, list.size(), list.size() != 1 ? "es" : "");
        }
        for (ClassPatch patch : list) {
            if (!patch.targetClassName.equals(mappedName) && !patch.sourceClassName.equals(name)) {
                FMLRelaunchLog.warning("Binary patch found %s for wrong class %s", patch.targetClassName, mappedName);
            }
            if (!(patch.existsAtTarget || inputData != null && inputData.length != 0)) {
                inputData = new byte[]{};
            } else if (!patch.existsAtTarget) {
                FMLRelaunchLog.warning("Patcher expecting empty class data file for %s, but received non-empty", patch.targetClassName);
            } else {
                if (patch.existsAtTarget && (inputData == null || inputData.length == 0)) {
                    FMLRelaunchLog.severe("Patcher expecting non-empty class data file for %s, but received empty.", patch.targetClassName);
                    throw new RuntimeException(String.format("Patcher expecting non-empty class data file for %s, but received empty, your vanilla jar may be corrupt.", patch.targetClassName));
                }
                int inputChecksum = Hashing.adler32().hashBytes(inputData).asInt();
                if (patch.inputChecksum != inputChecksum) {
                    FMLRelaunchLog.severe("There is a binary discrepancy between the expected input class %s (%s) and the actual class. Checksum on disk is %x, in patch %x. Things are probably about to go very wrong. Did you put something into the jar file?", mappedName, name, inputChecksum, patch.inputChecksum);
                    if (!Boolean.parseBoolean(System.getProperty("fml.ignorePatchDiscrepancies", "false"))) {
                        FMLRelaunchLog.severe("The game is going to exit, because this is a critical error, and it is very improbable that the modded game will work, please obtain clean jar files.", new Object[0]);
                        System.exit(1);
                    } else {
                        FMLRelaunchLog.severe("FML is going to ignore this error, note that the patch will not be applied, and there is likely to be a malfunctioning behaviour, including not running at all", new Object[0]);
                        ignoredError = true;
                        continue;
                    }
                }
            }
            GDiffPatcher gDiffPatcher = this.patcher;
            synchronized (gDiffPatcher) {
                try {
                    inputData = this.patcher.patch(inputData, patch.patch);
                }
                catch (IOException e2) {
                    FMLRelaunchLog.log(Level.ERROR, e2, "Encountered problem runtime patching class %s", name);
                }
            }
        }
        if (!ignoredError && DEBUG) {
            FMLRelaunchLog.fine("Successfully applied runtime patches for %s (new size %d)", mappedName, inputData.length);
        }
        if (dumpPatched) {
            try {
                Files.write((byte[])inputData, (File)new File(this.tempDir, mappedName));
            }
            catch (IOException e3) {
                FMLRelaunchLog.log(Level.ERROR, e3, "Failed to write %s to %s", mappedName, this.tempDir.getAbsolutePath());
            }
        }
        this.patchedClasses.put(name, inputData);
        return inputData;
    }

    public void setup(Side side) {
        JarInputStream jis;
        Pattern binpatchMatcher = Pattern.compile(String.format("binpatch/%s/.*.binpatch", side.toString().toLowerCase(Locale.ENGLISH)));
        try {
            InputStream binpatchesCompressed = this.getClass().getResourceAsStream("/binpatches.pack.lzma");
            if (binpatchesCompressed == null) {
                FMLRelaunchLog.log(Level.ERROR, "The binary patch set is missing. Either you are in a development environment, or things are not going to work!", new Object[0]);
                return;
            }
            LzmaInputStream binpatchesDecompressed = new LzmaInputStream(binpatchesCompressed);
            ByteArrayOutputStream jarBytes = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream(jarBytes);
            Pack200.newUnpacker().unpack((InputStream)binpatchesDecompressed, jos);
            jis = new JarInputStream(new ByteArrayInputStream(jarBytes.toByteArray()));
        }
        catch (Exception e2) {
            FMLRelaunchLog.log(Level.ERROR, e2, "Error occurred reading binary patches. Expect severe problems!", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
        this.patches = ArrayListMultimap.create();
        while (true) {
            try {
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (binpatchMatcher.matcher(entry.getName()).matches()) {
                        ClassPatch cp = this.readPatch(entry, jis);
                        if (cp == null) continue;
                        this.patches.put((Object)cp.sourceClassName, (Object)cp);
                        continue;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        FMLRelaunchLog.fine("Read %d binary patches", this.patches.size());
        if (DEBUG) {
            FMLRelaunchLog.fine("Patch list :\n\t%s", Joiner.on((String)"\t\n").join(this.patches.asMap().entrySet()));
        }
        this.patchedClasses.clear();
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) {
        ByteArrayDataInput input;
        if (DEBUG) {
            FMLRelaunchLog.finer("Reading patch data from %s", patchEntry.getName());
        }
        try {
            input = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        }
        catch (IOException e2) {
            FMLRelaunchLog.log(Level.WARN, e2, "Unable to read binpatch file %s - ignoring", patchEntry.getName());
            return null;
        }
        String name = input.readUTF();
        String sourceClassName = input.readUTF();
        String targetClassName = input.readUTF();
        boolean exists = input.readBoolean();
        int inputChecksum = 0;
        if (exists) {
            inputChecksum = input.readInt();
        }
        int patchLength = input.readInt();
        byte[] patchBytes = new byte[patchLength];
        input.readFully(patchBytes);
        return new ClassPatch(name, sourceClassName, targetClassName, exists, inputChecksum, patchBytes);
    }
}

