/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.logging.log4j.Level;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final kn BLOCK_TO_ITEM = new kn("minecraft:blocktoitemmap");
    private static final kn BLOCKSTATE_TO_ID = new kn("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private final FMLControlledNamespacedRegistry<akf> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, akf.class, new kn("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<adx> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, adx.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<rp> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, rp.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<aiq> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, aiq.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<ni> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, ni.class, null, 0, 0x3FFFFFF, false, null, null, null);
    private final FMLControlledNamespacedRegistry<afn> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<agv> iEnchantmentRegistry;

    public GameData() {
        kn WATER = new kn("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, afn.class, WATER, 0, 0x3FFFFFF, false, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, agv.class, null, 0, 32766, false, null, null, null);
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<akf> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<adx> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<rp> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<aiq> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<ni> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<afn> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<agv> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    static adx findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kn(modId, name));
    }

    @Deprecated
    static akf findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kn(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    @Deprecated
    int registerItem(adx item, String name) {
        return this.iItemRegistry.add(-1, this.addPrefix(name), item);
    }

    @Deprecated
    int registerBlock(akf block, String name) {
        return this.iBlockRegistry.add(-1, this.addPrefix(name), block);
    }

    private kn addPrefix(String name) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String prefix = mc != null ? mc.getModId().toLowerCase() : "minecraft";
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.bigWarning("Dangerous alternative prefix %s for name %s, invalid registry invocation/invalid name?", prefix, name);
            prefix = oldPrefix;
        }
        return new kn(prefix, name);
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kn nameToSubstitute = new kn(name);
        BiMap<akf, adx> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (akf)toReplace);
            akf orig = this.iBlockRegistry.activateSubstitution(nameToSubstitute);
            if (blockItemMap.containsKey((Object)orig)) {
                adx i = (adx)blockItemMap.get((Object)orig);
                blockItemMap.forcePut((Object)((akf)toReplace), (Object)i);
            }
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (adx)toReplace);
            adx orig = this.iItemRegistry.activateSubstitution(nameToSubstitute);
            if (blockItemMap.containsValue((Object)orig)) {
                akf b2 = (akf)blockItemMap.inverse().get((Object)orig);
                blockItemMap.forcePut((Object)b2, (Object)((adx)toReplace));
            }
        }
    }

    public static BiMap<akf, adx> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, kn location) {
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static cw<ars> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, cw.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<aiq>,
    IForgeRegistry.ClearCallback<aiq>,
    IForgeRegistry.CreateCallback<aiq> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(aiq potion, int id, Map<kn, ?> slaves) {
        }

        @Override
        public void onClear(Map<kn, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<rp>,
    IForgeRegistry.ClearCallback<rp>,
    IForgeRegistry.CreateCallback<rp> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(rp potion, int id, Map<kn, ?> slaves) {
        }

        @Override
        public void onClear(Map<kn, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<adx>,
    IForgeRegistry.ClearCallback<adx>,
    IForgeRegistry.CreateCallback<adx> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(adx item, int blockId, Map<kn, ?> slaves) {
            if (item instanceof acl) {
                acl itemBlock = (acl)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                blockToItem.forcePut(itemBlock.d().delegate.get(), (Object)item);
            }
        }

        @Override
        public void onClear(Map<kn, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset) {
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<akf>,
    IForgeRegistry.ClearCallback<akf>,
    IForgeRegistry.CreateCallback<akf> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(akf block, int blockId, Map<kn, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaves.get(BLOCKSTATE_TO_ID));
            for (ars state : block.t().a()) {
                blockstateMap.a(state, blockId << 4 | block.e(state));
            }
        }

        @Override
        public void onClear(Map<kn, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaveset.get(BLOCKSTATE_TO_ID));
            blockstateMap.clear();
        }

        @Override
        public void onCreate(Map<kn, ?> slaveset) {
            ClearableObjectIntIdentityMap idMap = new ClearableObjectIntIdentityMap();
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends cw<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

