/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import java.io.File;
import java.util.Locale;
import net.minecraftforge.fml.common.TracingPrintStream;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class FMLRelaunchLog {
    public static final FMLRelaunchLog log = new FMLRelaunchLog();
    static File minecraftHome;
    private static boolean configured;
    private Logger myLog;
    static Side side;

    private FMLRelaunchLog() {
    }

    private static void configureLogging() {
        FMLRelaunchLog.log.myLog = LogManager.getLogger((String)"FML");
        ThreadContext.put((String)"side", (String)side.name().toLowerCase(Locale.ENGLISH));
        configured = true;
        FMLRelaunchLog.fine("Injecting tracing printstreams for STDOUT/STDERR.", new Object[0]);
        System.setOut(new TracingPrintStream(LogManager.getLogger((String)"STDOUT"), System.out));
        System.setErr(new TracingPrintStream(LogManager.getLogger((String)"STDERR"), System.err));
    }

    public static void log(String targetLog, Level level, String format, Object ... data) {
        LogManager.getLogger((String)targetLog).log(level, String.format(format, data));
    }

    public static void log(Level level, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data));
    }

    public static void log(String targetLog, Level level, Throwable ex2, String format, Object ... data) {
        LogManager.getLogger((String)targetLog).log(level, String.format(format, data), ex2);
    }

    public static void log(Level level, Throwable ex2, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data), ex2);
    }

    public static void severe(String format, Object ... data) {
        FMLRelaunchLog.log(Level.ERROR, format, data);
    }

    public static void warning(String format, Object ... data) {
        FMLRelaunchLog.log(Level.WARN, format, data);
    }

    public static void info(String format, Object ... data) {
        FMLRelaunchLog.log(Level.INFO, format, data);
    }

    public static void fine(String format, Object ... data) {
        FMLRelaunchLog.log(Level.DEBUG, format, data);
    }

    public static void finer(String format, Object ... data) {
        FMLRelaunchLog.log(Level.TRACE, format, data);
    }

    public Logger getLogger() {
        return this.myLog;
    }
}

