/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.repackage.com.nothome.delta;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraftforge.fml.repackage.com.nothome.delta.SeekableSource;

public class ByteBufferSeekableSource
implements SeekableSource {
    private ByteBuffer bb;
    private ByteBuffer cur;

    public ByteBufferSeekableSource(byte[] source) {
        this(ByteBuffer.wrap(source));
    }

    public ByteBufferSeekableSource(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException("bb");
        }
        this.bb = bb;
        bb.rewind();
        try {
            this.seek(0L);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.cur = this.bb.slice();
        if (pos > (long)this.cur.limit()) {
            throw new IOException("pos " + pos + " cannot seek " + this.cur.limit());
        }
        this.cur.position((int)pos);
    }

    @Override
    public int read(ByteBuffer dest) throws IOException {
        if (!this.cur.hasRemaining()) {
            return -1;
        }
        int c2 = 0;
        while (this.cur.hasRemaining() && dest.hasRemaining()) {
            dest.put(this.cur.get());
            ++c2;
        }
        return c2;
    }

    @Override
    public void close() throws IOException {
        this.bb = null;
        this.cur = null;
    }

    public String toString() {
        return "BBSeekable bb=" + this.bb.position() + "-" + this.bb.limit() + " cur=" + this.cur.position() + "-" + this.cur.limit() + "";
    }
}

