/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<List<adz>> idToStack = Lists.newArrayList();
    private static List<List<adz>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final ImmutableList<adz> EMPTY_LIST = ImmutableList.of();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new adz(akg.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new adz(akg.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new adz(akg.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new adz((akf)akg.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", akg.ad);
            OreDictionary.registerOre("stairWood", akg.bU);
            OreDictionary.registerOre("stairWood", akg.bV);
            OreDictionary.registerOre("stairWood", akg.bW);
            OreDictionary.registerOre("stairWood", akg.cC);
            OreDictionary.registerOre("stairWood", akg.cD);
            OreDictionary.registerOre("stickWood", aeb.A);
            OreDictionary.registerOre("treeSapling", new adz(akg.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new adz((akf)akg.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new adz((akf)akg.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", akg.bn);
            OreDictionary.registerOre("oreGold", akg.o);
            OreDictionary.registerOre("oreIron", akg.p);
            OreDictionary.registerOre("oreLapis", akg.x);
            OreDictionary.registerOre("oreDiamond", akg.ag);
            OreDictionary.registerOre("oreRedstone", akg.aC);
            OreDictionary.registerOre("oreEmerald", akg.bP);
            OreDictionary.registerOre("oreQuartz", akg.co);
            OreDictionary.registerOre("oreCoal", akg.q);
            OreDictionary.registerOre("ingotIron", aeb.l);
            OreDictionary.registerOre("ingotGold", aeb.m);
            OreDictionary.registerOre("ingotBrick", aeb.aO);
            OreDictionary.registerOre("ingotBrickNether", aeb.cp);
            OreDictionary.registerOre("nuggetGold", aeb.bE);
            OreDictionary.registerOre("gemDiamond", aeb.k);
            OreDictionary.registerOre("gemEmerald", aeb.bY);
            OreDictionary.registerOre("gemQuartz", aeb.cq);
            OreDictionary.registerOre("gemPrismarine", aeb.cM);
            OreDictionary.registerOre("dustPrismarine", aeb.cN);
            OreDictionary.registerOre("dustRedstone", aeb.aE);
            OreDictionary.registerOre("dustGlowstone", aeb.ba);
            OreDictionary.registerOre("gemLapis", new adz(aeb.bd, 1, 4));
            OreDictionary.registerOre("blockGold", akg.R);
            OreDictionary.registerOre("blockIron", akg.S);
            OreDictionary.registerOre("blockLapis", akg.y);
            OreDictionary.registerOre("blockDiamond", akg.ah);
            OreDictionary.registerOre("blockRedstone", akg.cn);
            OreDictionary.registerOre("blockEmerald", akg.bT);
            OreDictionary.registerOre("blockQuartz", akg.cq);
            OreDictionary.registerOre("blockCoal", akg.cA);
            OreDictionary.registerOre("cropWheat", aeb.Q);
            OreDictionary.registerOre("cropPotato", aeb.cc);
            OreDictionary.registerOre("cropCarrot", aeb.cb);
            OreDictionary.registerOre("cropNetherWart", aeb.bF);
            OreDictionary.registerOre("sugarcane", aeb.aQ);
            OreDictionary.registerOre("blockCactus", (akf)akg.aK);
            OreDictionary.registerOre("dye", new adz(aeb.bd, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new adz(aeb.aR));
            OreDictionary.registerOre("slimeball", aeb.aT);
            OreDictionary.registerOre("enderpearl", aeb.bB);
            OreDictionary.registerOre("bone", aeb.be);
            OreDictionary.registerOre("gunpowder", aeb.J);
            OreDictionary.registerOre("string", aeb.H);
            OreDictionary.registerOre("netherStar", aeb.cj);
            OreDictionary.registerOre("leather", aeb.aM);
            OreDictionary.registerOre("feather", aeb.I);
            OreDictionary.registerOre("egg", aeb.aW);
            OreDictionary.registerOre("record", aeb.cA);
            OreDictionary.registerOre("record", aeb.cB);
            OreDictionary.registerOre("record", aeb.cC);
            OreDictionary.registerOre("record", aeb.cD);
            OreDictionary.registerOre("record", aeb.cE);
            OreDictionary.registerOre("record", aeb.cF);
            OreDictionary.registerOre("record", aeb.cG);
            OreDictionary.registerOre("record", aeb.cH);
            OreDictionary.registerOre("record", aeb.cI);
            OreDictionary.registerOre("record", aeb.cJ);
            OreDictionary.registerOre("record", aeb.cK);
            OreDictionary.registerOre("record", aeb.cL);
            OreDictionary.registerOre("dirt", akg.d);
            OreDictionary.registerOre("grass", (akf)akg.c);
            OreDictionary.registerOre("stone", akg.b);
            OreDictionary.registerOre("cobblestone", akg.e);
            OreDictionary.registerOre("gravel", akg.n);
            OreDictionary.registerOre("sand", new adz((akf)akg.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new adz(akg.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new adz(akg.cM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", akg.aV);
            OreDictionary.registerOre("obsidian", akg.Z);
            OreDictionary.registerOre("glowstone", akg.aX);
            OreDictionary.registerOre("endstone", akg.bH);
            OreDictionary.registerOre("torch", akg.aa);
            OreDictionary.registerOre("workbench", akg.ai);
            OreDictionary.registerOre("blockSlime", akg.cE);
            OreDictionary.registerOre("blockPrismarine", new adz(akg.cI, 1, aod.a.a.a()));
            OreDictionary.registerOre("blockPrismarineBrick", new adz(akg.cI, 1, aod.a.b.a()));
            OreDictionary.registerOre("blockPrismarineDark", new adz(akg.cI, 1, aod.a.c.a()));
            OreDictionary.registerOre("stoneGranite", new adz(akg.b, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new adz(akg.b, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new adz(akg.b, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new adz(akg.b, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new adz(akg.b, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new adz(akg.b, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", akg.w);
            OreDictionary.registerOre("blockGlass", akg.w);
            OreDictionary.registerOre("blockGlass", new adz((akf)akg.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", akg.bj);
            OreDictionary.registerOre("paneGlass", akg.bj);
            OreDictionary.registerOre("paneGlass", new adz((akf)akg.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", (akf)akg.ae);
            OreDictionary.registerOre("chest", akg.bQ);
            OreDictionary.registerOre("chest", akg.cg);
            OreDictionary.registerOre("chestWood", (akf)akg.ae);
            OreDictionary.registerOre("chestEnder", akg.bQ);
            OreDictionary.registerOre("chestTrapped", akg.cg);
        }
        HashMap<adz, String> replacements = new HashMap<adz, String>();
        replacements.put(new adz(aeb.A), "stickWood");
        replacements.put(new adz(akg.f), "plankWood");
        replacements.put(new adz(akg.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new adz((akf)akg.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new adz(aeb.m), "ingotGold");
        replacements.put(new adz(aeb.l), "ingotIron");
        replacements.put(new adz(aeb.k), "gemDiamond");
        replacements.put(new adz(aeb.bY), "gemEmerald");
        replacements.put(new adz(aeb.cM), "gemPrismarine");
        replacements.put(new adz(aeb.cN), "dustPrismarine");
        replacements.put(new adz(aeb.aE), "dustRedstone");
        replacements.put(new adz(aeb.ba), "dustGlowstone");
        replacements.put(new adz(aeb.aQ), "sugarcane");
        replacements.put(new adz((akf)akg.aK), "blockCactus");
        replacements.put(new adz(aeb.aR), "paper");
        replacements.put(new adz(aeb.aT), "slimeball");
        replacements.put(new adz(aeb.H), "string");
        replacements.put(new adz(aeb.aM), "leather");
        replacements.put(new adz(aeb.bB), "enderpearl");
        replacements.put(new adz(aeb.J), "gunpowder");
        replacements.put(new adz(aeb.cj), "netherStar");
        replacements.put(new adz(aeb.I), "feather");
        replacements.put(new adz(aeb.be), "bone");
        replacements.put(new adz(aeb.aW), "egg");
        replacements.put(new adz(akg.b), "stone");
        replacements.put(new adz(akg.e), "cobblestone");
        replacements.put(new adz(akg.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new adz(akg.aX), "glowstone");
        replacements.put(new adz(akg.w), "blockGlassColorless");
        replacements.put(new adz(akg.cI), "prismarine");
        replacements.put(new adz(akg.b, 1, 1), "stoneGranite");
        replacements.put(new adz(akg.b, 1, 2), "stoneGranitePolished");
        replacements.put(new adz(akg.b, 1, 3), "stoneDiorite");
        replacements.put(new adz(akg.b, 1, 4), "stoneDioritePolished");
        replacements.put(new adz(akg.b, 1, 5), "stoneAndesite");
        replacements.put(new adz(akg.b, 1, 6), "stoneAndesitePolished");
        replacements.put(new adz((akf)akg.ae), "chestWood");
        replacements.put(new adz(akg.bQ), "chestEnder");
        replacements.put(new adz(akg.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            adz dye = new adz(aeb.bd, 1, i);
            adz block = new adz((akf)akg.cG, 1, 15 - i);
            adz pane = new adz((akf)akg.cH, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        adz[] replaceStacks = replacements.keySet().toArray(new adz[replacements.keySet().size()]);
        adz[] exclusions = new adz[]{new adz(akg.y), new adz(aeb.bj), new adz(akg.bf), new adz((akf)akg.U, 1, Short.MAX_VALUE), new adz(akg.aw), new adz(akg.bZ), new adz(akg.aO), new adz(akg.bo), new adz(akg.ad), new adz(akg.aP), new adz(akg.bp), new adz(akg.bU), new adz(akg.bV), new adz(akg.bq), new adz(akg.bV), new adz(akg.aR), new adz(akg.br), new adz(akg.bW), new adz(akg.aT), new adz(akg.bt), new adz(akg.cC), new adz(akg.aS), new adz(akg.bs), new adz(akg.cD), new adz((akf)akg.bM), new adz(akg.bj), null};
        List recipes = age.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            adz output;
            agg recipe;
            if (obj.getClass() == agg.class) {
                recipe = (agg)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (obj.getClass() != agh.class || (output = (recipe = (agh)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new adz[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((agd)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((agh)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipes", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            ArrayList back = Lists.newArrayList();
            idToStack.add(back);
            idToStackUn.add(Collections.unmodifiableList(back));
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(adz stack) {
        if (stack == null || stack.b() == null) {
            throw new IllegalArgumentException("Stack can not be null!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        kn registryName = stack.b().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.h() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static List<adz> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static List<adz> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static List<adz> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, adz[] inputs, adz ... targets) {
        for (adz input : inputs) {
            for (adz target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, List<adz> inputs, adz ... targets) {
        for (adz input : inputs) {
            for (adz target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(adz target, adz input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.h() == Short.MAX_VALUE && !strict || target.h() == input.h());
    }

    public static void registerOre(String name, adx ore) {
        OreDictionary.registerOre(name, new adz(ore));
    }

    public static void registerOre(String name, akf ore) {
        OreDictionary.registerOre(name, new adz(ore));
    }

    public static void registerOre(String name, adz ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, adz ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore == null || ore.b() == null) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        kn registryName = ore.b().delegate.name();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.b().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.h() != Short.MAX_VALUE) {
            hash |= ore.h() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.k();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            List<adz> ores = idToStack.get(id);
            if (ores == null) continue;
            for (adz ore : ores) {
                ArrayList ids;
                int hash;
                kn name = ore.b().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id), ore.b().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.h() != Short.MAX_VALUE) {
                    hash |= ore.h() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final adz Ore;

        public OreRegisterEvent(String name, adz ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        public adz getOre() {
            return this.Ore;
        }
    }
}

