/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import org.apache.commons.lang3.tuple.Pair;

public class LightUtil {
    private static final float s2 = (float)Math.pow(2.0, 0.5);
    private static final LoadingCache<Pair<bzj, bzj>, int[]> formatMaps = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<Pair<bzj, bzj>, int[]>(){

        public int[] load(Pair<bzj, bzj> pair) {
            return LightUtil.mapFormats((bzj)pair.getLeft(), (bzj)pair.getRight());
        }
    });
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;

    public static float diffuseLight(float x, float y, float z) {
        float y1 = y + 3.0f - 2.0f * s2;
        return x * x * 0.6f + y1 * y1 * (3.0f + 2.0f * s2) / 8.0f + z * z * 0.8f;
    }

    public static float diffuseLight(cv side) {
        switch (side) {
            case a: {
                return 0.5f;
            }
            case b: {
                return 1.0f;
            }
            case c: 
            case d: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static cv toSide(float x, float y, float z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0f) {
                    return cv.e;
                }
                return cv.f;
            }
            if (z < 0.0f) {
                return cv.c;
            }
            return cv.d;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return cv.a;
            }
            return cv.b;
        }
        if (z < 0.0f) {
            return cv.c;
        }
        return cv.d;
    }

    public static void putBakedQuad(IVertexConsumer consumer, brd quad) {
        consumer.setTexture(quad.a());
        consumer.setQuadOrientation(quad.e());
        if (quad.c()) {
            consumer.setQuadTint(quad.d());
        }
        consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        bzj formatFrom = consumer.getVertexFormat();
        bzj formatTo = quad.getFormat();
        int countFrom = formatFrom.i();
        int countTo = formatTo.i();
        int[] eMap = (int[])formatMaps.getUnchecked((Object)Pair.of((Object)formatFrom, (Object)formatTo));
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack(quad.b(), data, quad.getFormat(), v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(bzj from, bzj to) {
        int fromCount = from.i();
        int toCount = to.i();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            bzk expected = from.c(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                bzk current = to.c(e2);
                if (expected.b() == current.b() && expected.d() == current.d()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, bzj formatFrom, int v, int e) {
        int length = 4 < to.length ? 4 : to.length;
        bzk element = formatFrom.c(e);
        int vertexStart = v * formatFrom.g() + formatFrom.d(e);
        int count = element.c();
        bzk.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == bzk.a.a) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == bzk.a.b || type == bzk.a.d) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == bzk.a.f) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == bzk.a.c) {
                    to[i] = (float)((byte)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type == bzk.a.e) {
                    to[i] = (float)((short)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type != bzk.a.g) continue;
                to[i] = (float)((long)bits & 0xFFFFFFFFL) / 4.2949673E9f * 2.0f;
                continue;
            }
            to[i] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, bzj formatTo, int v, int e) {
        bzk element = formatTo.c(e);
        int vertexStart = v * formatTo.g() + formatTo.d(e);
        int count = element.c();
        bzk.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == bzk.a.a ? Float.floatToRawIntBits(f) : (type == bzk.a.b || type == bzk.a.d || type == bzk.a.f ? (int)(f * (float)mask) : (int)(f * (float)mask / 2.0f));
            int n2 = index;
            to[n2] = to[n2] & ~(mask << offset * 8);
            int n3 = index;
            to[n3] = to[n3] | (bits & mask) << offset * 8;
        }
    }

    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            bqs tes = bqs.a();
            bpy wr = tes.c();
            tessellator = new VertexBufferConsumer(wr);
        }
        return tessellator;
    }

    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(bpy wr, brd quad, int auxColor) {
        ItemConsumer cons = wr == bqs.a().c() ? LightUtil.getItemConsumer() : new ItemConsumer(new VertexBufferConsumer(wr));
        float b2 = (float)(auxColor & 0xFF) / 255.0f;
        float g = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r2 = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a2 = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r2, g, b2, a2);
        quad.pipe((IVertexConsumer)cons);
    }

    public static void renderQuadColor(bpy wr, brd quad, int auxColor) {
        wr.a(quad.b());
        ForgeHooksClient.putQuadColor(wr, quad, auxColor);
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().c(element).b() == bzk.b.c) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                for (int i = 0; i < 4; ++i) {
                    int n2 = i;
                    this.buf[n2] = this.buf[n2] * data[i];
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().i() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                }
            }
        }
    }
}

