/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final sw entity;
    protected final List<ss> slots;

    public EntityEquipmentInvWrapper(sw entity, ss.a slotType) {
        this.entity = entity;
        ArrayList<ss> slots = new ArrayList<ss>();
        for (ss slot : ss.values()) {
            if (slot.a() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    @Nonnull
    public afj getStackInSlot(int slot) {
        return this.entity.b(this.validateSlotIndex(slot));
    }

    @Override
    @Nonnull
    public afj insertItem(int slot, @Nonnull afj stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.b()) {
            return afj.a;
        }
        ss equipmentSlot = this.validateSlotIndex(slot);
        afj existing = this.entity.b(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.E() > limit;
        if (!simulate) {
            if (existing.b()) {
                this.entity.a(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.f(reachedLimit ? limit : stack.E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.E() - limit) : afj.a;
    }

    @Override
    @Nonnull
    public afj extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return afj.a;
        }
        ss equipmentSlot = this.validateSlotIndex(slot);
        afj existing = this.entity.b(equipmentSlot);
        if (existing.b()) {
            return afj.a;
        }
        int toExtract = Math.min(amount, existing.d());
        if (existing.E() <= toExtract) {
            if (!simulate) {
                this.entity.a(equipmentSlot, afj.a);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.a(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.E() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        ss equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.a() == ss.a.b ? 1 : 64;
    }

    protected int getStackLimit(int slot, @Nonnull afj stack) {
        return Math.min(this.getSlotLimit(slot), stack.d());
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull afj stack) {
        ss equipmentSlot = this.validateSlotIndex(slot);
        if (afj.b((afj)this.entity.b(equipmentSlot), (afj)stack)) {
            return;
        }
        this.entity.a(equipmentSlot, stack);
    }

    protected ss validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }
}

