/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenEvent
extends Event {
    private final bhm gui;

    public GuiScreenEvent(bhm gui) {
        this.gui = gui;
    }

    public bhm getGui() {
        return this.gui;
    }

    public static class KeyboardInputEvent
    extends GuiScreenEvent {
        public KeyboardInputEvent(bhm gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends KeyboardInputEvent {
            public Post(bhm gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardInputEvent {
            public Pre(bhm gui) {
                super(gui);
            }
        }
    }

    public static class MouseInputEvent
    extends GuiScreenEvent {
        public MouseInputEvent(bhm gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends MouseInputEvent {
            public Post(bhm gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseInputEvent {
            public Pre(bhm gui) {
                super(gui);
            }
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private bfk button;
        private List<bfk> buttonList;

        public ActionPerformedEvent(bhm gui, bfk button, List<bfk> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<bfk>(buttonList));
        }

        public bfk getButton() {
            return this.button;
        }

        public void setButton(bfk button) {
            this.button = button;
        }

        public List<bfk> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bfk> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(bhm gui, bfk button, List<bfk> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(bhm gui, bfk button, List<bfk> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(bhm gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;

        public BackgroundDrawnEvent(bhm gui) {
            super(gui);
            bfi scaledresolution = new bfi(gui.j);
            int scaledWidth = scaledresolution.a();
            int scaledHeight = scaledresolution.b();
            this.mouseX = Mouse.getX() * scaledWidth / gui.j.d;
            this.mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.j.e - 1;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(bhm gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(bhm gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(bhm gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private List<bfk> buttonList;

        public InitGuiEvent(bhm gui, List<bfk> buttonList) {
            super(gui);
            this.setButtonList(buttonList);
        }

        public List<bfk> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bfk> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends InitGuiEvent {
            public Post(bhm gui, List<bfk> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(bhm gui, List<bfk> buttonList) {
                super(gui, buttonList);
            }
        }
    }
}

