/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class ItemLayerModel
implements IRetexturableModel {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<kq>)ImmutableList.of());
    private final ImmutableList<kq> textures;
    private final brm overrides;

    public ItemLayerModel(ImmutableList<kq> textures) {
        this(textures, brm.a);
    }

    public ItemLayerModel(ImmutableList<kq> textures, brm overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public ItemLayerModel(brg model) {
        this(ItemLayerModel.getTextures(model), model.g());
    }

    private static ImmutableList<kq> getTextures(brg model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.b("layer" + i)) {
            builder.add((Object)new kq(model.c("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    @Override
    public Collection<kq> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<kq> getTextures() {
        return this.textures;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public ItemLayerModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size() + this.textures.size(); ++i) {
            if (textures.containsKey((Object)("layer" + i))) {
                builder.add((Object)new kq((String)textures.get((Object)("layer" + i))));
                continue;
            }
            if (i >= this.textures.size()) continue;
            builder.add(this.textures.get(i));
        }
        return new ItemLayerModel((ImmutableList<kq>)builder.build(), this.overrides);
    }

    @Override
    public cbe bake(IModelState state, bzg format, Function<kq, byw> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply((Optional<? extends IModelPart>)Optional.absent());
        for (int i = 0; i < this.textures.size(); ++i) {
            byw sprite = (byw)bakedTextureGetter.apply(this.textures.get(i));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i, sprite, format, transform));
        }
        byw particle = (byw)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new kq("missingno") : (kq)this.textures.get(0)));
        ImmutableMap<bro.b, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        return new BakedItemModel((ImmutableList<brb>)builder.build(), particle, map, this.overrides, null);
    }

    public static ImmutableList<brb> getQuadsForSprite(int tint, byw sprite, bzg format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.c();
        int vMax = sprite.d();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f = 0; f < sprite.k(); ++f) {
            int[] pixels = sprite.a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = ItemLayerModel.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.e, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptu && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.f, tint, sprite, uMax, vMax, u, v);
                    }
                    if (ptv[u] && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.b, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptv[u] && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.a, tint, sprite, uMax, vMax, u, v);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.f, tint, sprite, uMax, vMax, uMax, v);
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<brb>)builder, faces, format, transform, cv.a, tint, sprite, uMax, vMax, u, vMax);
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cv.c, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.e(), sprite.h(), 0.0f, 1.0f, 0.46875f, sprite.e(), sprite.g(), 1.0f, 1.0f, 0.46875f, sprite.f(), sprite.g(), 1.0f, 0.0f, 0.46875f, sprite.f(), sprite.h()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cv.d, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.e(), sprite.h(), 1.0f, 0.0f, 0.53125f, sprite.f(), sprite.h(), 1.0f, 1.0f, 0.53125f, sprite.f(), sprite.g(), 0.0f, 1.0f, 0.53125f, sprite.e(), sprite.g()));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<brb> builder, BitSet faces, bzg format, Optional<TRSRTransformation> transform, cv side, int tint, byw sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static brb buildSideQuad(bzg format, Optional<TRSRTransformation> transform, cv side, int tint, byw sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.c();
        float y0 = (float)v / (float)sprite.d();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case e: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case f: {
                y1 = ((float)v + 1.0f) / (float)sprite.d();
                break;
            }
            case a: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case b: {
                x1 = ((float)u + 1.0f) / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float u1 = 16.0f * (x1 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float v0 = 16.0f * (1.0f - y0 - (float)side.n().q() * 0.5f / (float)sprite.d());
        float v1 = 16.0f * (1.0f - y1 - (float)side.n().q() * 0.5f / (float)sprite.d());
        switch (side) {
            case e: 
            case f: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.d();
                v1 += 0.5f / (float)sprite.d();
                break;
            }
            case a: 
            case b: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.c();
                u1 -= 0.5f / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case e: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case f: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case a: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case b: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModel.buildQuad(format, transform, side.d(), sprite, tint, x0, y0, z1, sprite.a((double)u0), sprite.b((double)v0), x1, y1, z1, sprite.a((double)u1), sprite.b((double)v1), x1, y1, z2, sprite.a((double)u1), sprite.b((double)v1), x0, y0, z2, sprite.a((double)u0), sprite.b((double)v0));
    }

    private static final brb buildQuad(bzg format, Optional<TRSRTransformation> transform, cv side, byw sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, bzg format, Optional<TRSRTransformation> transform, cv side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.i(); ++e) {
            switch (format.c(e).b()) {
                case a: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        ((TRSRTransformation)transform.get()).getMatrix().transform((Tuple4f)vec);
                        builder.put(e, vec.x, vec.y, vec.z, vec.w);
                        continue block6;
                    }
                    builder.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case c: {
                    builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e).d() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(bzv resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("item-layer") || modelLocation.a().equals("models/block/item-layer") || modelLocation.a().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(kq modelLocation) {
            return INSTANCE;
        }
    }

    private static final class BakedItemModel
    implements IPerspectiveAwareModel {
        private final ImmutableList<brb> quads;
        private final byw particle;
        private final ImmutableMap<bro.b, TRSRTransformation> transforms;
        private final cbe otherModel;
        private final boolean isCulled;
        private final brm overrides;

        public BakedItemModel(ImmutableList<brb> quads, byw particle, ImmutableMap<bro.b, TRSRTransformation> transforms, brm overrides, cbe otherModel) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (brb quad : quads) {
                    if (quad.e() != cv.d) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<brb>)builder.build(), particle, transforms, overrides, this);
                this.isCulled = false;
            }
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public byw d() {
            return this.particle;
        }

        public bro e() {
            return bro.a;
        }

        public brm f() {
            return this.overrides;
        }

        public List<brb> a(atj state, cv side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Override
        public Pair<? extends cbe, Matrix4f> handlePerspective(bro.b type) {
            Pair<? extends cbe, Matrix4f> pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((cbe)this, this.transforms, type);
            if (type == bro.b.g && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != bro.b.g && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }
}

