/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.client.settings.KeyModifier;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, oo<Collection<ben>>> map = new EnumMap(KeyModifier.class);

    public ben lookupActive(int keyCode) {
        ben binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    private ben getBinding(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get((Object)keyModifier).a(keyCode);
        if (bindings != null) {
            for (ben binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<ben> lookupAll(int keyCode) {
        ArrayList<ben> matchingBindings = new ArrayList<ben>();
        for (oo<Collection<ben>> bindingsMap : map.values()) {
            Collection bindings = (Collection)bindingsMap.a(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, ben keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        oo<Collection<ben>> bindingsMap = map.get((Object)keyModifier);
        ArrayList<ben> bindingsForKey = (ArrayList<ben>)bindingsMap.a(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<ben>();
            bindingsMap.a(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(ben keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        int keyCode = keyBinding.j();
        oo<Collection<ben>> bindingsMap = map.get((Object)keyModifier);
        Collection bindingsForKey = (Collection)bindingsMap.a(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.d(keyCode);
            }
        }
    }

    public void clearMap() {
        for (oo<Collection<ben>> bindings : map.values()) {
            bindings.c();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, (oo<Collection<ben>>)new oo());
        }
    }
}

