/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    public static List<akd> oceanBiomes = new ArrayList<akd>();
    public static ArrayList<akd> strongHoldBiomes = new ArrayList();
    public static ArrayList<akd> strongHoldBiomesBlackList = new ArrayList();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(aki.f, 10));
        list.add(new BiomeEntry(aki.E, 10));
        list.add(new BiomeEntry(aki.e, 10));
        list.add(new BiomeEntry(aki.c, 10));
        list.add(new BiomeEntry(aki.C, 10));
        list.add(new BiomeEntry(aki.h, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(aki.f, 10));
        list.add(new BiomeEntry(aki.e, 10));
        list.add(new BiomeEntry(aki.g, 10));
        list.add(new BiomeEntry(aki.c, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(aki.n, 30));
        list.add(new BiomeEntry(aki.F, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        return currentBiomes;
    }

    public static void addVillageBiome(akd biome, boolean canSpawn) {
        if (!ayr.a.contains(biome)) {
            ArrayList<akd> biomes = new ArrayList<akd>(ayr.a);
            biomes.add(biome);
            ayr.a = biomes;
        }
    }

    public static void removeVillageBiome(akd biome) {
        if (ayr.a.contains(biome)) {
            ArrayList biomes = new ArrayList(ayr.a);
            biomes.remove(biome);
            ayr.a = biomes;
        }
    }

    public static void addStrongholdBiome(akd biome) {
        if (!strongHoldBiomes.contains(biome)) {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(akd biome) {
        if (!strongHoldBiomesBlackList.contains(biome)) {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(akd biome) {
        if (!akh.allowedBiomes.contains(biome)) {
            akh.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(akd biome) {
        if (akh.allowedBiomes.contains(biome)) {
            akh.allowedBiomes.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains((Object)entry)) {
            list.remove((Object)entry);
        }
    }

    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx >= biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static /* synthetic */ TrackedList[] access$002(TrackedList[] x0) {
        biomes = x0;
        return x0;
    }

    static {
        oceanBiomes.add(aki.a);
        oceanBiomes.add(aki.z);
        oceanBiomes.add(aki.l);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c2) {
            super(c2);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e) {
            this.isModded = true;
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            this.isModded = true;
            return super.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            this.isModded = true;
            return super.retainAll(c2);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends pb.a {
        public final akd biome;

        public BiomeEntry(akd biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType getType(String name) {
            name = name.toUpperCase();
            for (BiomeType t : BiomeType.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, new Class[0], new Object[0]);
            if (ret.ordinal() >= biomes.length) {
                BiomeManager.access$002(Arrays.copyOf(biomes, ret.ordinal() + 1));
            }
            return ret;
        }
    }
}

