/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    private final afi input;
    private final T ingredient;
    private final afi output;

    protected AbstractBrewingRecipe(@Nonnull afi input, @Nonnull T ingredient, @Nonnull afi output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        if (this.getInput().d() != 1) {
            throw new IllegalArgumentException("Inputs must have a max size of 1 just like water bottles. Brewing Stands override the input with the output when the brewing is done, items that stack would end up getting lost.");
        }
    }

    @Override
    public boolean isInput(@Nonnull afi stack) {
        return OreDictionary.itemMatches(this.getInput(), stack, false);
    }

    @Override
    @Nonnull
    public afi getOutput(@Nonnull afi input, @Nonnull afi ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().l() : afi.a;
    }

    @Nonnull
    public afi getInput() {
        return this.input;
    }

    @Nonnull
    public T getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public afi getOutput() {
        return this.output;
    }
}

