/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public abstract class ForgeMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class FluidIdMapMessage
    extends ForgeMessage {
        BiMap<Fluid, Integer> fluidIds = HashBiMap.create();
        Set<String> defaultFluids = Sets.newHashSet();

        @Override
        void toBytes(ByteBuf bytes) {
            Map<Fluid, Integer> ids = FluidRegistry.getRegisteredFluidIDs();
            bytes.writeInt(ids.size());
            for (Map.Entry<Fluid, Integer> entry : ids.entrySet()) {
                ByteBufUtils.writeUTF8String(bytes, entry.getKey().getName());
                bytes.writeInt(entry.getValue().intValue());
            }
            for (Map.Entry<Fluid, Integer> entry : ids.entrySet()) {
                String defaultName = FluidRegistry.getDefaultFluidName(entry.getKey());
                ByteBufUtils.writeUTF8String(bytes, defaultName);
            }
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            int i;
            int listSize = bytes.readInt();
            for (i = 0; i < listSize; ++i) {
                String fluidName = ByteBufUtils.readUTF8String(bytes);
                int fluidId = bytes.readInt();
                this.fluidIds.put((Object)FluidRegistry.getFluid(fluidName), (Object)fluidId);
            }
            if (bytes.isReadable()) {
                for (i = 0; i < listSize; ++i) {
                    this.defaultFluids.add(ByteBufUtils.readUTF8String(bytes));
                }
            } else {
                FMLLog.getLogger().log(Level.INFO, "Legacy server message contains no default fluid list - there may be problems with fluids");
                this.defaultFluids.clear();
            }
        }
    }

    public static class DimensionRegisterMessage
    extends ForgeMessage {
        int dimensionId;
        String providerId;

        public DimensionRegisterMessage() {
        }

        public DimensionRegisterMessage(int dimensionId, String providerId) {
            this.dimensionId = dimensionId;
            this.providerId = providerId;
        }

        @Override
        void toBytes(ByteBuf bytes) {
            bytes.writeInt(this.dimensionId);
            byte[] data = this.providerId.getBytes(Charsets.UTF_8);
            bytes.writeShort(data.length);
            bytes.writeBytes(data);
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            this.dimensionId = bytes.readInt();
            byte[] data = new byte[bytes.readShort()];
            bytes.readBytes(data);
            this.providerId = new String(data, Charsets.UTF_8);
        }
    }
}

