/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final rh hand;
    private final co pos;
    private final cv face;

    private PlayerInteractEvent(aax player, rh hand, co pos, cv face) {
        super((aax)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (rh)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (co)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    public rh getHand() {
        return this.hand;
    }

    @Nonnull
    public afi getItemStack() {
        return this.getEntityPlayer().b(this.hand);
    }

    public co getPos() {
        return this.pos;
    }

    @Nullable
    public cv getFace() {
        return this.face;
    }

    public ajq getWorld() {
        return this.getEntityPlayer().e();
    }

    public Side getSide() {
        return this.getWorld().E ? Side.CLIENT : Side.SERVER;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(aax player, @Nonnull afi stack) {
            super(player, rh.a, new co((sm)player), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bdu hitVec;

        public LeftClickBlock(aax player, co pos, cv face, bdu hitVec) {
            super(player, rh.a, pos, face);
            this.hitVec = hitVec;
        }

        public bdu getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(aax player, rh hand) {
            super(player, hand, new co((sm)player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(aax player, rh hand) {
            super(player, hand, new co((sm)player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bdu hitVec;

        public RightClickBlock(aax player, rh hand, co pos, cv face, bdu hitVec) {
            super(player, hand, pos, face);
            this.hitVec = hitVec;
        }

        public bdu getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final sm target;

        public EntityInteract(aax player, rh hand, sm target) {
            super(player, hand, new co(target), null);
            this.target = target;
        }

        public sm getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final bdu localPos;
        private final sm target;

        public EntityInteractSpecific(aax player, rh hand, sm target, bdu localPos) {
            super(player, hand, new co(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public bdu getLocalPos() {
            return this.localPos;
        }

        public sm getTarget() {
            return this.target;
        }
    }
}

